/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.VmClusterUpdateHistoryEntrySummary;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListVmClusterUpdateHistoryEntriesRequest
extends BmcRequest<Void> {
    private String vmClusterId;
    private UpdateType updateType;
    private VmClusterUpdateHistoryEntrySummary.LifecycleState lifecycleState;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getVmClusterId() {
        return this.vmClusterId;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public VmClusterUpdateHistoryEntrySummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().vmClusterId(this.vmClusterId).updateType(this.updateType).lifecycleState(this.lifecycleState).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",vmClusterId=").append(String.valueOf(this.vmClusterId));
        sb.append(",updateType=").append(String.valueOf((Object)this.updateType));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListVmClusterUpdateHistoryEntriesRequest)) {
            return false;
        }
        ListVmClusterUpdateHistoryEntriesRequest other = (ListVmClusterUpdateHistoryEntriesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.vmClusterId, other.vmClusterId) && Objects.equals((Object)this.updateType, (Object)other.updateType) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vmClusterId == null ? 43 : this.vmClusterId.hashCode());
        result = result * 59 + (this.updateType == null ? 43 : this.updateType.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListVmClusterUpdateHistoryEntriesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String vmClusterId = null;
        private UpdateType updateType = null;
        private VmClusterUpdateHistoryEntrySummary.LifecycleState lifecycleState = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder vmClusterId(String vmClusterId) {
            this.vmClusterId = vmClusterId;
            return this;
        }

        public Builder updateType(UpdateType updateType) {
            this.updateType = updateType;
            return this;
        }

        public Builder lifecycleState(VmClusterUpdateHistoryEntrySummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListVmClusterUpdateHistoryEntriesRequest o) {
            this.vmClusterId(o.getVmClusterId());
            this.updateType(o.getUpdateType());
            this.lifecycleState(o.getLifecycleState());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListVmClusterUpdateHistoryEntriesRequest build() {
            ListVmClusterUpdateHistoryEntriesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListVmClusterUpdateHistoryEntriesRequest buildWithoutInvocationCallback() {
            ListVmClusterUpdateHistoryEntriesRequest request = new ListVmClusterUpdateHistoryEntriesRequest();
            request.vmClusterId = this.vmClusterId;
            request.updateType = this.updateType;
            request.lifecycleState = this.lifecycleState;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum UpdateType implements BmcEnum
    {
        GiUpgrade("GI_UPGRADE"),
        GiPatch("GI_PATCH"),
        OsUpdate("OS_UPDATE");

        private final String value;
        private static Map<String, UpdateType> map;

        private UpdateType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UpdateType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid UpdateType: " + key);
        }

        static {
            map = new HashMap<String, UpdateType>();
            for (UpdateType v : UpdateType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

