/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools.versioning;

import eu.hansolo.jdktools.ReleaseStatus;
import eu.hansolo.jdktools.TermOfSupport;
import eu.hansolo.jdktools.util.Helper;
import eu.hansolo.jdktools.util.OutputFormat;
import eu.hansolo.jdktools.versioning.VersionNumber;
import java.util.Objects;

public class SimpleMajorVersion
implements Comparable<SimpleMajorVersion> {
    public static final String FIELD_MAJOR_VERSION = "major_version";
    public static final String FIELD_TERM_OF_SUPPORT = "term_of_support";
    public static final String FIELD_MAINTAINED = "maintained";
    public static final String FIELD_EARLY_ACCESS_ONLY = "early_access_only";
    public static final String FIELD_RELEASE_STATUS = "release_status";
    public static final String FIELD_SCOPE = "scope";
    public static final String FIELD_VERSIONS = "versions";
    private final int featureVersion;
    private final TermOfSupport termOfSupport;
    private ReleaseStatus releaseStatus;

    public SimpleMajorVersion(int majorVersion) {
        this(majorVersion, Helper.getTermOfSupport(majorVersion), ReleaseStatus.GA);
    }

    public SimpleMajorVersion(int featureVersion, TermOfSupport termOfSupport, ReleaseStatus releaseStatus) {
        if (featureVersion <= 0) {
            throw new IllegalArgumentException("Major version cannot be <= 0");
        }
        this.featureVersion = featureVersion;
        this.termOfSupport = termOfSupport;
        this.releaseStatus = releaseStatus;
    }

    public int getAsInt() {
        return this.featureVersion;
    }

    public TermOfSupport getTermOfSupport() {
        return this.termOfSupport;
    }

    public VersionNumber getVersionNumber() {
        return new VersionNumber(this.featureVersion);
    }

    public ReleaseStatus getReleaseStatus() {
        return this.releaseStatus;
    }

    public void setReleaseStatus(ReleaseStatus releaseStatus) {
        this.releaseStatus = releaseStatus;
    }

    public String toString(OutputFormat outputFormat) {
        if (OutputFormat.FULL_COMPRESSED == outputFormat) {
            return "{" + "\"" + FIELD_MAJOR_VERSION + "\"" + ":" + this.featureVersion + "," + "\"" + FIELD_TERM_OF_SUPPORT + "\"" + ":" + "\"" + this.termOfSupport.getApiString() + "\"" + "," + "\"" + FIELD_RELEASE_STATUS + "\"" + ":" + this.releaseStatus.getApiString() + "}";
        }
        return "{" + "\n" + "  \"" + FIELD_MAJOR_VERSION + "\"" + ":" + this.featureVersion + ",\n" + "  \"" + FIELD_TERM_OF_SUPPORT + "\"" + ":" + "\"" + this.termOfSupport.getApiString() + "\"" + ",\n" + "  \"" + FIELD_RELEASE_STATUS + "\"" + ":" + this.releaseStatus.getApiString() + "\n" + "}";
    }

    @Override
    public int compareTo(SimpleMajorVersion other) {
        return Integer.compare(this.featureVersion, other.getAsInt());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleMajorVersion that = (SimpleMajorVersion)o;
        return this.featureVersion == that.featureVersion;
    }

    public int hashCode() {
        return Objects.hash(this.featureVersion, this.termOfSupport, this.releaseStatus);
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }
}

