/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.message.config;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Map;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;

public abstract class AuthConfigFactory {
    private static AuthConfigFactory factory = null;
    public static final String DEFAULT_FACTORY_SECURITY_PROPERTY = "authconfigprovider.factory";
    private static final String PROVIDER_SECURITY_PROPERTY = "authconfigfactory.provider";
    public static final String GET_FACTORY_PERMISSION_NAME = "getProperty.authconfigprovider.factory";
    public static final String SET_FACTORY_PERMISSION_NAME = "setProperty.authconfigprovider.factory";
    public static final String PROVIDER_REGISTRATION_PERMISSION_NAME = "setProperty.authconfigfactory.provider";
    public static final SecurityPermission getFactorySecurityPermission = new SecurityPermission("getProperty.authconfigprovider.factory");
    public static final SecurityPermission setFactorySecurityPermission = new SecurityPermission("setProperty.authconfigprovider.factory");
    public static final SecurityPermission providerRegistrationSecurityPermission = new SecurityPermission("setProperty.authconfigfactory.provider");

    private static void checkPermission(Permission p) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(p);
        }
    }

    public static synchronized AuthConfigFactory getFactory() {
        String className;
        AuthConfigFactory.checkPermission(getFactorySecurityPermission);
        if (factory == null && (className = Security.getProperty(DEFAULT_FACTORY_SECURITY_PROPERTY)) != null) {
            AuthConfigFactory.checkPermission(setFactorySecurityPermission);
            try {
                factory = (AuthConfigFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
                        ClassLoader loader = Thread.currentThread().getContextClassLoader();
                        Class<?> clazz = Class.forName(className, true, loader);
                        return clazz.newInstance();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw new SecurityException(pae.getException());
            }
        }
        return factory;
    }

    public static synchronized void setFactory(AuthConfigFactory factory) {
        AuthConfigFactory.checkPermission(setFactorySecurityPermission);
        AuthConfigFactory.factory = factory;
    }

    public abstract AuthConfigProvider getConfigProvider(String var1, String var2, RegistrationListener var3);

    public abstract String registerConfigProvider(String var1, Map var2, String var3, String var4, String var5);

    public abstract String registerConfigProvider(AuthConfigProvider var1, String var2, String var3, String var4);

    public abstract boolean removeRegistration(String var1);

    public abstract String[] detachListener(RegistrationListener var1, String var2, String var3);

    public abstract String[] getRegistrationIDs(AuthConfigProvider var1);

    public abstract RegistrationContext getRegistrationContext(String var1);

    public abstract void refresh();

    public static interface RegistrationContext {
        public String getMessageLayer();

        public String getAppContext();

        public String getDescription();

        public boolean isPersistent();
    }
}

