/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.lang.DirectionType;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class TermDefinition {
    private String uriMapping;
    private boolean prefixFlag;
    private boolean protectedFlag;
    private boolean reversePropertyFlag;
    private URI baseUrl;
    private JsonValue localContext;
    private Set<String> containerMapping;
    private String indexMapping;
    private String nestValue;
    private String typeMapping;
    private DirectionType directionMapping;
    private JsonValue languageMapping;

    public TermDefinition(boolean prefixFlag, boolean protectedFlag, boolean reversePropertyFlag) {
        this.prefixFlag = prefixFlag;
        this.protectedFlag = protectedFlag;
        this.reversePropertyFlag = reversePropertyFlag;
        this.containerMapping = new HashSet<String>();
    }

    public void setLocalContext(JsonValue context) {
        this.localContext = context;
    }

    protected void setBaseUrl(URI baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getUriMapping() {
        return this.uriMapping;
    }

    protected void setUriMapping(String uriMapping) {
        this.uriMapping = uriMapping;
    }

    public JsonValue getLanguageMapping() {
        return this.languageMapping;
    }

    public DirectionType getDirectionMapping() {
        return this.directionMapping;
    }

    public String getTypeMapping() {
        return this.typeMapping;
    }

    public boolean isPrefix() {
        return this.prefixFlag;
    }

    public boolean isNotPrefix() {
        return !this.prefixFlag;
    }

    protected void setLanguageMapping(JsonValue languageMapping) {
        this.languageMapping = languageMapping;
    }

    protected void addContainerMapping(String mapping) {
        this.containerMapping.add(mapping);
    }

    public Collection<String> getContainerMapping() {
        return this.containerMapping;
    }

    public JsonValue getLocalContext() {
        return this.localContext;
    }

    public URI getBaseUrl() {
        return this.baseUrl;
    }

    public boolean hasLocalContext() {
        return this.localContext != null;
    }

    public boolean isReverseProperty() {
        return this.reversePropertyFlag;
    }

    public String getIndexMapping() {
        return this.indexMapping;
    }

    public String getNestValue() {
        return this.nestValue;
    }

    public boolean isProtected() {
        return this.protectedFlag;
    }

    protected void setIndexMapping(String indexMapping) {
        this.indexMapping = indexMapping;
    }

    protected void setContainerMapping(Set<String> containerMapping) {
        this.containerMapping = containerMapping;
    }

    protected void setPrefix(boolean prefixFlag) {
        this.prefixFlag = prefixFlag;
    }

    protected void setProtected(boolean protectedFlag) {
        this.protectedFlag = protectedFlag;
    }

    protected void setReverseProperty(boolean reversePropertyFlag) {
        this.reversePropertyFlag = reversePropertyFlag;
    }

    protected void setTypeMapping(String typeMapping) {
        this.typeMapping = typeMapping;
    }

    protected void setDirectionMapping(DirectionType directionMapping) {
        this.directionMapping = directionMapping;
    }

    protected void setNestValue(String nestValue) {
        this.nestValue = nestValue;
    }

    public boolean isNotSameExcept(TermDefinition ref) {
        return !Objects.equals(this.uriMapping, ref.uriMapping) || this.prefixFlag != ref.prefixFlag || !Objects.equals(this.reversePropertyFlag, ref.reversePropertyFlag) || !Objects.equals(this.baseUrl, ref.baseUrl) || !Objects.equals(this.containerMapping, ref.containerMapping) || !Objects.equals((Object)this.directionMapping, (Object)ref.directionMapping) || !Objects.equals(this.indexMapping, ref.indexMapping) || !Objects.equals(this.nestValue, ref.nestValue) || !Objects.equals(this.typeMapping, ref.typeMapping) || !Objects.equals(this.languageMapping, ref.languageMapping) || !Objects.equals(this.localContext, ref.localContext);
    }

    public boolean hasContainerMapping(String value) {
        return this.containerMapping != null && this.containerMapping.contains(value);
    }

    public String toString() {
        return "TermDefinition[uriMapping=" + this.uriMapping + ", localContext=" + this.localContext + ", indexMapping=" + this.indexMapping + ", typeMapping=" + this.typeMapping + "]";
    }
}

