/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.edns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.minidns.dnsname.DnsName;
import org.minidns.edns.EdnsOption;
import org.minidns.edns.Nsid;
import org.minidns.edns.UnknownEdnsOption;
import org.minidns.record.Data;
import org.minidns.record.OPT;
import org.minidns.record.Record;

public class Edns {
    public static final int FLAG_DNSSEC_OK = 32768;
    public final int udpPayloadSize;
    public final int extendedRcode;
    public final int version;
    public final int flags;
    public final List<EdnsOption> variablePart;
    public final boolean dnssecOk;
    private Record<OPT> optRecord;
    private String terminalOutputCache;

    public Edns(Record<OPT> optRecord) {
        assert (optRecord.type == Record.TYPE.OPT);
        this.udpPayloadSize = optRecord.clazzValue;
        this.extendedRcode = (int)(optRecord.ttl >> 8 & 0xFFL);
        this.version = (int)(optRecord.ttl >> 16 & 0xFFL);
        this.flags = (int)optRecord.ttl & 0xFFFF;
        this.dnssecOk = (optRecord.ttl & 0x8000L) > 0L;
        OPT opt = (OPT)optRecord.payloadData;
        this.variablePart = opt.variablePart;
        this.optRecord = optRecord;
    }

    public Edns(Builder builder) {
        this.udpPayloadSize = builder.udpPayloadSize;
        this.extendedRcode = builder.extendedRcode;
        this.version = builder.version;
        int flags = 0;
        if (builder.dnssecOk) {
            flags |= 0x8000;
        }
        this.dnssecOk = builder.dnssecOk;
        this.flags = flags;
        this.variablePart = builder.variablePart != null ? builder.variablePart : Collections.emptyList();
    }

    public <O extends EdnsOption> O getEdnsOption(OptionCode optionCode) {
        for (EdnsOption o : this.variablePart) {
            if (!o.getOptionCode().equals((Object)optionCode)) continue;
            return (O)o;
        }
        return null;
    }

    public Record<OPT> asRecord() {
        if (this.optRecord == null) {
            long optFlags = this.flags;
            optFlags |= (long)(this.extendedRcode << 8);
            this.optRecord = new Record<OPT>(DnsName.ROOT, Record.TYPE.OPT, this.udpPayloadSize, optFlags |= (long)(this.version << 16), new OPT(this.variablePart));
        }
        return this.optRecord;
    }

    public String asTerminalOutput() {
        if (this.terminalOutputCache == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("EDNS: version: ").append(this.version).append(", flags:");
            if (this.dnssecOk) {
                sb.append(" do");
            }
            sb.append("; udp: ").append(this.udpPayloadSize);
            if (!this.variablePart.isEmpty()) {
                sb.append('\n');
                Iterator<EdnsOption> it = this.variablePart.iterator();
                while (it.hasNext()) {
                    EdnsOption edns = it.next();
                    sb.append((Object)edns.getOptionCode()).append(": ");
                    sb.append(edns.asTerminalOutput());
                    if (!it.hasNext()) continue;
                    sb.append('\n');
                }
            }
            this.terminalOutputCache = sb.toString();
        }
        return this.terminalOutputCache;
    }

    public String toString() {
        return this.asTerminalOutput();
    }

    public static Edns fromRecord(Record<? extends Data> record) {
        if (record.type != Record.TYPE.OPT) {
            return null;
        }
        Record<? extends Data> optRecord = record;
        return new Edns(optRecord);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int udpPayloadSize;
        private int extendedRcode;
        private int version;
        private boolean dnssecOk;
        private List<EdnsOption> variablePart;

        private Builder() {
        }

        public Builder setUdpPayloadSize(int udpPayloadSize) {
            if (udpPayloadSize > 65535) {
                throw new IllegalArgumentException("UDP payload size must not be greater than 65536, was " + udpPayloadSize);
            }
            this.udpPayloadSize = udpPayloadSize;
            return this;
        }

        public Builder setDnssecOk(boolean dnssecOk) {
            this.dnssecOk = dnssecOk;
            return this;
        }

        public Builder setDnssecOk() {
            this.dnssecOk = true;
            return this;
        }

        public Builder addEdnsOption(EdnsOption ednsOption) {
            if (this.variablePart == null) {
                this.variablePart = new ArrayList<EdnsOption>(4);
            }
            this.variablePart.add(ednsOption);
            return this;
        }

        public Edns build() {
            return new Edns(this);
        }
    }

    public static enum OptionCode {
        UNKNOWN(-1, UnknownEdnsOption.class),
        NSID(3, Nsid.class);

        private static Map<Integer, OptionCode> INVERSE_LUT;
        public final int asInt;
        public final Class<? extends EdnsOption> clazz;

        private OptionCode(int optionCode, Class<? extends EdnsOption> clazz) {
            this.asInt = optionCode;
            this.clazz = clazz;
        }

        public static OptionCode from(int optionCode) {
            OptionCode res = INVERSE_LUT.get(optionCode);
            if (res == null) {
                res = UNKNOWN;
            }
            return res;
        }

        static {
            INVERSE_LUT = new HashMap<Integer, OptionCode>(OptionCode.values().length);
            for (OptionCode optionCode : OptionCode.values()) {
                INVERSE_LUT.put(optionCode.asInt, optionCode);
            }
        }
    }
}

