/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.api.CommentsLevel;
import jadx.api.ICodeWriter;
import jadx.api.JadxArgs;
import jadx.api.metadata.annotations.InsnCodeOffset;
import jadx.api.metadata.annotations.VarNode;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.types.AnnotationMethodParamsAttr;
import jadx.core.Jadx;
import jadx.core.codegen.AnnotationGen;
import jadx.core.codegen.ClassGen;
import jadx.core.codegen.InsnGen;
import jadx.core.codegen.NameGen;
import jadx.core.codegen.RegionGen;
import jadx.core.codegen.SimpleModeHelper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.JadxError;
import jadx.core.dex.attributes.nodes.JumpInfo;
import jadx.core.dex.attributes.nodes.MethodOverrideAttr;
import jadx.core.dex.attributes.nodes.MethodReplaceAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.ConstStringNode;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.CodeVar;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.visitors.DepthTraversal;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.utils.CodeGenUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.CodegenException;
import jadx.core.utils.exceptions.JadxOverflowException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodGen {
    private static final Logger LOG = LoggerFactory.getLogger(MethodGen.class);
    private final MethodNode mth;
    private final ClassGen classGen;
    private final AnnotationGen annotationGen;
    private final NameGen nameGen;

    public MethodGen(ClassGen classGen, MethodNode mth) {
        this.mth = mth;
        this.classGen = classGen;
        this.annotationGen = classGen.getAnnotationGen();
        this.nameGen = new NameGen(mth, classGen);
    }

    public ClassGen getClassGen() {
        return this.classGen;
    }

    public NameGen getNameGen() {
        return this.nameGen;
    }

    public MethodNode getMethodNode() {
        return this.mth;
    }

    public boolean addDefinition(ICodeWriter code) {
        EncodedValue def;
        if (this.mth.getMethodInfo().isClassInit()) {
            code.attachDefinition(this.mth);
            code.startLine("static");
            return true;
        }
        if (this.mth.contains(AFlag.ANONYMOUS_CONSTRUCTOR)) {
            code.startLine();
            code.attachDefinition(this.mth);
            return false;
        }
        this.addOverrideAnnotation(code, this.mth);
        this.annotationGen.addForMethod(code, this.mth);
        AccessInfo clsAccFlags = this.mth.getParentClass().getAccessFlags();
        AccessInfo ai = this.mth.getAccessFlags();
        if (clsAccFlags.isInterface()) {
            ai = ai.remove(1024);
            ai = ai.remove(1);
        }
        if (clsAccFlags.isAnnotation()) {
            ai = ai.remove(1);
        }
        if (this.mth.getMethodInfo().isConstructor() && this.mth.getParentClass().isEnum()) {
            ai = ai.remove(7);
        }
        if (this.mth.getMethodInfo().hasAlias() && !ai.isConstructor()) {
            CodeGenUtils.addRenamedComment(code, this.mth, this.mth.getName());
        }
        if (this.mth.contains(AFlag.INCONSISTENT_CODE) && this.mth.checkCommentsLevel(CommentsLevel.ERROR)) {
            code.startLine("/*");
            code.incIndent();
            code.startLine("Code decompiled incorrectly, please refer to instructions dump.");
            if (!this.mth.root().getArgs().isShowInconsistentCode()) {
                if (code.isMetadataSupported()) {
                    code.startLine("To view partially-correct code enable 'Show inconsistent code' option in preferences");
                } else {
                    code.startLine("To view partially-correct add '--show-bad-code' argument");
                }
            }
            code.decIndent();
            code.startLine("*/");
        }
        code.startLineWithNum(this.mth.getSourceLine());
        code.add(ai.makeString(this.mth.checkCommentsLevel(CommentsLevel.INFO)));
        if (clsAccFlags.isInterface() && !this.mth.isNoCode() && !this.mth.getAccessFlags().isStatic()) {
            code.add("default ");
        }
        if (this.classGen.addGenericTypeParameters(code, this.mth.getTypeParameters(), false)) {
            code.add(' ');
        }
        if (ai.isConstructor()) {
            code.attachDefinition(this.mth);
            code.add(this.classGen.getClassNode().getShortName());
        } else {
            this.classGen.useType(code, this.mth.getReturnType());
            code.add(' ');
            MethodNode defMth = this.getMethodForDefinition();
            code.attachDefinition(defMth);
            code.add(defMth.getAlias());
        }
        code.add('(');
        List<RegisterArg> args = this.mth.getArgRegs();
        if (this.mth.getMethodInfo().isConstructor() && this.mth.getParentClass().contains(AType.ENUM_CLASS)) {
            if (args.size() == 2) {
                args = Collections.emptyList();
            } else if (args.size() > 2) {
                args = args.subList(2, args.size());
            } else {
                this.mth.addWarnComment("Incorrect number of args for enum constructor: " + args.size() + " (expected >= 2)");
            }
        } else if (this.mth.contains(AFlag.SKIP_FIRST_ARG)) {
            args = args.subList(1, args.size());
        }
        this.addMethodArguments(code, args);
        code.add(')');
        this.annotationGen.addThrows(this.mth, code);
        if (this.mth.getParentClass().getAccessFlags().isAnnotation() && (def = this.annotationGen.getAnnotationDefaultValue(this.mth)) != null) {
            code.add(" default ");
            this.annotationGen.encodeValue(this.mth.root(), code, def);
        }
        return true;
    }

    private MethodNode getMethodForDefinition() {
        MethodReplaceAttr replaceAttr = this.mth.get(AType.METHOD_REPLACE);
        if (replaceAttr != null) {
            return replaceAttr.getReplaceMth();
        }
        return this.mth;
    }

    private void addOverrideAnnotation(ICodeWriter code, MethodNode mth) {
        MethodOverrideAttr overrideAttr = mth.get(AType.METHOD_OVERRIDE);
        if (overrideAttr == null) {
            return;
        }
        if (!overrideAttr.getBaseMethods().contains(mth)) {
            code.startLine("@Override");
            if (mth.checkCommentsLevel(CommentsLevel.INFO)) {
                code.add(" // ");
                code.add(Utils.listToString(overrideAttr.getOverrideList(), ", ", md -> md.getMethodInfo().getDeclClass().getAliasFullName()));
            }
        }
    }

    private void addMethodArguments(ICodeWriter code, List<RegisterArg> args) {
        AnnotationMethodParamsAttr paramsAnnotation = (AnnotationMethodParamsAttr)this.mth.get(JadxAttrType.ANNOTATION_MTH_PARAMETERS);
        int i = 0;
        Iterator<RegisterArg> it = args.iterator();
        while (it.hasNext()) {
            ArgType varType;
            RegisterArg mthArg = it.next();
            SSAVar ssaVar = mthArg.getSVar();
            CodeVar var = ssaVar == null ? CodeVar.fromMthArg(mthArg, this.classGen.isFallbackMode()) : ssaVar.getCodeVar();
            if (paramsAnnotation != null) {
                this.annotationGen.addForParameter(code, paramsAnnotation, i);
            }
            if (var.isFinal()) {
                code.add("final ");
            }
            ArgType argType = (varType = var.getType()) == null || varType == ArgType.UNKNOWN ? mthArg.getInitType() : varType;
            if (!it.hasNext() && this.mth.getAccessFlags().isVarArgs()) {
                if (argType.isArray()) {
                    ArgType elType = argType.getArrayElement();
                    this.classGen.useType(code, elType);
                    code.add("...");
                } else {
                    this.mth.addWarnComment("Last argument in varargs method is not array: " + var);
                    this.classGen.useType(code, argType);
                }
            } else {
                this.classGen.useType(code, argType);
            }
            code.add(' ');
            String varName = this.nameGen.assignArg(var);
            if (code.isMetadataSupported() && ssaVar != null) {
                code.attachDefinition(VarNode.get(this.mth, var));
            }
            code.add(varName);
            ++i;
            if (!it.hasNext()) continue;
            code.add(", ");
        }
    }

    public void addInstructions(ICodeWriter code) throws CodegenException {
        JadxArgs args = this.mth.root().getArgs();
        switch (args.getDecompilationMode()) {
            case AUTO: {
                if (this.classGen.isFallbackMode()) {
                    this.dumpInstructions(code);
                    break;
                }
                this.addRegionInsns(code);
                break;
            }
            case RESTRUCTURE: {
                this.addRegionInsns(code);
                break;
            }
            case SIMPLE: {
                this.addSimpleMethodCode(code);
                break;
            }
            case FALLBACK: {
                this.addFallbackMethodCode(code, FallbackOption.FALLBACK_MODE);
            }
        }
    }

    public void addRegionInsns(ICodeWriter code) throws CodegenException {
        try {
            RegionGen regionGen = new RegionGen(this);
            regionGen.makeRegion(code, this.mth.getRegion());
        }
        catch (BootstrapMethodError | StackOverflowError e) {
            this.mth.addError("Method code generation error", new JadxOverflowException("StackOverflow"));
            CodeGenUtils.addErrors(code, this.mth);
            this.dumpInstructions(code);
        }
        catch (Exception e) {
            if (this.mth.getParentClass().getTopParentClass().contains(AFlag.RESTART_CODEGEN)) {
                throw e;
            }
            this.mth.addError("Method code generation error", e);
            CodeGenUtils.addErrors(code, this.mth);
            this.dumpInstructions(code);
        }
    }

    private void addSimpleMethodCode(ICodeWriter code) {
        if (this.mth.getBasicBlocks() == null) {
            code.startLine("// Blocks not ready for simple mode, using fallback");
            this.addFallbackMethodCode(code, FallbackOption.FALLBACK_MODE);
            return;
        }
        JadxArgs args = this.mth.root().getArgs();
        ICodeWriter tmpCode = args.getCodeWriterProvider().apply(args);
        try {
            tmpCode.setIndent(code.getIndent());
            this.generateSimpleCode(tmpCode);
            code.add(tmpCode);
        }
        catch (Exception e) {
            this.mth.addError("Simple mode code generation failed", e);
            CodeGenUtils.addError(code, "Simple mode code generation failed", e);
            this.dumpInstructions(code);
        }
    }

    private void generateSimpleCode(ICodeWriter code) throws CodegenException {
        SimpleModeHelper helper = new SimpleModeHelper(this.mth);
        List<BlockNode> blocks = helper.prepareBlocks();
        InsnGen insnGen = new InsnGen(this, true);
        for (BlockNode block : blocks) {
            if (block.contains(AFlag.DONT_GENERATE)) continue;
            if (helper.isNeedStartLabel(block)) {
                code.decIndent();
                code.startLine(MethodGen.getLabelName(block)).add(':');
                code.incIndent();
            }
            for (InsnNode insn : block.getInstructions()) {
                CodeVar codeVar;
                if (insn.contains(AFlag.DONT_GENERATE)) continue;
                if (insn.getResult() != null && !(codeVar = insn.getResult().getSVar().getCodeVar()).isDeclared()) {
                    insn.add(AFlag.DECLARE_VAR);
                    codeVar.setDeclared(true);
                }
                InsnCodeOffset.attach(code, insn);
                insnGen.makeInsn(insn, code);
                this.addCatchComment(code, insn, false);
                CodeGenUtils.addCodeComments(code, this.mth, insn);
            }
            if (!helper.isNeedEndGoto(block)) continue;
            code.startLine("goto ").add(MethodGen.getLabelName(block.getSuccessors().get(0)));
        }
    }

    public void dumpInstructions(ICodeWriter code) {
        if (this.mth.checkCommentsLevel(CommentsLevel.ERROR)) {
            code.startLine("/*");
            this.addFallbackMethodCode(code, FallbackOption.COMMENTED_DUMP);
            code.startLine("*/");
        }
        code.startLine("throw new UnsupportedOperationException(\"Method not decompiled: ").add(this.mth.getParentClass().getClassInfo().getAliasFullName()).add('.').add(this.mth.getAlias()).add('(').add(Utils.listToString(this.mth.getMethodInfo().getArgumentsTypes())).add("):").add(this.mth.getMethodInfo().getReturnType().toString()).add("\");");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFallbackMethodCode(ICodeWriter code, FallbackOption fallbackOption) {
        long insnCountEstimate;
        InsnNode[] insnArr;
        if (fallbackOption != FallbackOption.FALLBACK_MODE) {
            List<JadxError> errors = this.mth.getAll(AType.JADX_ERROR);
            try {
                this.mth.unload();
                this.mth.load();
                for (IDexTreeVisitor visitor : Jadx.getFallbackPassesList()) {
                    DepthTraversal.visit(visitor, this.mth);
                }
                errors.forEach(err -> this.mth.addAttr(AType.JADX_ERROR, err));
            }
            catch (Exception e) {
                LOG.error("Error reload instructions in fallback mode:", (Throwable)e);
                code.startLine("// Can't load method instructions: " + e.getMessage());
                return;
            }
            finally {
                errors.forEach(err -> this.mth.addAttr(AType.JADX_ERROR, err));
            }
        }
        if ((insnArr = this.mth.getInstructions()) == null) {
            code.startLine("// Can't load method instructions.");
            return;
        }
        if (fallbackOption == FallbackOption.COMMENTED_DUMP && this.mth.getCommentsLevel() != CommentsLevel.DEBUG && (insnCountEstimate = Stream.of(insnArr).filter(Objects::nonNull).filter(insn -> insn.getType() != InsnType.NOP).count()) > 100L) {
            code.incIndent();
            code.startLine("Method dump skipped, instructions count: " + insnArr.length);
            if (code.isMetadataSupported()) {
                code.startLine("To view this dump change 'Code comments level' option to 'DEBUG'");
            } else {
                code.startLine("To view this dump add '--comments-level debug' option");
            }
            code.decIndent();
            return;
        }
        code.incIndent();
        if (this.mth.getThisArg() != null) {
            code.startLine(this.nameGen.useArg(this.mth.getThisArg())).add(" = this;");
        }
        MethodGen.addFallbackInsns(code, this.mth, insnArr, fallbackOption);
        code.decIndent();
    }

    public static void addFallbackInsns(ICodeWriter code, MethodNode mth, InsnNode[] insnArr, FallbackOption option) {
        int startIndent = code.getIndent();
        MethodGen methodGen = MethodGen.getFallbackMethodGen(mth);
        InsnGen insnGen = new InsnGen(methodGen, true);
        InsnNode prevInsn = null;
        for (InsnNode insn : insnArr) {
            if (insn == null) continue;
            methodGen.dumpInsn(code, insnGen, option, startIndent, prevInsn, insn);
            prevInsn = insn;
        }
    }

    private boolean dumpInsn(ICodeWriter code, InsnGen insnGen, FallbackOption option, int startIndent, @Nullable InsnNode prevInsn, InsnNode insn) {
        if (insn.contains(AType.JADX_ERROR)) {
            for (JadxError error : insn.getAll(AType.JADX_ERROR)) {
                code.startLine("// ").add(error.getError());
            }
            return true;
        }
        if (option != FallbackOption.BLOCK_DUMP && MethodGen.needLabel(insn, prevInsn)) {
            code.decIndent();
            code.startLine(MethodGen.getLabelName(insn.getOffset()) + ':');
            code.incIndent();
        }
        if (insn.getType() == InsnType.NOP) {
            return true;
        }
        try {
            ArgType varType;
            boolean escapeComment = MethodGen.isCommentEscapeNeeded(insn, option);
            if (escapeComment) {
                code.decIndent();
                code.startLine("*/");
                code.startLine("//  ");
            } else {
                code.startLineWithNum(insn.getSourceLine());
            }
            InsnCodeOffset.attach(code, insn);
            RegisterArg resArg = insn.getResult();
            if (resArg != null && (varType = resArg.getInitType()).isTypeKnown()) {
                code.add(varType.toString()).add(' ');
            }
            insnGen.makeInsn(insn, code, InsnGen.Flags.INLINE);
            if (escapeComment) {
                code.startLine("/*");
                code.incIndent();
            }
            this.addCatchComment(code, insn, true);
            CodeGenUtils.addCodeComments(code, this.mth, insn);
        }
        catch (Exception e) {
            LOG.debug("Error generate fallback instruction: ", e.getCause());
            code.setIndent(startIndent);
            code.startLine("// error: " + insn);
        }
        return false;
    }

    private void addCatchComment(ICodeWriter code, InsnNode insn, boolean raw) {
        CatchAttr catchAttr = insn.get(AType.EXC_CATCH);
        if (catchAttr == null) {
            return;
        }
        code.add("     // Catch:");
        for (ExceptionHandler handler : catchAttr.getHandlers()) {
            code.add(' ');
            this.classGen.useClass(code, handler.getArgType());
            code.add(" -> ");
            if (raw) {
                code.add(MethodGen.getLabelName(handler.getHandlerOffset()));
                continue;
            }
            code.add(MethodGen.getLabelName(handler.getHandlerBlock()));
        }
    }

    private static boolean isCommentEscapeNeeded(InsnNode insn, FallbackOption option) {
        if (option == FallbackOption.COMMENTED_DUMP && insn.getType() == InsnType.CONST_STR) {
            String str = ((ConstStringNode)insn).getString();
            return str.contains("*/");
        }
        return false;
    }

    private static boolean needLabel(InsnNode insn, InsnNode prevInsn) {
        if (insn.contains(AType.EXC_HANDLER)) {
            return true;
        }
        if (insn.contains(AType.JUMP)) {
            JumpInfo jump;
            List jumps;
            if (prevInsn != null && prevInsn.getType() == InsnType.IF && (jumps = insn.getAll(AType.JUMP)).size() == 1 && (jump = (JumpInfo)jumps.get(0)).getSrc() == prevInsn.getOffset() && jump.getDest() == insn.getOffset()) {
                int target = ((IfNode)prevInsn).getTarget();
                return insn.getOffset() == target;
            }
            return true;
        }
        return false;
    }

    public static MethodGen getFallbackMethodGen(MethodNode mth) {
        ClassGen clsGen = new ClassGen(mth.getParentClass(), null, false, true, true);
        return new MethodGen(clsGen, mth);
    }

    public static String getLabelName(BlockNode block) {
        return String.format("L%d", block.getId());
    }

    public static String getLabelName(IfNode insn) {
        BlockNode thenBlock = insn.getThenBlock();
        if (thenBlock != null) {
            return MethodGen.getLabelName(thenBlock);
        }
        return MethodGen.getLabelName(insn.getTarget());
    }

    public static String getLabelName(int offset) {
        if (offset < 0) {
            return String.format("LB_%x", -offset);
        }
        return String.format("L%x", offset);
    }

    private static /* synthetic */ String lambda$addOverrideAnnotation$1(MethodNode m) {
        return m.getParentClass().getFullName();
    }

    public static enum FallbackOption {
        FALLBACK_MODE,
        BLOCK_DUMP,
        COMMENTED_DUMP;

    }
}

