/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.api.metadata.ICodeAnnotation;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.FieldNode;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

public final class JavaField
implements JavaNode {
    private final FieldNode field;
    private final JavaClass parent;

    JavaField(JavaClass cls, FieldNode f) {
        this.field = f;
        this.parent = cls;
    }

    @Override
    public String getName() {
        return this.field.getAlias();
    }

    @Override
    public String getFullName() {
        return this.parent.getFullName() + '.' + this.getName();
    }

    public String getRawName() {
        return this.field.getName();
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.parent;
    }

    @Override
    public JavaClass getTopParentClass() {
        return this.parent.getTopParentClass();
    }

    public AccessInfo getAccessFlags() {
        return this.field.getAccessFlags();
    }

    public ArgType getType() {
        return ArgType.tryToResolveClassAlias(this.field.root(), this.field.getType());
    }

    @Override
    public int getDefPos() {
        return this.field.getDefPosition();
    }

    @Override
    public List<JavaNode> getUseIn() {
        return this.getDeclaringClass().getRootDecompiler().convertNodes(this.field.getUseIn());
    }

    @Override
    public void removeAlias() {
        this.field.getFieldInfo().removeAlias();
    }

    @Override
    public boolean isOwnCodeAnnotation(ICodeAnnotation ann) {
        if (ann.getAnnType() == ICodeAnnotation.AnnType.FIELD) {
            return ann.equals(this.field);
        }
        return false;
    }

    @ApiStatus.Internal
    public FieldNode getFieldNode() {
        return this.field;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof JavaField && this.field.equals(((JavaField)o).field);
    }

    public String toString() {
        return this.field.toString();
    }
}

