/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.code;

import jadx.api.plugins.input.data.ICatch;
import jadx.api.plugins.input.data.ICodeReader;
import jadx.api.plugins.input.data.IDebugInfo;
import jadx.api.plugins.input.data.ITry;
import jadx.api.plugins.input.data.impl.CatchData;
import jadx.api.plugins.input.data.impl.DebugInfo;
import jadx.api.plugins.input.insns.InsnData;
import jadx.plugins.input.java.data.ConstPoolReader;
import jadx.plugins.input.java.data.DataReader;
import jadx.plugins.input.java.data.JavaClassData;
import jadx.plugins.input.java.data.attributes.JavaAttrStorage;
import jadx.plugins.input.java.data.attributes.JavaAttrType;
import jadx.plugins.input.java.data.attributes.debuginfo.JavaLocalVar;
import jadx.plugins.input.java.data.attributes.debuginfo.LineNumberTableAttr;
import jadx.plugins.input.java.data.attributes.debuginfo.LocalVarTypesAttr;
import jadx.plugins.input.java.data.attributes.debuginfo.LocalVarsAttr;
import jadx.plugins.input.java.data.code.CodeDecodeState;
import jadx.plugins.input.java.data.code.JavaInsnData;
import jadx.plugins.input.java.data.code.JavaInsnInfo;
import jadx.plugins.input.java.data.code.JavaInsnsRegister;
import jadx.plugins.input.java.data.code.trycatch.JavaSingleCatch;
import jadx.plugins.input.java.data.code.trycatch.JavaTryData;
import jadx.plugins.input.java.utils.JavaClassParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class JavaCodeReader
implements ICodeReader {
    private final JavaClassData clsData;
    private final DataReader reader;
    private final int codeOffset;

    public JavaCodeReader(JavaClassData clsData, int offset) {
        this.clsData = clsData;
        this.reader = clsData.getData();
        this.codeOffset = offset;
    }

    public ICodeReader copy() {
        return this;
    }

    public void visitInstructions(Consumer<InsnData> insnConsumer) {
        int payloadSize;
        Set<Integer> excHandlers = this.getExcHandlers();
        int maxStack = this.readMaxStack();
        this.reader.skip(2);
        int codeSize = this.reader.readU4();
        CodeDecodeState state = new CodeDecodeState(this.clsData, this.reader, maxStack, excHandlers);
        JavaInsnData insn = new JavaInsnData(state);
        state.setInsn(insn);
        for (int offset = 0; offset < codeSize; offset += 1 + payloadSize) {
            insn.setDecoded(false);
            insn.setOffset(offset);
            insn.setInsnStart(this.reader.getOffset());
            int opcode = this.reader.readU1();
            JavaInsnInfo insnInfo = JavaInsnsRegister.get(opcode);
            if (insnInfo == null) {
                throw new JavaClassParseException("Unknown opcode: 0x" + Integer.toHexString(opcode));
            }
            insn.setInsnInfo(insnInfo);
            insn.setInsnInfo(insnInfo);
            insn.setRegsCount(insnInfo.getRegsCount());
            insn.setOpcode(insnInfo.getApiOpcode());
            insn.setPayloadSize(insnInfo.getPayloadSize());
            insn.setOpcodeUnit(opcode);
            insn.setPayload(null);
            state.onInsn(offset);
            insnConsumer.accept(insn);
            payloadSize = insn.getPayloadSize();
            if (insn.isDecoded()) continue;
            if (payloadSize == -1) {
                insn.skip();
                payloadSize = insn.getPayloadSize();
                continue;
            }
            this.reader.skip(payloadSize);
        }
    }

    public int getRegistersCount() {
        int maxStack = this.readMaxStack();
        int maxLocals = this.reader.readU2();
        return maxStack + maxLocals;
    }

    public int getArgsStartReg() {
        return this.readMaxStack();
    }

    private int readMaxStack() {
        this.reader.absPos(this.codeOffset);
        int maxStack = this.reader.readU2();
        return maxStack + 1;
    }

    public int getUnitsCount() {
        return this.reader.absPos(this.codeOffset + 4).readU4();
    }

    @Nullable
    public IDebugInfo getDebugInfo() {
        List<Object> vars;
        Map<Object, Object> linesMap;
        int maxStack = this.readMaxStack();
        this.reader.skip(2);
        this.reader.skip(this.reader.readU4());
        this.reader.skip(this.reader.readU2() * 8);
        JavaAttrStorage attrs = this.clsData.getAttributesReader().load(this.reader);
        LineNumberTableAttr linesAttr = attrs.get(JavaAttrType.LINE_NUMBER_TABLE);
        LocalVarsAttr varsAttr = attrs.get(JavaAttrType.LOCAL_VAR_TABLE);
        if (linesAttr == null && varsAttr == null) {
            return null;
        }
        Map<Object, Object> map = linesMap = linesAttr != null ? linesAttr.getLineMap() : Collections.emptyMap();
        if (varsAttr == null) {
            vars = Collections.emptyList();
        } else {
            List<JavaLocalVar> javaVars = varsAttr.getVars();
            LocalVarTypesAttr typedVars = attrs.get(JavaAttrType.LOCAL_VAR_TYPE_TABLE);
            if (typedVars != null && !typedVars.getVars().isEmpty()) {
                HashMap varsMap = new HashMap(javaVars.size());
                javaVars.forEach(v -> varsMap.put(v, v));
                for (JavaLocalVar typedVar : typedVars.getVars()) {
                    JavaLocalVar jv = (JavaLocalVar)varsMap.get(typedVar);
                    if (jv == null) continue;
                    jv.setSignature(typedVar.getSignature());
                }
            }
            javaVars.forEach(v -> v.shiftRegNum(maxStack));
            vars = Collections.unmodifiableList(javaVars);
        }
        return new DebugInfo(linesMap, vars);
    }

    public int getCodeOffset() {
        return this.codeOffset;
    }

    public List<ITry> getTries() {
        this.skipToTries();
        int excTableLen = this.reader.readU2();
        if (excTableLen == 0) {
            return Collections.emptyList();
        }
        ConstPoolReader constPool = this.clsData.getConstPoolReader();
        HashMap<JavaTryData, List> tries = new HashMap<JavaTryData, List>(excTableLen);
        for (int i = 0; i < excTableLen; ++i) {
            int start = this.reader.readU2();
            int end = this.reader.readU2();
            int handler = this.reader.readU2();
            int type = this.reader.readU2();
            JavaTryData tryData = new JavaTryData(start, end);
            List catches = tries.computeIfAbsent(tryData, k -> new ArrayList());
            if (type == 0) {
                catches.add(new JavaSingleCatch(handler, null));
                continue;
            }
            catches.add(new JavaSingleCatch(handler, constPool.getClass(type)));
        }
        return tries.entrySet().stream().map(e -> {
            JavaTryData tryData = (JavaTryData)e.getKey();
            tryData.setCatch((ICatch)JavaCodeReader.convertSingleCatches((List)e.getValue()));
            return tryData;
        }).collect(Collectors.toList());
    }

    private static CatchData convertSingleCatches(List<JavaSingleCatch> list) {
        int allHandler = -1;
        for (JavaSingleCatch singleCatch : list) {
            if (singleCatch.getType() != null) continue;
            allHandler = singleCatch.getHandler();
            list.remove(singleCatch);
            break;
        }
        int len = list.size();
        int[] handlers = new int[len];
        String[] types = new String[len];
        for (int i = 0; i < len; ++i) {
            JavaSingleCatch singleCatch = list.get(i);
            handlers[i] = singleCatch.getHandler();
            types[i] = singleCatch.getType();
        }
        return new CatchData(handlers, types, allHandler);
    }

    private Set<Integer> getExcHandlers() {
        this.skipToTries();
        int excTableLen = this.reader.readU2();
        if (excTableLen == 0) {
            return Collections.emptySet();
        }
        HashSet<Integer> set = new HashSet<Integer>(excTableLen);
        for (int i = 0; i < excTableLen; ++i) {
            this.reader.skip(4);
            int handler = this.reader.readU2();
            this.reader.skip(2);
            set.add(handler);
        }
        return set;
    }

    private void skipToTries() {
        this.reader.absPos(this.codeOffset + 4);
        int codeSize = this.reader.readU4();
        this.reader.skip(codeSize);
    }
}

