/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal.jni;

import java.util.logging.Level;
import java.util.logging.Logger;

public class NativeLogger {
    static final Logger LOGGER = Logger.getLogger(NativeLogger.class.getName());

    public static void log(int level, String message) {
        LOGGER.log(LogLevel.values()[level].getLevel(), message);
    }

    public static int getLogLevel() {
        Level effectiveLevel;
        Logger effectiveLogger = LOGGER;
        while ((effectiveLevel = effectiveLogger.getLevel()) == null) {
            if ((effectiveLogger = effectiveLogger.getParent()) == null) {
                throw new AssertionError((Object)"Effective log level is not set");
            }
        }
        for (LogLevel logLevel : LogLevel.values()) {
            if (!logLevel.getLevel().equals(effectiveLevel)) continue;
            return logLevel.ordinal();
        }
        throw new AssertionError((Object)("Unknown effective log level found: " + effectiveLevel));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LogLevel {
        ALL(Level.ALL),
        FINEST(Level.FINEST),
        FINER(Level.FINER),
        FINE(Level.FINE),
        CONFIG(Level.CONFIG),
        INFO(Level.INFO),
        WARNING(Level.WARNING),
        SEVERE(Level.SEVERE),
        OFF(Level.OFF);

        private final Level delegate;

        private LogLevel(Level delegate) {
            this.delegate = delegate;
        }

        Level getLevel() {
            return this.delegate;
        }
    }
}

