@props([
    'responsive' => false, // crop text at given breakpoint sm,md,lg,xl, etc
])

@if(LibrenmsConfig::get('title_image'))
    <img {{ $attributes }} src="{{ asset(LibrenmsConfig::get('title_image')) }}" alt="{{ LibrenmsConfig::get('project_name') }}">
@else
    <svg {{ $attributes->class(['tw:dark:text-white', 'tw:text-gray-600'])->class($responsive ? ['tw:hidden', "tw:$responsive:inline-block"] : []) }}
         xmlns="http://www.w3.org/2000/svg" viewBox="0 0 170 32.275086">
        <defs>
            <clipPath id="a">
                <path d="M0 102.05h453.54V0H0v102.05z"/>
            </clipPath>
            <clipPath id="b">
                <path d="M162.4 71.84h8.16V27.6h-8.16v44.24z"/>
            </clipPath>
            <clipPath id="c">
                <path d="M118.17 73.02h161.68v-45.4H118.17V73z"/>
            </clipPath>
            <clipPath id="d">
                <path d="M283.72 73.35h154.62v-46H283.72v46z"/>
            </clipPath>
        </defs>
        <g clip-path="url(#a)" transform="matrix(.41103 0 0 -.42925 -10.172 37.96)">
            <g clip-path="url(#c)">
                <path
                    d="M273.7 48.47v4.4c0 2.68-4.25 4.02-12.78 4.02-1.05 0-2.15-.1-3.3-.1l-1.5-.1c-6.33 0-9.5-1.4-9.5-4.2v-4.1h27.1zm6.15 5.03v-8.6c0-2.17-.6-3.25-1.76-3.25h-31.3c-.2-4.06 1.9-6.47 6.2-7.23h24.4c1 0 1.6-.37 2-1.1.2-.54.3-1.45.3-2.77 0-1.96-.8-2.94-2.4-2.94h-20.8l-.2.1c-2.4.1-4.1.1-5.1.3-3.5.4-6.1 1.5-7.7 3.1-2.3 2.3-3.5 5-3.5 8v13.1c0 4.2 1.8 7.2 5.4 9.2 2.64 1.5 5.86 2.2 9.65 2.2H267c3.1 0 5.82-.7 8.15-2 3.03-1.8 4.54-4.4 4.54-7.9M169.7 57.6V30.54c0-1.96-.8-2.94-2.36-2.94-1.43 0-2.32.1-2.68.27-.8.37-1.22 1.27-1.22 2.68V57.6c0 1.93.78 2.9 2.35 2.9 1.4 0 2.3-.07 2.6-.22.8-.38 1.2-1.27 1.2-2.7m-.4 13.25c.8-.74 1.3-1.75 1.3-3.02 0-1.2-.4-2.2-1.3-3-.8-.6-1.7-1-2.8-1-1.1 0-2.1.4-2.8 1-.9.8-1.3 1.8-1.3 3 0 1.3.4 2.3 1.2 3.1.7.7 1.7 1 2.8 1 1.1 0 2-.3 2.8-1M235 63.4c1.5 0 2.3-1.25 2.3-3.74 0-1.93-.8-2.9-2.38-2.9h-2.7c-4.84 0-7.25-1.5-7.25-4.5V30.5c0-1.45-.43-2.35-1.28-2.7-.4-.15-1.3-.22-2.8-.22-1.6 0-2.4 1-2.4 3l.1 21.7c0 7.4 5.4 11.1 16.2 11.1M208.6 39.1v12.77c0 3.1-2.82 4.63-8.5 4.63h-18.8V38.7c0-1.6 1.36-2.8 4.08-3.62 1.9-.6 3.82-.9 5.75-.9h8.96c2.8 0 4.6.13 5.4.37 2.1.65 3.2 2.17 3.2 4.56M215 52V38.86c0-7.5-4.96-11.26-14.87-11.26h-9.66c-3.48 0-6.7.8-9.66 2.4-3.8 2.03-5.7 4.93-5.7 8.68v31.36c0 1.46.5 2.38 1.3 2.75.4.1 1.3.1 2.7.1 1.6 0 2.3-1 2.3-3V63h18.8c9.9 0 14.9-3.7 14.9-11.07M159 33.3c.24-.5.36-1.43.36-2.75 0-1.96-.78-2.94-2.33-2.94h-20.8c-3.64 0-6.35.2-8.14.6-3.3.6-5.8 1.9-7.4 3.8-1.7 2-2.6 4.5-2.6 7.7v30.5c0 2 .8 3 2.3 3 1.6 0 2.6 0 2.9-.1.9-.3 1.4-1.2 1.4-2.7V39.6c0-2.44 1.5-4 4.6-4.7 1.2-.3 3.5-.45 6.7-.45h21c1 0 1.6-.37 1.9-1.1"
                    fill="#e30613"/>
            </g>
            <g clip-path="url(#d)">
                <path
                    d="M438.34 42.94v-4.07c0-2.4-.3-4.3-.93-5.7-1.6-3.7-6.6-5.56-14.9-5.56h-22.9c-1.5 0-2.3 1-2.3 3 0 1.3.1 2.3.3 2.8.4.8 1 1.1 2 1.1h22.9c6.2 0 9.3 1.5 9.3 4.3v3.9c0 2.9-3 4.4-8.9 4.6-10.2.4-15.7.7-16.6.9-5.9 1.3-8.9 4.6-8.9 10v3.5c0 5.4 2.4 8.9 7.1 10.5 2 .7 5.6 1 10.9 1.1H436c1.53 0 2.3-1 2.3-2.9 0-1.3-.1-2.2-.35-2.72-.34-.77-1-1.14-1.97-1.14h-24.72c-5-.33-7.48-1.9-7.48-4.66v-3.2c0-2 1.36-3.3 4.08-3.9 1.1-.2 3.04-.35 5.84-.35h8.83c3.94 0 7.27-.7 10.02-2.06 3.85-1.95 5.78-5 5.78-9.2M393.6 68.4V30.6c0-1.5-.46-2.4-1.4-2.76-.3-.2-1.26-.2-2.9-.2-1.54 0-2.3 1-2.3 2.9v29.4l-19.53-30.1c-1.04-1.6-2.44-2.4-4.2-2.4-1.77 0-3.18.8-4.24 2.4L339.16 60V30.5c0-1.96-.78-2.94-2.33-2.94-1.63 0-2.6.06-2.9.2-.92.33-1.4 1.25-1.4 2.75v38.2c0 1.4.4 2.4 1.14 3.2.68.7 1.53 1.1 2.57 1.1 1.6 0 2.88-.7 3.88-2.1l23.24-34.4 22.7 34.4c.93 1.5 2.2 2.2 3.76 2.2 1.07 0 1.94-.3 2.62-1.1.77-.8 1.16-2 1.16-3.4m-64.94 1.8V32.6c0-3.45-1.2-5.17-3.64-5.17-.24 0-.48.02-.74.07-.8.1-1.8.8-3.05 2.1l-30.9 32.83V30.6c0-1.5-.45-2.43-1.36-2.78-.32-.1-1.3-.2-2.92-.2-1.55 0-2.33 1-2.33 2.98v37.88c0 1.32.07 2.18.2 2.57.2.64.7 1.24 1.5 1.84.5.3 1.06.5 1.7.5 1.45 0 2.92-.8 4.4-2.4l30.5-32.5v31.6c0 1.5.47 2.4 1.4 2.7.32.1 1.28.1 2.9.1 1.56 0 2.34-1 2.34-2.9"
                    fill="currentColor"/>
            </g>
        </g>
        <path
            d="M18.03 11.14l3.1 3.1-1.22 1.23-3.1-3.1zm5.67-5.66l3.1 3.1-1.23 1.23-3.1-3.1zm-.2 11.14l3.12 3.1-1.23 1.23-3.2-3.1zm5.67-5.66l3.1 3.1-1.22 1.23-3.1-3.2zM16.9 8.66l3.1-3.1 1.24 1.23-3.1 3.1zm5.47 5.5l3.1-3.1 1.24 1.2-3.1 3.1zm5.48 5.46l3.1-3.1 1.23 1.22-3.1 3.1zm-16.62-5.28l3.1-3.1 1.24 1.22-3.1 3.1zm5.47 5.46l3.12-3.1 1.22 1.23-3.1 3.1zm5.48 5.5l3.1-3.12 1.24 1.23-3.1 3.2z"
            fill="currentColor"/>
        <path
            d="M6.7 22.46l3.12 3.1L8.6 26.8l-3.12-3.12zm5.67-5.66l3.1 3.1-1.22 1.23-3.1-3.1zm-.17 11.14l3.1 3.1-1.23 1.23-3.1-3.1zm5.65-5.66l3.1 3.1-1.22 1.23-3.1-3.1zm-16.62-5.3l3.1 3.1L3.1 21.3 0 18.2zm5.67-5.66l3.1 3.1-1.23 1.23-3.1-3.1zm5.65-5.66l3.1 3.1-1.2 1.24-3.1-3.1zM18.2 0l3.12 3.1-1.23 1.23-3.2-3.1zm-6.77 3.2l3.1-3.1 1.23 1.22-3.1 3.1zM5.76 8.87l3.1-3.1L10.1 7 7 10.1zM.1 14.54l3.1-3.1 1.23 1.2-3.1 3.12zM5.56 20l3.1-3.1 1.24 1.23-3.1 3.1zm5.48 5.48l3.1-3.1 1.23 1.22-3.1 3.1zm5.46 5.48l3.12-3.1 1.23 1.2-3.1 3.12z"
            fill="#db202e"/>
    </svg>
    @if($responsive)
    <svg {{ $attributes->class(['tw:dark:text-white', 'tw:text-gray-600', 'tw:inline-block', "tw:$responsive:hidden"]) }} xmlns="http://www.w3.org/2000/svg" viewBox="0 0 77.558 77.558">
        <path
            d="m43.334 26.774 7.45 7.45-2.932 2.98-7.45-7.45zM56.96 13.171l7.45 7.45-2.956 2.98-7.45-7.45zm-.48 26.774 7.498 7.45-2.956 2.98-7.691-7.45zM70.107 26.34l7.45 7.451-2.932 2.98-7.45-7.45zm-29.49-5.527 7.498-7.451 2.957 2.956-7.451 7.45zm13.17 13.17 7.451-7.45 2.98 2.932-7.45 7.45zm13.147 13.171 7.45-7.499 2.981 2.957-7.69 7.45zM26.99 34.489l7.451-7.45 2.98 2.932-7.45 7.45zm13.147 13.147 7.499-7.45 2.932 2.931-7.45 7.45zm13.17 13.17 7.451-7.498 2.98 2.956-7.498 7.69z"
            fill="currentColor"/>
        <path
            d="m16.103 53.98 7.499 7.451-2.933 2.98-7.498-7.498zM29.73 40.378l7.45 7.451-2.931 2.956-7.45-7.45zm-.408 26.774 7.45 7.451-2.956 2.956-7.45-7.45zM42.9 53.548l7.45 7.45-2.932 2.957-7.45-7.45zM2.956 40.81l7.45 7.45-2.955 2.933L0 43.743Zm13.628-13.603 7.45 7.45-2.956 2.956-7.45-7.45zm13.579-13.604 7.45 7.45-2.884 2.981-7.45-7.45zM43.743 0l7.498 7.45-2.956 2.957-7.691-7.45ZM27.47 7.69l7.45-7.45 2.957 2.933-7.45 7.45zM13.844 21.319l7.45-7.45 2.98 2.956-7.45 7.45zM.24 34.946l7.45-7.45 2.957 2.883-7.45 7.499zm13.123 13.122 7.45-7.45 2.98 2.956-7.45 7.45zm13.17 13.171 7.451-7.45 2.957 2.932-7.451 7.45zm13.123 13.17 7.499-7.45 2.956 2.884-7.45 7.499z"
            fill="#db202e"/>
    </svg>
    @endif
@endif
