/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.helper.Checksum;
import org.traccar.helper.DataConverter;
import org.traccar.model.Command;

public class TeltonikaProtocolEncoder
extends BaseProtocolEncoder {
    public TeltonikaProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private ByteBuf encodeContent(byte[] content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeInt(0);
        buf.writeInt(content.length + 8);
        buf.writeByte(12);
        buf.writeByte(1);
        buf.writeByte(5);
        buf.writeInt(content.length);
        buf.writeBytes(content);
        buf.writeByte(1);
        buf.writeInt(Checksum.crc16(Checksum.CRC16_IBM, buf.nioBuffer(8, buf.writerIndex() - 8)));
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        return switch (command.getType()) {
            case "engineStop" -> this.encodeContent("setdigout 1\r\n".getBytes(StandardCharsets.US_ASCII));
            case "engineResume" -> this.encodeContent("setdigout 0\r\n".getBytes(StandardCharsets.US_ASCII));
            case "custom" -> {
                String data = command.getString("data");
                if (data.matches("(\\p{XDigit}{2})+")) {
                    yield this.encodeContent(DataConverter.parseHex(data));
                }
                yield this.encodeContent((data + "\r\n").getBytes(StandardCharsets.US_ASCII));
            }
            default -> null;
        };
    }
}

