/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.BitUtil;
import org.traccar.helper.BufferUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class TeltonikaProtocolDecoder
extends BaseProtocolDecoder {
    private static final int IMAGE_PACKET_MAX = 2048;
    private static final Map<Integer, Map<Set<String>, BiConsumer<Position, ByteBuf>>> PARAMETERS = new HashMap<Integer, Map<Set<String>, BiConsumer<Position, ByteBuf>>>();
    private final boolean connectionless;
    private boolean extended;
    private final Map<Long, ByteBuf> photos = new HashMap<Long, ByteBuf>();
    public static final int CODEC_GH3000 = 7;
    public static final int CODEC_8 = 8;
    public static final int CODEC_8_EXT = 142;
    public static final int CODEC_12 = 12;
    public static final int CODEC_13 = 13;
    public static final int CODEC_16 = 16;

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public TeltonikaProtocolDecoder(Protocol protocol, boolean connectionless) {
        super(protocol);
        this.connectionless = connectionless;
    }

    @Override
    protected void init() {
        this.extended = this.getConfig().getBoolean(Keys.PROTOCOL_EXTENDED.withPrefix(this.getProtocolName()));
    }

    private void parseIdentification(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        int length = buf.readUnsignedShort();
        String imei = buf.toString(buf.readerIndex(), length, StandardCharsets.US_ASCII);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (channel != null) {
            ByteBuf response = Unpooled.buffer((int)1);
            if (deviceSession != null) {
                response.writeByte(1);
            } else {
                response.writeByte(0);
            }
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private void sendImageRequest(Channel channel, SocketAddress remoteAddress, long id, int offset, int size) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeInt(0);
            response.writeShort(0);
            response.writeShort(19);
            response.writeByte(12);
            response.writeByte(1);
            response.writeByte(13);
            response.writeInt(11);
            response.writeByte(2);
            response.writeInt((int)id);
            response.writeInt(offset);
            response.writeShort(size);
            response.writeByte(1);
            response.writeShort(0);
            response.writeShort(Checksum.crc16(Checksum.CRC16_IBM, response.nioBuffer(8, response.readableBytes() - 10)));
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeSerial(Channel channel, SocketAddress remoteAddress, DeviceSession deviceSession, Position position, ByteBuf buf) {
        this.getLastLocation(position, null);
        short type = buf.readUnsignedByte();
        if (type == 13) {
            buf.readInt();
            short subtype = buf.readUnsignedByte();
            if (subtype == 1) {
                long photoId = buf.readUnsignedInt();
                ByteBuf photo = Unpooled.buffer((int)buf.readInt());
                this.photos.put(photoId, photo);
                this.sendImageRequest(channel, remoteAddress, photoId, 0, Math.min(2048, photo.capacity()));
            } else if (subtype == 2) {
                long photoId = buf.readUnsignedInt();
                buf.readInt();
                ByteBuf photo = this.photos.get(photoId);
                photo.writeBytes(buf, buf.readUnsignedShort());
                if (photo.writableBytes() > 0) {
                    this.sendImageRequest(channel, remoteAddress, photoId, photo.writerIndex(), Math.min(2048, photo.writableBytes()));
                } else {
                    this.photos.remove(photoId);
                    try {
                        position.set("image", this.writeMediaFile(deviceSession.getUniqueId(), photo, "jpg"));
                    }
                    finally {
                        photo.release();
                    }
                }
            }
        } else {
            position.set("type", Integer.valueOf(type));
            int length = buf.readInt();
            if (BufferUtil.isPrintable(buf, length)) {
                String data = buf.readSlice(length).toString(StandardCharsets.US_ASCII).trim();
                if (data.startsWith("UUUUww") && data.endsWith("SSS")) {
                    String[] values = data.substring(6, data.length() - 4).split(";");
                    for (int i = 0; i < 8; ++i) {
                        position.set("axle" + (i + 1), Double.parseDouble(values[i]));
                    }
                    position.set("loadTruck", Double.parseDouble(values[8]));
                    position.set("loadTrailer", Double.parseDouble(values[9]));
                    position.set("totalTruck", Double.parseDouble(values[10]));
                    position.set("totalTrailer", Double.parseDouble(values[11]));
                } else {
                    position.set("result", data);
                }
            } else {
                position.set("result", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(length)));
            }
        }
    }

    private long readValue(ByteBuf buf, int length) {
        return switch (length) {
            case 1 -> buf.readUnsignedByte();
            case 2 -> buf.readUnsignedShort();
            case 4 -> buf.readUnsignedInt();
            default -> buf.readLong();
        };
    }

    private static void register(int id, Set<String> models, BiConsumer<Position, ByteBuf> handler) {
        PARAMETERS.computeIfAbsent(id, key -> new HashMap()).put(models, handler);
    }

    private void decodeGh3000Parameter(Position position, int id, ByteBuf buf, int length) {
        switch (id) {
            case 1: {
                position.set("batteryLevel", this.readValue(buf, length));
                break;
            }
            case 2: {
                position.set("usbConnected", this.readValue(buf, length) == 1L);
                break;
            }
            case 5: {
                position.set("uptime", this.readValue(buf, length));
                break;
            }
            case 20: {
                position.set("hdop", (double)this.readValue(buf, length) * 0.1);
                break;
            }
            case 21: {
                position.set("vdop", (double)this.readValue(buf, length) * 0.1);
                break;
            }
            case 22: {
                position.set("pdop", (double)this.readValue(buf, length) * 0.1);
                break;
            }
            case 67: {
                position.set("battery", (double)this.readValue(buf, length) * 0.001);
                break;
            }
            case 221: {
                position.set("button", this.readValue(buf, length));
                break;
            }
            case 222: {
                if (this.readValue(buf, length) != 1L) break;
                position.addAlarm("sos");
                break;
            }
            case 240: {
                position.set("motion", this.readValue(buf, length) == 1L);
                break;
            }
            case 244: {
                position.set("roaming", this.readValue(buf, length) == 1L);
                break;
            }
            default: {
                position.set("io" + id, this.readValue(buf, length));
            }
        }
    }

    private void decodeParameter(Position position, int id, ByteBuf buf, int length, int codec, String model) {
        if (codec == 7) {
            this.decodeGh3000Parameter(position, id, buf, length);
        } else {
            int index = buf.readerIndex();
            boolean decoded = false;
            for (Map.Entry entry : ((Map)PARAMETERS.getOrDefault(id, new HashMap())).entrySet()) {
                if (entry.getKey() != null && (model == null || !((Set)entry.getKey()).contains(model))) continue;
                ((BiConsumer)entry.getValue()).accept(position, buf);
                decoded = true;
                break;
            }
            if (decoded) {
                buf.readerIndex(index + length);
            } else {
                position.set("io" + id, this.readValue(buf, length));
            }
        }
    }

    private void decodeCell(Position position, Network network, String mncKey, String lacKey, String cidKey, String rssiKey) {
        if (position.hasAttribute(mncKey) && position.hasAttribute(lacKey) && position.hasAttribute(cidKey)) {
            CellTower cellTower = CellTower.from(this.getConfig().getInteger(Keys.GEOLOCATION_MCC), position.removeInteger(mncKey), position.removeInteger(lacKey), position.removeLong(cidKey));
            cellTower.setSignalStrength(position.removeInteger(rssiKey));
            network.addCellTower(cellTower);
        }
    }

    private void decodeNetwork(Position position, String model) {
        if ("TAT100".equals(model)) {
            Network network = new Network();
            this.decodeCell(position, network, "io1200", "io287", "io288", "io289");
            this.decodeCell(position, network, "io1201", "io290", "io291", "io292");
            this.decodeCell(position, network, "io1202", "io293", "io294", "io295");
            this.decodeCell(position, network, "io1203", "io296", "io297", "io298");
            if (network.getCellTowers() != null) {
                position.setNetwork(network);
            }
        } else {
            Integer cid2g = position.removeInteger("cid2g");
            Long cid4g = position.removeLong("cid4g");
            Integer lac = position.removeInteger("lac");
            if (lac != null && (cid2g != null || cid4g != null)) {
                CellTower cellTower;
                Network network = new Network();
                if (cid2g != null) {
                    cellTower = CellTower.fromLacCid(this.getConfig(), lac, cid2g.intValue());
                } else {
                    cellTower = CellTower.fromLacCid(this.getConfig(), lac, cid4g);
                    network.setRadioType("lte");
                }
                long operator = position.getInteger("operator");
                if (operator >= 1000L) {
                    cellTower.setOperator(operator);
                }
                network.addCellTower(cellTower);
                position.setNetwork(new Network(cellTower));
            }
        }
    }

    private int readExtByte(ByteBuf buf, int codec, int ... codecs) {
        boolean ext = false;
        for (int c : codecs) {
            if (codec != c) continue;
            ext = true;
            break;
        }
        if (ext) {
            return buf.readUnsignedShort();
        }
        return buf.readUnsignedByte();
    }

    private void decodeLocation(Position position, ByteBuf buf, int codec, String model) {
        int id;
        int j;
        int globalMask = 15;
        if (codec == 7) {
            long time = buf.readUnsignedInt() & 0x3FFFFFFFL;
            time += 1167609600L;
            globalMask = buf.readUnsignedByte();
            if (BitUtil.check(globalMask, 0)) {
                position.setTime(new Date(time * 1000L));
                short locationMask = buf.readUnsignedByte();
                if (BitUtil.check(locationMask, 0)) {
                    position.setLatitude(buf.readFloat());
                    position.setLongitude(buf.readFloat());
                }
                if (BitUtil.check(locationMask, 1)) {
                    position.setAltitude(buf.readUnsignedShort());
                }
                if (BitUtil.check(locationMask, 2)) {
                    position.setCourse((double)buf.readUnsignedByte() * 360.0 / 256.0);
                }
                if (BitUtil.check(locationMask, 3)) {
                    position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                }
                if (BitUtil.check(locationMask, 4)) {
                    position.set("sat", buf.readUnsignedByte());
                }
                if (BitUtil.check(locationMask, 5)) {
                    CellTower cellTower = CellTower.fromLacCid(this.getConfig(), buf.readUnsignedShort(), buf.readUnsignedShort());
                    if (BitUtil.check(locationMask, 6)) {
                        cellTower.setSignalStrength(Integer.valueOf(buf.readUnsignedByte()));
                    }
                    if (BitUtil.check(locationMask, 7)) {
                        cellTower.setOperator(buf.readUnsignedInt());
                    }
                    position.setNetwork(new Network(cellTower));
                } else {
                    if (BitUtil.check(locationMask, 6)) {
                        position.set("rssi", buf.readUnsignedByte());
                    }
                    if (BitUtil.check(locationMask, 7)) {
                        position.set("operator", buf.readUnsignedInt());
                    }
                }
            } else {
                this.getLastLocation(position, new Date(time * 1000L));
            }
        } else {
            position.setTime(new Date(buf.readLong()));
            position.set("priority", buf.readUnsignedByte());
            position.setLongitude((double)buf.readInt() / 1.0E7);
            position.setLatitude((double)buf.readInt() / 1.0E7);
            position.setAltitude(buf.readShort());
            position.setCourse(buf.readUnsignedShort());
            short satellites = buf.readUnsignedByte();
            position.set("sat", Integer.valueOf(satellites));
            position.setValid(satellites != 0);
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShort()));
            position.set("event", this.readExtByte(buf, codec, 142, 16));
            if (codec == 16) {
                buf.readUnsignedByte();
            }
            this.readExtByte(buf, codec, 142);
        }
        if (BitUtil.check(globalMask, 1)) {
            int cnt = this.readExtByte(buf, codec, 142);
            for (j = 0; j < cnt; ++j) {
                this.decodeParameter(position, this.readExtByte(buf, codec, 142, 16), buf, 1, codec, model);
            }
        }
        if (BitUtil.check(globalMask, 2)) {
            int cnt = this.readExtByte(buf, codec, 142);
            for (j = 0; j < cnt; ++j) {
                this.decodeParameter(position, this.readExtByte(buf, codec, 142, 16), buf, 2, codec, model);
            }
        }
        if (BitUtil.check(globalMask, 3)) {
            int cnt = this.readExtByte(buf, codec, 142);
            for (j = 0; j < cnt; ++j) {
                this.decodeParameter(position, this.readExtByte(buf, codec, 142, 16), buf, 4, codec, model);
            }
        }
        if (codec == 8 || codec == 142 || codec == 16) {
            int cnt = this.readExtByte(buf, codec, 142);
            for (j = 0; j < cnt; ++j) {
                this.decodeParameter(position, this.readExtByte(buf, codec, 142, 16), buf, 8, codec, model);
            }
        }
        if (this.extended) {
            int cnt = this.readExtByte(buf, codec, 142);
            for (j = 0; j < cnt; ++j) {
                id = this.readExtByte(buf, codec, 142, 16);
                position.set("io" + id, ByteBufUtil.hexDump((ByteBuf)buf.readSlice(16)));
            }
        }
        if (codec == 142) {
            int cnt = buf.readUnsignedShort();
            for (j = 0; j < cnt; ++j) {
                ByteBuf data;
                id = buf.readUnsignedShort();
                int length = buf.readUnsignedShort();
                if (id == 256) {
                    position.set("vin", buf.readSlice(length).toString(StandardCharsets.US_ASCII));
                    continue;
                }
                if (id == 281) {
                    position.set("dtcs", buf.readSlice(length).toString(StandardCharsets.US_ASCII).replace(',', ' '));
                    continue;
                }
                if (id == 385) {
                    data = buf.readSlice(length);
                    data.readUnsignedByte();
                    int index = 1;
                    while (data.isReadable()) {
                        short flags = data.readUnsignedByte();
                        if (BitUtil.from(flags, 4) > 0) {
                            position.set("beacon" + index + "Uuid", ByteBufUtil.hexDump((ByteBuf)data.readSlice(16)));
                            position.set("beacon" + index + "Major", data.readUnsignedShort());
                            position.set("beacon" + index + "Minor", data.readUnsignedShort());
                        } else {
                            position.set("beacon" + index + "Namespace", ByteBufUtil.hexDump((ByteBuf)data.readSlice(10)));
                            position.set("beacon" + index + "Instance", ByteBufUtil.hexDump((ByteBuf)data.readSlice(6)));
                        }
                        position.set("beacon" + index + "Rssi", Integer.valueOf(data.readByte()));
                        if (BitUtil.check(flags, 1)) {
                            position.set("beacon" + index + "Battery", (double)data.readUnsignedShort() * 0.01);
                        }
                        if (BitUtil.check(flags, 2)) {
                            position.set("beacon" + index + "Temp", data.readUnsignedShort());
                        }
                        ++index;
                    }
                    continue;
                }
                if (id == 548 || id == 10828 || id == 10829 || id == 10831 || id == 11317) {
                    data = buf.readSlice(length);
                    data.readUnsignedByte();
                    int i = 1;
                    while (data.isReadable()) {
                        ByteBuf beacon = data.readSlice((int)data.readUnsignedByte());
                        block24: while (beacon.isReadable()) {
                            short parameterId = beacon.readUnsignedByte();
                            short parameterLength = beacon.readUnsignedByte();
                            switch (parameterId) {
                                case 0: {
                                    position.set("tag" + i + "Rssi", Integer.valueOf(beacon.readByte()));
                                    break;
                                }
                                case 1: {
                                    String beaconId = ByteBufUtil.hexDump((ByteBuf)beacon.readSlice((int)parameterLength));
                                    position.set("tag" + i + "Id", beaconId);
                                    break;
                                }
                                case 2: {
                                    ByteBuf beaconData = beacon.readSlice((int)parameterLength);
                                    short flag = beaconData.readUnsignedByte();
                                    if (BitUtil.check(flag, 6)) {
                                        position.set("tag" + i + "LowBattery", true);
                                    }
                                    if (!BitUtil.check(flag, 7)) continue block24;
                                    position.set("tag" + i + "Voltage", beaconData.readUnsignedByte() * 10 + 2000);
                                    break;
                                }
                                case 5: {
                                    String name = beacon.readCharSequence((int)parameterLength, StandardCharsets.UTF_8).toString();
                                    position.set("tag" + i + "Name", name);
                                    break;
                                }
                                case 6: {
                                    position.set("tag" + i + "Temp", beacon.readShort());
                                    break;
                                }
                                case 7: {
                                    position.set("tag" + i + "Humidity", beacon.readUnsignedByte());
                                    break;
                                }
                                case 8: {
                                    position.set("tag" + i + "Magnet", beacon.readUnsignedByte() > 0);
                                    break;
                                }
                                case 9: {
                                    position.set("tag" + i + "Motion", beacon.readUnsignedByte() > 0);
                                    break;
                                }
                                case 10: {
                                    position.set("tag" + i + "MotionCount", beacon.readUnsignedShort());
                                    break;
                                }
                                case 11: {
                                    position.set("tag" + i + "Pitch", Integer.valueOf(beacon.readByte()));
                                    break;
                                }
                                case 12: {
                                    position.set("tag" + i + "AngleRoll", Integer.valueOf(beacon.readShort()));
                                    break;
                                }
                                case 13: {
                                    position.set("tag" + i + "LowBattery", beacon.readUnsignedByte());
                                    break;
                                }
                                case 14: {
                                    position.set("tag" + i + "Battery", beacon.readUnsignedShort());
                                    break;
                                }
                                case 15: {
                                    position.set("tag" + i + "Mac", ByteBufUtil.hexDump((ByteBuf)beacon.readSlice(6)));
                                    break;
                                }
                                default: {
                                    beacon.skipBytes((int)parameterLength);
                                }
                            }
                        }
                        ++i;
                    }
                    continue;
                }
                position.set("io" + id, ByteBufUtil.hexDump((ByteBuf)buf.readSlice(length)));
            }
        }
        this.decodeNetwork(position, model);
        if (model != null && model.matches("FM.6..")) {
            Long driverMsb = (Long)position.getAttributes().get("io195");
            Long driverLsb = (Long)position.getAttributes().get("io196");
            if (driverMsb != null && driverLsb != null) {
                String driver = new String(ByteBuffer.allocate(16).putLong(driverMsb).putLong(driverLsb).array());
                position.set("driverUniqueId", driver);
            }
        }
    }

    private List<Position> parseData(Channel channel, SocketAddress remoteAddress, ByteBuf buf, int locationPacketId, String ... imei) {
        LinkedList<Position> positions = new LinkedList<Position>();
        if (!this.connectionless) {
            buf.readUnsignedInt();
        }
        short codec = buf.readUnsignedByte();
        int count = buf.readUnsignedByte();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setValid(true);
            if (codec == 13) {
                buf.readUnsignedByte();
                int length = buf.readInt() - 4;
                this.getLastLocation(position, new Date(buf.readUnsignedInt() * 1000L));
                if (BufferUtil.isPrintable(buf, length)) {
                    String data = buf.readCharSequence(length, StandardCharsets.US_ASCII).toString().trim();
                    if (data.startsWith("GTSL")) {
                        position.set("driverUniqueId", data.split("\\|")[4]);
                    } else {
                        position.set("result", data);
                    }
                } else {
                    position.set("result", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(length)));
                }
            } else if (codec == 12) {
                this.decodeSerial(channel, remoteAddress, deviceSession, position, buf);
            } else {
                this.decodeLocation(position, buf, codec, this.getDeviceModel(deviceSession));
            }
            if (position.getOutdated() && position.getAttributes().isEmpty()) continue;
            positions.add(position);
        }
        if (channel != null && codec != 12 && codec != 13) {
            ByteBuf response = Unpooled.buffer();
            if (this.connectionless) {
                response.writeShort(5);
                response.writeShort(0);
                response.writeByte(1);
                response.writeByte(locationPacketId);
                response.writeByte(count);
            } else {
                response.writeInt(count);
            }
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        return positions.isEmpty() ? null : positions;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (this.connectionless) {
            return this.decodeUdp(channel, remoteAddress, buf);
        }
        return this.decodeTcp(channel, remoteAddress, buf);
    }

    private Object decodeTcp(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        if (buf.readableBytes() == 1 && buf.readUnsignedByte() == 255) {
            return null;
        }
        if (buf.getUnsignedShort(0) <= 0) {
            buf.skipBytes(4);
            return this.parseData(channel, remoteAddress, buf, 0, new String[0]);
        }
        this.parseIdentification(channel, remoteAddress, buf);
        return null;
    }

    private Object decodeUdp(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        buf.readUnsignedByte();
        short locationPacketId = buf.readUnsignedByte();
        String imei = buf.readSlice(buf.readUnsignedShort()).toString(StandardCharsets.US_ASCII);
        return this.parseData(channel, remoteAddress, buf, locationPacketId, imei);
    }

    static {
        Set<String> fmbXXX = Set.of("FMB001", "FMC001", "FMB010", "FMB002", "FMB020", "FMB003", "FMB110", "FMB120", "FMB122", "FMB125", "FMB130", "FMB140", "FMU125", "FMB900", "FMB920", "FMB962", "FMB964", "FM3001", "FMB202", "FMB204", "FMB206", "FMT100", "MTB100", "FMP100", "MSP500", "FMC125", "FMM125", "FMU130", "FMC130", "FMM130", "FMB150", "FMC150", "FMM150", "FMC920");
        TeltonikaProtocolDecoder.register(1, null, (p, b) -> p.set("in1", b.readUnsignedByte() > 0));
        TeltonikaProtocolDecoder.register(2, null, (p, b) -> p.set("in2", b.readUnsignedByte() > 0));
        TeltonikaProtocolDecoder.register(3, null, (p, b) -> p.set("in3", b.readUnsignedByte() > 0));
        TeltonikaProtocolDecoder.register(4, null, (p, b) -> p.set("in4", b.readUnsignedByte() > 0));
        TeltonikaProtocolDecoder.register(9, fmbXXX, (p, b) -> p.set("adc1", (double)b.readUnsignedShort() * 0.001));
        TeltonikaProtocolDecoder.register(10, fmbXXX, (p, b) -> p.set("adc2", (double)b.readUnsignedShort() * 0.001));
        TeltonikaProtocolDecoder.register(11, fmbXXX, (p, b) -> p.set("iccid", String.valueOf(b.readLong())));
        TeltonikaProtocolDecoder.register(12, fmbXXX, (p, b) -> p.set("fuelUsed", (double)b.readUnsignedInt() * 0.001));
        TeltonikaProtocolDecoder.register(13, fmbXXX, (p, b) -> p.set("fuelConsumption", (double)b.readUnsignedShort() * 0.01));
        TeltonikaProtocolDecoder.register(16, null, (p, b) -> p.set("odometer", b.readUnsignedInt()));
        TeltonikaProtocolDecoder.register(17, null, (p, b) -> p.set("axisX", b.readShort()));
        TeltonikaProtocolDecoder.register(18, null, (p, b) -> p.set("axisY", b.readShort()));
        TeltonikaProtocolDecoder.register(19, null, (p, b) -> p.set("axisZ", b.readShort()));
        TeltonikaProtocolDecoder.register(21, null, (p, b) -> p.set("rssi", b.readUnsignedByte()));
        TeltonikaProtocolDecoder.register(24, fmbXXX, (p, b) -> p.setSpeed(UnitsConverter.knotsFromKph(b.readUnsignedShort())));
        TeltonikaProtocolDecoder.register(25, null, (p, b) -> p.set("bleTemp1", (double)b.readShort() * 0.01));
        TeltonikaProtocolDecoder.register(26, null, (p, b) -> p.set("bleTemp2", (double)b.readShort() * 0.01));
        TeltonikaProtocolDecoder.register(27, null, (p, b) -> p.set("bleTemp3", (double)b.readShort() * 0.01));
        TeltonikaProtocolDecoder.register(28, null, (p, b) -> p.set("bleTemp4", (double)b.readShort() * 0.01));
        TeltonikaProtocolDecoder.register(30, fmbXXX, (p, b) -> p.set("faultCount", b.readUnsignedByte()));
        TeltonikaProtocolDecoder.register(31, fmbXXX, (p, b) -> p.set("engineLoad", b.readUnsignedByte()));
        TeltonikaProtocolDecoder.register(32, fmbXXX, (p, b) -> p.set("coolantTemp", b.readByte()));
        TeltonikaProtocolDecoder.register(36, fmbXXX, (p, b) -> p.set("rpm", b.readUnsignedShort()));
        TeltonikaProtocolDecoder.register(43, fmbXXX, (p, b) -> p.set("milDistance", b.readUnsignedShort()));
        TeltonikaProtocolDecoder.register(57, fmbXXX, (p, b) -> p.set("hybridBatteryLevel", b.readByte()));
        TeltonikaProtocolDecoder.register(66, null, (p, b) -> p.set("power", (double)b.readUnsignedShort() * 0.001));
        TeltonikaProtocolDecoder.register(67, null, (p, b) -> p.set("battery", (double)b.readUnsignedShort() * 0.001));
        TeltonikaProtocolDecoder.register(68, fmbXXX, (p, b) -> p.set("batteryCurrent", (double)b.readUnsignedShort() * 0.001));
        TeltonikaProtocolDecoder.register(72, fmbXXX, (p, b) -> p.set("temp1", (double)b.readInt() * 0.1));
        TeltonikaProtocolDecoder.register(73, fmbXXX, (p, b) -> p.set("temp2", (double)b.readInt() * 0.1));
        TeltonikaProtocolDecoder.register(74, fmbXXX, (p, b) -> p.set("temp3", (double)b.readInt() * 0.1));
        TeltonikaProtocolDecoder.register(75, fmbXXX, (p, b) -> p.set("temp4", (double)b.readInt() * 0.1));
        TeltonikaProtocolDecoder.register(78, null, (p, b) -> {
            long driverUniqueId = b.readLongLE();
            if (driverUniqueId != 0L) {
                p.set("driverUniqueId", String.format("%016X", driverUniqueId));
            }
        });
        TeltonikaProtocolDecoder.register(80, fmbXXX, (p, b) -> p.set("dataMode", b.readUnsignedByte()));
        TeltonikaProtocolDecoder.register(81, fmbXXX, (p, b) -> p.set("obdSpeed", b.readUnsignedByte()));
        TeltonikaProtocolDecoder.register(82, fmbXXX, (p, b) -> p.set("throttle", b.readUnsignedByte()));
        TeltonikaProtocolDecoder.register(83, fmbXXX, (p, b) -> p.set("fuelUsed", (double)b.readUnsignedInt() * 0.1));
        TeltonikaProtocolDecoder.register(84, fmbXXX, (p, b) -> p.set("fuel", (double)b.readUnsignedShort() * 0.1));
        TeltonikaProtocolDecoder.register(85, fmbXXX, (p, b) -> p.set("rpm", b.readUnsignedShort()));
        TeltonikaProtocolDecoder.register(87, fmbXXX, (p, b) -> p.set("obdOdometer", b.readUnsignedInt()));
        TeltonikaProtocolDecoder.register(89, fmbXXX, (p, b) -> p.set("fuelLevelPercentage", b.readUnsignedByte()));
        TeltonikaProtocolDecoder.register(110, fmbXXX, (p, b) -> p.set("fuelConsumption", (double)b.readUnsignedShort() * 0.1));
        TeltonikaProtocolDecoder.register(113, fmbXXX, (p, b) -> p.set("batteryLevel", b.readUnsignedByte()));
        TeltonikaProtocolDecoder.register(115, fmbXXX, (p, b) -> p.set("engineTemp", (double)b.readShort() * 0.1));
        TeltonikaProtocolDecoder.register(701, Set.of("FMC640", "FMC650", "FMM640"), (p, b) -> p.set("bleTemp1", (double)b.readShort() * 0.01));
        TeltonikaProtocolDecoder.register(702, Set.of("FMC640", "FMC650", "FMM640"), (p, b) -> p.set("bleTemp2", (double)b.readShort() * 0.01));
        TeltonikaProtocolDecoder.register(703, Set.of("FMC640", "FMC650", "FMM640"), (p, b) -> p.set("bleTemp3", (double)b.readShort() * 0.01));
        TeltonikaProtocolDecoder.register(704, Set.of("FMC640", "FMC650", "FMM640"), (p, b) -> p.set("bleTemp4", (double)b.readShort() * 0.01));
        TeltonikaProtocolDecoder.register(179, null, (p, b) -> p.set("out1", b.readUnsignedByte() > 0));
        TeltonikaProtocolDecoder.register(180, null, (p, b) -> p.set("out2", b.readUnsignedByte() > 0));
        TeltonikaProtocolDecoder.register(181, null, (p, b) -> p.set("pdop", (double)b.readUnsignedShort() * 0.1));
        TeltonikaProtocolDecoder.register(182, null, (p, b) -> p.set("hdop", (double)b.readUnsignedShort() * 0.1));
        TeltonikaProtocolDecoder.register(199, null, (p, b) -> p.set("tripOdometer", b.readUnsignedInt()));
        TeltonikaProtocolDecoder.register(200, fmbXXX, (p, b) -> p.set("sleepMode", b.readUnsignedByte()));
        TeltonikaProtocolDecoder.register(205, fmbXXX, (p, b) -> p.set("cid2g", b.readUnsignedShort()));
        TeltonikaProtocolDecoder.register(206, fmbXXX, (p, b) -> p.set("lac", b.readUnsignedShort()));
        TeltonikaProtocolDecoder.register(232, fmbXXX, (p, b) -> p.set("cngStatus", b.readUnsignedByte() > 0));
        TeltonikaProtocolDecoder.register(233, fmbXXX, (p, b) -> p.set("cngUsed", (double)b.readUnsignedInt() * 0.1));
        TeltonikaProtocolDecoder.register(234, fmbXXX, (p, b) -> p.set("cngLevel", b.readUnsignedShort()));
        TeltonikaProtocolDecoder.register(235, fmbXXX, (p, b) -> p.set("oilLevel", b.readUnsignedByte()));
        TeltonikaProtocolDecoder.register(236, null, (p, b) -> p.addAlarm(b.readUnsignedByte() > 0 ? "general" : null));
        TeltonikaProtocolDecoder.register(239, null, (p, b) -> p.set("ignition", b.readUnsignedByte() > 0));
        TeltonikaProtocolDecoder.register(240, null, (p, b) -> p.set("motion", b.readUnsignedByte() > 0));
        TeltonikaProtocolDecoder.register(241, null, (p, b) -> p.set("operator", b.readUnsignedInt()));
        TeltonikaProtocolDecoder.register(246, fmbXXX, (p, b) -> p.addAlarm(b.readUnsignedByte() > 0 ? "tow" : null));
        TeltonikaProtocolDecoder.register(247, fmbXXX, (p, b) -> p.addAlarm(b.readUnsignedByte() > 0 ? "accident" : null));
        TeltonikaProtocolDecoder.register(249, fmbXXX, (p, b) -> p.addAlarm(b.readUnsignedByte() > 0 ? "jamming" : null));
        TeltonikaProtocolDecoder.register(251, fmbXXX, (p, b) -> p.addAlarm(b.readUnsignedByte() > 0 ? "idle" : null));
        TeltonikaProtocolDecoder.register(252, fmbXXX, (p, b) -> p.addAlarm(b.readUnsignedByte() > 0 ? "powerCut" : null));
        TeltonikaProtocolDecoder.register(253, null, (p, b) -> {
            switch (b.readUnsignedByte()) {
                case 1: {
                    p.addAlarm("hardAcceleration");
                    break;
                }
                case 2: {
                    p.addAlarm("hardBraking");
                    break;
                }
                case 3: {
                    p.addAlarm("hardCornering");
                }
            }
        });
        TeltonikaProtocolDecoder.register(175, fmbXXX, (p, b) -> p.addAlarm(b.readUnsignedByte() > 0 ? "geofenceEnter" : "geofenceExit"));
        TeltonikaProtocolDecoder.register(636, fmbXXX, (p, b) -> p.set("cid4g", b.readUnsignedInt()));
        TeltonikaProtocolDecoder.register(662, fmbXXX, (p, b) -> p.set("door", b.readUnsignedByte() > 0));
        TeltonikaProtocolDecoder.register(10800, fmbXXX, (p, b) -> p.set("eyeTemp1", (double)b.readShort() / 100.0));
        TeltonikaProtocolDecoder.register(10801, fmbXXX, (p, b) -> p.set("eyeTemp2", (double)b.readShort() / 100.0));
        TeltonikaProtocolDecoder.register(10802, fmbXXX, (p, b) -> p.set("eyeTemp3", (double)b.readShort() / 100.0));
        TeltonikaProtocolDecoder.register(10803, fmbXXX, (p, b) -> p.set("eyeTemp4", (double)b.readShort() / 100.0));
        TeltonikaProtocolDecoder.register(10832, fmbXXX, (p, b) -> p.set("eyeRoll1", b.readShort()));
        TeltonikaProtocolDecoder.register(10833, fmbXXX, (p, b) -> p.set("eyeRoll2", b.readShort()));
        TeltonikaProtocolDecoder.register(10834, fmbXXX, (p, b) -> p.set("eyeRoll3", b.readShort()));
        TeltonikaProtocolDecoder.register(10835, fmbXXX, (p, b) -> p.set("eyeRoll4", b.readShort()));
    }
}

