/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.traccar.BaseProtocol;
import org.traccar.ServerManager;
import org.traccar.broadcast.BroadcastInterface;
import org.traccar.broadcast.BroadcastService;
import org.traccar.command.CommandSenderManager;
import org.traccar.config.Keys;
import org.traccar.database.NotificationManager;
import org.traccar.model.Command;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.ObjectOperation;
import org.traccar.model.Position;
import org.traccar.model.QueuedCommand;
import org.traccar.session.ConnectionManager;
import org.traccar.session.DeviceSession;
import org.traccar.session.cache.CacheManager;
import org.traccar.sms.SmsManager;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Order;
import org.traccar.storage.query.Request;

@Singleton
public class CommandsManager
implements BroadcastInterface {
    private final Storage storage;
    private final ServerManager serverManager;
    private final SmsManager smsManager;
    private final ConnectionManager connectionManager;
    private final BroadcastService broadcastService;
    private final NotificationManager notificationManager;
    private final CacheManager cacheManager;
    private final CommandSenderManager commandSenderManager;

    @Inject
    public CommandsManager(Storage storage, ServerManager serverManager, @Nullable SmsManager smsManager, ConnectionManager connectionManager, BroadcastService broadcastService, NotificationManager notificationManager, CacheManager cacheManager, CommandSenderManager commandSenderManager) {
        this.storage = storage;
        this.serverManager = serverManager;
        this.smsManager = smsManager;
        this.connectionManager = connectionManager;
        this.broadcastService = broadcastService;
        this.notificationManager = notificationManager;
        this.cacheManager = cacheManager;
        this.commandSenderManager = commandSenderManager;
        broadcastService.registerListener(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QueuedCommand sendCommand(Command command) throws Exception {
        BaseProtocol protocol;
        long deviceId = command.getDeviceId();
        Device device = this.storage.getObject(Device.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", deviceId)));
        Position position = this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", device.getPositionId())));
        BaseProtocol baseProtocol = protocol = position != null ? this.serverManager.getProtocol(position.getProtocol()) : null;
        if (command.getTextChannel()) {
            if (this.smsManager == null) {
                throw new RuntimeException("SMS not configured");
            }
            if (position != null) {
                protocol.sendTextCommand(device.getPhone(), command);
                return null;
            } else {
                if (!command.getType().equals("custom")) throw new RuntimeException("Command " + command.getType() + " is not supported");
                this.smsManager.sendMessage(device.getPhone(), command.getString("data"), true);
            }
            return null;
        } else {
            String sender = device.getString(Keys.COMMAND_SENDER.getKey());
            if (sender != null) {
                this.commandSenderManager.getSender(sender).sendCommand(device, command);
                return null;
            } else {
                DeviceSession deviceSession = this.connectionManager.getDeviceSession(deviceId);
                if (deviceSession != null && deviceSession.supportsLiveCommands()) {
                    deviceSession.sendCommand(command);
                    return null;
                } else {
                    if (command.getBoolean("noQueue")) throw new RuntimeException("Failed to send command");
                    QueuedCommand queuedCommand = QueuedCommand.fromCommand(command);
                    queuedCommand.setId(this.storage.addObject(queuedCommand, new Request(new Columns.Exclude("id"))));
                    this.broadcastService.updateCommand(true, deviceId);
                    return queuedCommand;
                }
            }
        }
    }

    public Collection<Command> readQueuedCommands(long deviceId) {
        return this.readQueuedCommands(deviceId, Integer.MAX_VALUE);
    }

    public Collection<Command> readQueuedCommands(long deviceId, int count) {
        try {
            List<QueuedCommand> commands = this.storage.getObjects(QueuedCommand.class, new Request(new Columns.All(), new Condition.Equals("deviceId", deviceId), new Order("id", false, count)));
            HashMap<Event, Position> events = new HashMap<Event, Position>();
            for (QueuedCommand command : commands) {
                this.storage.removeObject(QueuedCommand.class, new Request(new Condition.Equals("id", command.getId())));
                Event event = new Event("queuedCommandSent", command.getDeviceId());
                event.set("id", command.getId());
                events.put(event, null);
            }
            this.notificationManager.updateEvents(events);
            return commands.stream().map(QueuedCommand::toCommand).collect(Collectors.toList());
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateCommand(boolean local, long deviceId) {
        DeviceSession deviceSession;
        if (!local && (deviceSession = this.connectionManager.getDeviceSession(deviceId)) != null && deviceSession.supportsLiveCommands()) {
            for (Command command : this.readQueuedCommands(deviceId)) {
                deviceSession.sendCommand(command);
            }
        }
    }

    public void updateNotificationToken(long deviceId, String token) {
        Object key = new Object();
        try {
            this.cacheManager.addDevice(deviceId, key);
            Device device = this.cacheManager.getObject(Device.class, deviceId);
            device.set("notificationTokens", token);
            this.storage.updateObject(device, new Request((Columns)new Columns.Include("attributes"), new Condition.Equals("id", deviceId)));
            this.cacheManager.invalidateObject(true, Device.class, deviceId, ObjectOperation.UPDATE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.cacheManager.removeDevice(deviceId, key);
        }
    }
}

