/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.termstat;

import com.o19s.es.explore.StatisticsHelper;
import com.o19s.es.ltr.utils.Scripting;
import com.o19s.es.termstat.TermStatQuery;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryShardContext;

public class TermStatQueryBuilder
extends AbstractQueryBuilder<TermStatQueryBuilder>
implements NamedWriteable {
    public static final String NAME = "term_stat";
    private static final ParseField EXPR_NAME = new ParseField("expr", new String[0]);
    private static final ParseField AGGR_NAME = new ParseField("aggr", new String[0]);
    private static final ParseField POS_AGGR_NAME = new ParseField("pos_aggr", new String[0]);
    private static final ParseField TERMS_NAME = new ParseField("terms", new String[0]);
    private static final ParseField FIELDS_NAME = new ParseField("fields", new String[0]);
    private static final ParseField ANALYZER_NAME = new ParseField("analyzer", new String[0]);
    private static final ObjectParser<TermStatQueryBuilder, Void> PARSER = new ObjectParser("term_stat", TermStatQueryBuilder::new);
    private String[] terms;
    private String[] fields;
    private String analyzerName;
    private String expr;
    private String aggr;
    private String pos_aggr;

    public TermStatQueryBuilder() {
    }

    public TermStatQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.expr = in.readString();
        this.aggr = in.readString();
        this.pos_aggr = in.readOptionalString();
        this.terms = in.readStringArray();
        this.fields = in.readStringArray();
        this.analyzerName = in.readOptionalString();
    }

    public static TermStatQueryBuilder fromXContent(XContentParser parser) throws IOException {
        TermStatQueryBuilder builder;
        try {
            builder = (TermStatQueryBuilder)((Object)PARSER.parse(parser, null));
        }
        catch (IllegalArgumentException iae) {
            throw new ParsingException(parser.getTokenLocation(), iae.getMessage(), (Throwable)iae, new Object[0]);
        }
        if (builder.terms == null) {
            throw new ParsingException(parser.getTokenLocation(), "Field [" + String.valueOf(TERMS_NAME) + "] is mandatory", new Object[0]);
        }
        if (builder.expr == null) {
            throw new ParsingException(parser.getTokenLocation(), "Field [" + String.valueOf(EXPR_NAME) + "] is mandatory", new Object[0]);
        }
        if (builder.fields == null) {
            builder.fields(new String[]{"*"});
        }
        if (builder.aggr == null) {
            builder.aggr(StatisticsHelper.AggrType.AVG.getType());
        }
        if (builder.pos_aggr == null) {
            builder.posAggr(StatisticsHelper.AggrType.AVG.getType());
        }
        return builder;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.expr);
        out.writeString(this.aggr);
        out.writeOptionalString(this.pos_aggr);
        out.writeStringArray(this.terms);
        out.writeStringArray(this.fields);
        out.writeOptionalString(this.analyzerName);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        this.printBoostAndQueryName(builder);
        builder.field(EXPR_NAME.getPreferredName(), this.expr);
        builder.field(AGGR_NAME.getPreferredName(), this.aggr);
        builder.field(POS_AGGR_NAME.getPreferredName(), this.pos_aggr);
        builder.array(TERMS_NAME.getPreferredName(), this.terms);
        builder.array(FIELDS_NAME.getPreferredName(), this.fields);
        builder.field(ANALYZER_NAME.getPreferredName(), this.analyzerName);
        builder.endObject();
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        Expression compiledExpression = (Expression)Scripting.compile(this.expr);
        StatisticsHelper.AggrType aggrType = StatisticsHelper.AggrType.valueOf(this.aggr.toUpperCase(Locale.ROOT));
        StatisticsHelper.AggrType posAggrType = StatisticsHelper.AggrType.valueOf(this.pos_aggr.toUpperCase(Locale.ROOT));
        Analyzer analyzer = null;
        HashSet<Term> termSet = new HashSet<Term>();
        for (String field : this.fields) {
            if (this.analyzerName == null) {
                analyzer = this.getAnalyzerForField(context, field);
            } else if (analyzer == null) {
                analyzer = this.getAnalyzerByName(context, this.analyzerName);
            }
            if (analyzer == null) {
                throw new IllegalArgumentException("No analyzer found for [" + this.analyzerName + "]");
            }
            for (String termString : this.terms) {
                TokenStream ts = analyzer.tokenStream(field, termString);
                TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)ts.getAttribute(TermToBytesRefAttribute.class);
                ts.reset();
                while (ts.incrementToken()) {
                    termSet.add(new Term(field, termAtt.getBytesRef()));
                }
                ts.close();
            }
        }
        return new TermStatQuery(compiledExpression, aggrType, posAggrType, termSet);
    }

    private Analyzer getAnalyzerForField(QueryShardContext context, String fieldName) {
        MappedFieldType fieldType = context.getMapperService().fieldType(fieldName);
        return context.getSearchAnalyzer(fieldType);
    }

    private Analyzer getAnalyzerByName(QueryShardContext context, String analyzerName) {
        return context.getMapperService().getIndexAnalyzers().get(analyzerName);
    }

    protected int doHashCode() {
        return Objects.hash(this.expr, this.aggr, this.pos_aggr, Arrays.hashCode(this.terms), Arrays.hashCode(this.fields), this.analyzerName);
    }

    protected boolean doEquals(TermStatQueryBuilder other) {
        return Objects.equals(this.expr, other.expr) && Objects.equals(this.aggr, other.aggr) && Objects.equals(this.pos_aggr, other.pos_aggr) && Arrays.equals(this.terms, other.terms) && Arrays.equals(this.fields, other.fields) && Objects.equals(this.analyzerName, other.analyzerName);
    }

    public String getWriteableName() {
        return NAME;
    }

    public String aggr() {
        return this.aggr;
    }

    public TermStatQueryBuilder aggr(String aggr) {
        this.aggr = aggr;
        return this;
    }

    public String analyzer() {
        return this.analyzerName;
    }

    public TermStatQueryBuilder analyzer(String analyzer) {
        this.analyzerName = analyzer;
        return this;
    }

    public String expr() {
        return this.expr;
    }

    public TermStatQueryBuilder expr(String expr) {
        this.expr = expr;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    public TermStatQueryBuilder fields(String[] fields) {
        this.fields = fields;
        return this;
    }

    public TermStatQueryBuilder fields(List<String> text) {
        this.fields = text.toArray(new String[0]);
        return this;
    }

    public String posAggr() {
        return this.pos_aggr;
    }

    public TermStatQueryBuilder posAggr(String pos_aggr) {
        this.pos_aggr = pos_aggr;
        return this;
    }

    public String[] terms() {
        return this.terms;
    }

    public TermStatQueryBuilder terms(String[] terms) {
        this.terms = terms;
        return this;
    }

    public TermStatQueryBuilder terms(List<String> terms) {
        this.terms = terms.toArray(new String[0]);
        return this;
    }

    static {
        PARSER.declareStringArray(TermStatQueryBuilder::terms, TERMS_NAME);
        PARSER.declareStringArray(TermStatQueryBuilder::fields, FIELDS_NAME);
        PARSER.declareStringOrNull(TermStatQueryBuilder::analyzer, ANALYZER_NAME);
        PARSER.declareString(TermStatQueryBuilder::expr, EXPR_NAME);
        PARSER.declareString(TermStatQueryBuilder::aggr, AGGR_NAME);
        PARSER.declareStringOrNull(TermStatQueryBuilder::posAggr, POS_AGGR_NAME);
        TermStatQueryBuilder.declareStandardFields(PARSER);
    }
}

