/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.regex.Pattern;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.function.FunctionProperties;

public final class DateTimeUtils {
    private static final Pattern OFFSET_PATTERN = Pattern.compile("([+-])(\\d+)([smhdwMy]?)");
    private static final DateTimeFormatter DIRECT_FORMATTER = DateTimeFormatter.ofPattern("MM/dd/yyyy:HH:mm:ss");

    public static long roundFloor(long utcMillis, long unitMillis) {
        return utcMillis - utcMillis % unitMillis;
    }

    public static long roundWeek(long utcMillis, int interval) {
        return DateTimeUtils.roundFloor(utcMillis + 259200000L, 604800000L * (long)interval) - 259200000L;
    }

    public static long roundMonth(long utcMillis, int interval) {
        ZonedDateTime initDateTime = ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(utcMillis).atZone(ZoneOffset.UTC).plusMonths(interval);
        long monthDiff = (long)(zonedDateTime.getYear() - initDateTime.getYear()) * 12L + (long)zonedDateTime.getMonthValue() - (long)initDateTime.getMonthValue();
        long monthToAdd = (monthDiff / (long)interval - 1L) * (long)interval;
        return initDateTime.plusMonths(monthToAdd).toInstant().toEpochMilli();
    }

    public static long roundQuarter(long utcMillis, int interval) {
        ZonedDateTime initDateTime = ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(utcMillis).atZone(ZoneOffset.UTC).plusMonths((long)interval * 3L);
        long monthDiff = (long)(zonedDateTime.getYear() - initDateTime.getYear()) * 12L + (long)zonedDateTime.getMonthValue() - (long)initDateTime.getMonthValue();
        long monthToAdd = (monthDiff / ((long)interval * 3L) - 1L) * (long)interval * 3L;
        return initDateTime.plusMonths(monthToAdd).toInstant().toEpochMilli();
    }

    public static long roundYear(long utcMillis, int interval) {
        ZonedDateTime initDateTime = ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(utcMillis).atZone(ZoneOffset.UTC);
        int yearDiff = zonedDateTime.getYear() - initDateTime.getYear();
        int yearToAdd = yearDiff / interval * interval;
        return initDateTime.plusYears(yearToAdd).toInstant().toEpochMilli();
    }

    public static long getWindowStartTime(long timestamp, long size) {
        return timestamp - timestamp % size;
    }

    public static Boolean isValidMySqlTimeZoneId(ZoneId zone) {
        String timeZoneMax = "+14:00";
        String timeZoneMin = "-13:59";
        String timeZoneZero = "+00:00";
        ZoneId maxTz = ZoneId.of(timeZoneMax);
        ZoneId minTz = ZoneId.of(timeZoneMin);
        ZoneId defaultTz = ZoneId.of(timeZoneZero);
        ZonedDateTime defaultDateTime = LocalDateTime.of(2000, 1, 2, 12, 0).atZone(defaultTz);
        ZonedDateTime maxTzValidator = defaultDateTime.withZoneSameInstant(maxTz).withZoneSameLocal(defaultTz);
        ZonedDateTime minTzValidator = defaultDateTime.withZoneSameInstant(minTz).withZoneSameLocal(defaultTz);
        ZonedDateTime passedTzValidator = defaultDateTime.withZoneSameInstant(zone).withZoneSameLocal(defaultTz);
        return !(!passedTzValidator.isBefore(maxTzValidator) && !passedTzValidator.isEqual(maxTzValidator) || !passedTzValidator.isAfter(minTzValidator) && !passedTzValidator.isEqual(minTzValidator));
    }

    public static Instant extractTimestamp(ExprValue value, FunctionProperties functionProperties) {
        return value instanceof ExprTimeValue ? ((ExprTimeValue)value).timestampValue(functionProperties) : value.timestampValue();
    }

    public static LocalDate extractDate(ExprValue value, FunctionProperties functionProperties) {
        return value instanceof ExprTimeValue ? ((ExprTimeValue)value).dateValue(functionProperties) : value.dateValue();
    }

    public static ZonedDateTime getRelativeZonedDateTime(String input, ZonedDateTime baseTime) {
        try {
            Instant parsed = LocalDateTime.parse(input, DIRECT_FORMATTER).toInstant(ZoneOffset.UTC);
            return parsed.atZone(baseTime.getZone());
        }
        catch (DateTimeParseException parsed) {
            if ("now".equalsIgnoreCase(input) || "now()".equalsIgnoreCase(input)) {
                return baseTime;
            }
            ZonedDateTime result = baseTime;
            int i = 0;
            while (i < input.length()) {
                int j;
                char c = input.charAt(i);
                if (c == '@') {
                    for (j = i + 1; j < input.length() && Character.isLetterOrDigit(input.charAt(j)); ++j) {
                    }
                    String rawUnit = input.substring(i + 1, j);
                    result = DateTimeUtils.applySnap(result, rawUnit);
                    i = j;
                    continue;
                }
                if (c == '+' || c == '-') {
                    int k;
                    for (j = i + 1; j < input.length() && Character.isDigit(input.charAt(j)); ++j) {
                    }
                    String valueStr = input.substring(i + 1, j);
                    int value = valueStr.isEmpty() ? 1 : Integer.parseInt(valueStr);
                    for (k = j; k < input.length() && Character.isLetter(input.charAt(k)); ++k) {
                    }
                    String rawUnit = input.substring(j, k);
                    result = DateTimeUtils.applyOffset(result, String.valueOf(c), value, rawUnit);
                    i = k;
                    continue;
                }
                throw new IllegalArgumentException("Unexpected character '" + c + "' at position " + i + " in input: " + input);
            }
            return result;
        }
    }

    private static ZonedDateTime applyOffset(ZonedDateTime base, String sign, int value, String rawUnit) {
        String unit = DateTimeUtils.normalizeUnit(rawUnit);
        if ("q".equals(unit)) {
            int months = value * 3;
            return sign.equals("-") ? base.minusMonths(months) : base.plusMonths(months);
        }
        ChronoUnit chronoUnit = switch (unit) {
            case "s" -> ChronoUnit.SECONDS;
            case "m" -> ChronoUnit.MINUTES;
            case "h" -> ChronoUnit.HOURS;
            case "d" -> ChronoUnit.DAYS;
            case "w" -> ChronoUnit.WEEKS;
            case "M" -> ChronoUnit.MONTHS;
            case "y" -> ChronoUnit.YEARS;
            default -> throw new IllegalArgumentException("Unsupported offset unit: " + rawUnit);
        };
        return sign.equals("-") ? base.minus(value, chronoUnit) : base.plus(value, chronoUnit);
    }

    private static ZonedDateTime applySnap(ZonedDateTime base, String rawUnit) {
        String unit;
        return switch (unit = DateTimeUtils.normalizeUnit(rawUnit)) {
            case "s" -> base.truncatedTo(ChronoUnit.SECONDS);
            case "m" -> base.truncatedTo(ChronoUnit.MINUTES);
            case "h" -> base.truncatedTo(ChronoUnit.HOURS);
            case "d" -> base.truncatedTo(ChronoUnit.DAYS);
            case "w" -> base.minusDays(base.getDayOfWeek().getValue() % 7).truncatedTo(ChronoUnit.DAYS);
            case "M" -> base.withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
            case "y" -> base.withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            case "q" -> {
                int month = base.getMonthValue();
                int quarterStart = (month - 1) / 3 * 3 + 1;
                yield base.withMonth(quarterStart).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
            }
            default -> {
                if (unit.matches("w[0-7]")) {
                    int targetDay = unit.equals("w0") || unit.equals("w7") ? 7 : Integer.parseInt(unit.substring(1));
                    int diff = (base.getDayOfWeek().getValue() - targetDay + 7) % 7;
                    yield base.minusDays(diff).truncatedTo(ChronoUnit.DAYS);
                }
                throw new IllegalArgumentException("Unsupported snap unit: " + rawUnit);
            }
        };
    }

    private static String normalizeUnit(String rawUnit) {
        switch (rawUnit.toLowerCase(Locale.ROOT)) {
            case "m": 
            case "min": 
            case "mins": 
            case "minute": 
            case "minutes": {
                return "m";
            }
            case "s": 
            case "sec": 
            case "secs": 
            case "second": 
            case "seconds": {
                return "s";
            }
            case "h": 
            case "hr": 
            case "hrs": 
            case "hour": 
            case "hours": {
                return "h";
            }
            case "d": 
            case "day": 
            case "days": {
                return "d";
            }
            case "w": 
            case "wk": 
            case "wks": 
            case "week": 
            case "weeks": {
                return "w";
            }
            case "mon": 
            case "month": 
            case "months": {
                return "M";
            }
            case "y": 
            case "yr": 
            case "yrs": 
            case "year": 
            case "years": {
                return "y";
            }
            case "q": 
            case "qtr": 
            case "qtrs": 
            case "quarter": 
            case "quarters": {
                return "q";
            }
        }
        String lower = rawUnit.toLowerCase();
        if (lower.matches("w[0-7]")) {
            return lower;
        }
        throw new IllegalArgumentException("Unsupported unit alias: " + rawUnit);
    }

    @Generated
    private DateTimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

