/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.aggregation;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.missing.MissingOrder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.aggregation.NamedAggregator;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.response.agg.CompositeAggregationParser;
import org.opensearch.sql.opensearch.response.agg.MetricParser;
import org.opensearch.sql.opensearch.response.agg.NoBucketAggregationParser;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.opensearch.storage.script.aggregation.dsl.BucketAggregationBuilder;
import org.opensearch.sql.opensearch.storage.script.aggregation.dsl.MetricAggregationBuilder;
import org.opensearch.sql.opensearch.storage.serialization.ExpressionSerializer;
import shaded.com.google.common.annotations.VisibleForTesting;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class AggregationQueryBuilder
extends ExpressionNodeVisitor<AggregationBuilder, Object> {
    public static final int AGGREGATION_BUCKET_SIZE = 1000;
    private final BucketAggregationBuilder bucketBuilder;
    private final MetricAggregationBuilder metricBuilder;

    public AggregationQueryBuilder(ExpressionSerializer serializer) {
        this.bucketBuilder = new BucketAggregationBuilder(serializer);
        this.metricBuilder = new MetricAggregationBuilder(serializer);
    }

    public Pair<List<AggregationBuilder>, OpenSearchAggregationResponseParser> buildAggregationBuilder(List<NamedAggregator> namedAggregatorList, List<NamedExpression> groupByList, List<Pair<Sort.SortOption, Expression>> sortList) {
        Pair<AggregatorFactories.Builder, List<MetricParser>> metrics = this.metricBuilder.build(namedAggregatorList);
        if (groupByList.isEmpty()) {
            return Pair.of((Object)ImmutableList.copyOf((Collection)((AggregatorFactories.Builder)metrics.getLeft()).getAggregatorFactories()), (Object)new NoBucketAggregationParser((List)metrics.getRight()));
        }
        GroupSortOrder groupSortOrder = new GroupSortOrder(sortList);
        return Pair.of(Collections.singletonList(((CompositeAggregationBuilder)AggregationBuilders.composite((String)"composite_buckets", this.bucketBuilder.build(groupByList.stream().sorted(groupSortOrder).map(expr -> Triple.of((Object)expr, (Object)groupSortOrder.sortOrder((NamedExpression)expr), (Object)groupSortOrder.missingOrder((NamedExpression)expr))).collect(Collectors.toList()))).subAggregations((AggregatorFactories.Builder)metrics.getLeft())).size(1000)), (Object)new CompositeAggregationParser((List)metrics.getRight()));
    }

    public Map<String, OpenSearchDataType> buildTypeMapping(List<NamedAggregator> namedAggregatorList, List<NamedExpression> groupByList) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        namedAggregatorList.forEach(agg -> builder.put((Object)agg.getName(), (Object)OpenSearchDataType.of(agg.type())));
        groupByList.forEach(group -> builder.put((Object)group.getName(), (Object)OpenSearchDataType.of(group.type())));
        return builder.build();
    }

    @Generated
    public AggregationQueryBuilder(BucketAggregationBuilder bucketBuilder, MetricAggregationBuilder metricBuilder) {
        this.bucketBuilder = bucketBuilder;
        this.metricBuilder = metricBuilder;
    }

    @VisibleForTesting
    public static class GroupSortOrder
    implements Comparator<NamedExpression> {
        private static final Pair<Sort.SortOption, Integer> DEFAULT_ORDER = Pair.of((Object)Sort.SortOption.DEFAULT_ASC, (Object)Integer.MAX_VALUE);
        private static final Map<Sort.SortOrder, SortOrder> SORT_MAP = new ImmutableMap.Builder().put((Object)Sort.SortOrder.ASC, (Object)SortOrder.ASC).put((Object)Sort.SortOrder.DESC, (Object)SortOrder.DESC).build();
        private static final Map<Sort.NullOrder, MissingOrder> NULL_MAP = new ImmutableMap.Builder().put((Object)Sort.NullOrder.NULL_FIRST, (Object)MissingOrder.FIRST).put((Object)Sort.NullOrder.NULL_LAST, (Object)MissingOrder.LAST).build();
        private final Map<String, Pair<Sort.SortOption, Integer>> map = new HashMap<String, Pair<Sort.SortOption, Integer>>();

        public GroupSortOrder(List<Pair<Sort.SortOption, Expression>> sortList) {
            if (null == sortList) {
                return;
            }
            int pos = 0;
            for (Pair<Sort.SortOption, Expression> sortPair : sortList) {
                this.map.put(((ReferenceExpression)sortPair.getRight()).getAttr(), (Pair<Sort.SortOption, Integer>)Pair.of((Object)((Sort.SortOption)sortPair.getLeft()), (Object)pos++));
            }
        }

        @Override
        public int compare(NamedExpression o1, NamedExpression o2) {
            Pair<Sort.SortOption, Integer> o1Value = this.map.getOrDefault(o1.getName(), DEFAULT_ORDER);
            Pair<Sort.SortOption, Integer> o2Value = this.map.getOrDefault(o2.getName(), DEFAULT_ORDER);
            return ((Integer)o1Value.getRight()).compareTo((Integer)o2Value.getRight());
        }

        public SortOrder sortOrder(NamedExpression expression) {
            return SORT_MAP.get((Object)this.sortOption(expression).getSortOrder());
        }

        public MissingOrder missingOrder(NamedExpression expression) {
            return NULL_MAP.get((Object)this.sortOption(expression).getNullOrder());
        }

        private Sort.SortOption sortOption(NamedExpression expression) {
            return (Sort.SortOption)this.map.getOrDefault(expression.getName(), DEFAULT_ORDER).getLeft();
        }
    }
}

