/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.sql.calcite.plan.AbstractOpenSearchTable;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.monitor.OpenSearchMemoryHealthy;
import org.opensearch.sql.opensearch.monitor.OpenSearchResourceMonitor;
import org.opensearch.sql.opensearch.planner.physical.ADOperator;
import org.opensearch.sql.opensearch.planner.physical.MLCommonsOperator;
import org.opensearch.sql.opensearch.planner.physical.MLOperator;
import org.opensearch.sql.opensearch.planner.physical.OpenSearchEvalOperator;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.request.OpenSearchRequestBuilder;
import org.opensearch.sql.opensearch.request.system.OpenSearchDescribeIndexRequest;
import org.opensearch.sql.opensearch.storage.scan.CalciteLogicalIndexScan;
import org.opensearch.sql.opensearch.storage.scan.OpenSearchIndexScan;
import org.opensearch.sql.opensearch.storage.scan.OpenSearchIndexScanBuilder;
import org.opensearch.sql.planner.DefaultImplementor;
import org.opensearch.sql.planner.logical.LogicalAD;
import org.opensearch.sql.planner.logical.LogicalEval;
import org.opensearch.sql.planner.logical.LogicalML;
import org.opensearch.sql.planner.logical.LogicalMLCommons;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.storage.read.TableScanBuilder;
import shaded.com.google.common.annotations.VisibleForTesting;

public class OpenSearchIndex
extends AbstractOpenSearchTable {
    public static final String METADATA_FIELD_ID = "_id";
    public static final String METADATA_FIELD_INDEX = "_index";
    public static final String METADATA_FIELD_SCORE = "_score";
    public static final String METADATA_FIELD_MAXSCORE = "_maxscore";
    public static final String METADATA_FIELD_SORT = "_sort";
    public static final String METADATA_FIELD_ROUTING = "_routing";
    public static final Map<String, ExprType> METADATAFIELD_TYPE_MAP = new LinkedHashMap<String, ExprType>(){
        {
            this.put(OpenSearchIndex.METADATA_FIELD_ID, ExprCoreType.STRING);
            this.put(OpenSearchIndex.METADATA_FIELD_INDEX, ExprCoreType.STRING);
            this.put(OpenSearchIndex.METADATA_FIELD_SCORE, ExprCoreType.FLOAT);
            this.put(OpenSearchIndex.METADATA_FIELD_MAXSCORE, ExprCoreType.FLOAT);
            this.put(OpenSearchIndex.METADATA_FIELD_SORT, ExprCoreType.LONG);
            this.put(OpenSearchIndex.METADATA_FIELD_ROUTING, ExprCoreType.STRING);
        }
    };
    private final OpenSearchClient client;
    private final Settings settings;
    private final OpenSearchRequest.IndexName indexName;
    private Map<String, OpenSearchDataType> cachedFieldOpenSearchTypes = null;
    private Map<String, ExprType> cachedFieldTypes = null;
    private Map<String, String> aliasMapping = null;
    private Integer cachedMaxResultWindow = null;

    public OpenSearchIndex(OpenSearchClient client, Settings settings, String indexName) {
        this.client = client;
        this.settings = settings;
        this.indexName = new OpenSearchRequest.IndexName(indexName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new CalciteLogicalIndexScan(cluster, relOptTable, this);
    }

    @Override
    public boolean exists() {
        return this.client.exists(this.indexName.toString());
    }

    @Override
    public void create(Map<String, ExprType> schema) {
        HashMap<String, Object> mappings = new HashMap<String, Object>();
        HashMap<String, String> properties = new HashMap<String, String>();
        mappings.put("properties", properties);
        for (Map.Entry<String, ExprType> colType : schema.entrySet()) {
            properties.put(colType.getKey(), colType.getValue().legacyTypeName().toLowerCase());
        }
        this.client.createIndex(this.indexName.toString(), mappings);
    }

    @Override
    public Map<String, ExprType> getFieldTypes() {
        if (this.cachedFieldOpenSearchTypes == null) {
            this.cachedFieldOpenSearchTypes = new OpenSearchDescribeIndexRequest(this.client, this.indexName).getFieldTypes();
        }
        if (this.cachedFieldTypes == null) {
            this.cachedFieldTypes = OpenSearchDataType.traverseAndFlatten(this.cachedFieldOpenSearchTypes).entrySet().stream().collect(LinkedHashMap::new, (map, item) -> map.put((String)item.getKey(), ((OpenSearchDataType)item.getValue()).getExprType()), Map::putAll);
        }
        return this.cachedFieldTypes;
    }

    @Override
    public Map<String, ExprType> getReservedFieldTypes() {
        return METADATAFIELD_TYPE_MAP;
    }

    public Map<String, String> getAliasMapping() {
        if (this.cachedFieldOpenSearchTypes == null) {
            this.cachedFieldOpenSearchTypes = new OpenSearchDescribeIndexRequest(this.client, this.indexName).getFieldTypes();
        }
        if (this.aliasMapping == null) {
            this.aliasMapping = this.cachedFieldOpenSearchTypes.entrySet().stream().filter(entry -> ((OpenSearchDataType)entry.getValue()).getOriginalPath().isPresent()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> ((OpenSearchDataType)entry.getValue()).getOriginalPath().get()));
        }
        return this.aliasMapping;
    }

    public Map<String, OpenSearchDataType> getFieldOpenSearchTypes() {
        if (this.cachedFieldOpenSearchTypes == null) {
            this.cachedFieldOpenSearchTypes = new OpenSearchDescribeIndexRequest(this.client, this.indexName).getFieldTypes();
        }
        return this.cachedFieldOpenSearchTypes;
    }

    public Integer getMaxResultWindow() {
        if (this.cachedMaxResultWindow == null) {
            this.cachedMaxResultWindow = new OpenSearchDescribeIndexRequest(this.client, this.indexName).getMaxResultWindow();
        }
        return this.cachedMaxResultWindow;
    }

    @Override
    public PhysicalPlan implement(LogicalPlan plan) {
        return plan.accept(new OpenSearchDefaultImplementor(this.client), null);
    }

    @Override
    public TableScanBuilder createScanBuilder() {
        TimeValue cursorKeepAlive = (TimeValue)this.settings.getSettingValue(Settings.Key.SQL_CURSOR_KEEP_ALIVE);
        OpenSearchRequestBuilder builder = this.createRequestBuilder();
        Function<OpenSearchRequestBuilder, OpenSearchIndexScan> createScanOperator = requestBuilder -> new OpenSearchIndexScan(this.client, requestBuilder.getMaxResponseSize(), requestBuilder.build(this.indexName, cursorKeepAlive, this.client, this.cachedFieldOpenSearchTypes.isEmpty()));
        return new OpenSearchIndexScanBuilder(builder, createScanOperator);
    }

    private OpenSearchExprValueFactory createExprValueFactory() {
        HashMap<String, OpenSearchDataType> allFields = new HashMap<String, OpenSearchDataType>();
        this.getReservedFieldTypes().forEach((k, v) -> allFields.put((String)k, OpenSearchDataType.of(v)));
        allFields.putAll(this.getFieldOpenSearchTypes());
        return new OpenSearchExprValueFactory(allFields, (Boolean)this.settings.getSettingValue(Settings.Key.FIELD_TYPE_TOLERANCE));
    }

    public boolean isFieldTypeTolerance() {
        return (Boolean)this.settings.getSettingValue(Settings.Key.FIELD_TYPE_TOLERANCE);
    }

    public OpenSearchRequestBuilder createRequestBuilder() {
        return new OpenSearchRequestBuilder(this.createExprValueFactory(), this.getMaxResultWindow(), this.settings);
    }

    public OpenSearchResourceMonitor createOpenSearchResourceMonitor() {
        return new OpenSearchResourceMonitor(this.getSettings(), new OpenSearchMemoryHealthy());
    }

    public OpenSearchRequest buildRequest(OpenSearchRequestBuilder requestBuilder) {
        TimeValue cursorKeepAlive = (TimeValue)this.settings.getSettingValue(Settings.Key.SQL_CURSOR_KEEP_ALIVE);
        return requestBuilder.build(this.indexName, cursorKeepAlive, this.client, this.cachedFieldOpenSearchTypes.isEmpty());
    }

    @Generated
    public OpenSearchClient getClient() {
        return this.client;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @VisibleForTesting
    public static class OpenSearchDefaultImplementor
    extends DefaultImplementor<OpenSearchIndexScan> {
        private final OpenSearchClient client;

        @Override
        public PhysicalPlan visitMLCommons(LogicalMLCommons node, OpenSearchIndexScan context) {
            return new MLCommonsOperator(this.visitChild(node, context), node.getAlgorithm(), node.getArguments(), this.client.getNodeClient());
        }

        @Override
        public PhysicalPlan visitAD(LogicalAD node, OpenSearchIndexScan context) {
            return new ADOperator(this.visitChild(node, context), node.getArguments(), this.client.getNodeClient());
        }

        @Override
        public PhysicalPlan visitML(LogicalML node, OpenSearchIndexScan context) {
            return new MLOperator(this.visitChild(node, context), node.getArguments(), this.client.getNodeClient());
        }

        @Override
        public PhysicalPlan visitEval(LogicalEval node, OpenSearchIndexScan context) {
            return new OpenSearchEvalOperator(this.visitChild(node, context), node.getExpressions(), this.client.getNodeClient());
        }

        @Generated
        public OpenSearchDefaultImplementor(OpenSearchClient client) {
            this.client = client;
        }
    }
}

