/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.data.utils;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.common.geo.GeoUtils;
import org.opensearch.common.xcontent.json.JsonXContentParser;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.sql.opensearch.data.utils.Content;
import shaded.com.google.common.collect.Iterators;

public class OpenSearchJsonContent
implements Content {
    private final JsonNode value;

    @Override
    public Integer intValue() {
        return this.value().intValue();
    }

    @Override
    public Long longValue() {
        return this.value().longValue();
    }

    @Override
    public Short shortValue() {
        return this.value().shortValue();
    }

    @Override
    public Byte byteValue() {
        return (byte)this.value().shortValue();
    }

    @Override
    public Float floatValue() {
        return Float.valueOf(this.value().floatValue());
    }

    @Override
    public Double doubleValue() {
        return this.value().doubleValue();
    }

    @Override
    public String stringValue() {
        return this.value().asText();
    }

    @Override
    public Boolean booleanValue() {
        return this.value().booleanValue();
    }

    @Override
    public Iterator<Map.Entry<String, Content>> map() {
        LinkedHashMap map = new LinkedHashMap();
        JsonNode mapValue = this.value();
        mapValue.fieldNames().forEachRemaining(field -> map.put(field, new OpenSearchJsonContent(mapValue.get(field))));
        return map.entrySet().iterator();
    }

    @Override
    public Iterator<? extends Content> array() {
        return Iterators.transform((Iterator)this.value.elements(), OpenSearchJsonContent::new);
    }

    @Override
    public boolean isNull() {
        return this.value == null || this.value.isNull() || this.value.isArray() && this.value.isEmpty();
    }

    @Override
    public boolean isNumber() {
        return this.value().isNumber();
    }

    @Override
    public boolean isLong() {
        return this.value().isLong();
    }

    @Override
    public boolean isFloat() {
        return this.value().isFloat();
    }

    @Override
    public boolean isDouble() {
        return this.value().isDouble();
    }

    @Override
    public boolean isString() {
        return this.value().isTextual();
    }

    @Override
    public boolean isBoolean() {
        return this.value().isBoolean();
    }

    @Override
    public boolean isArray() {
        return this.value().isArray();
    }

    @Override
    public Object objectValue() {
        return this.value();
    }

    @Override
    public Pair<Double, Double> geoValue() {
        Pair pair;
        JsonNode value = this.value();
        JsonXContentParser parser = new JsonXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, value.traverse());
        try {
            parser.nextToken();
            GeoPoint point = new GeoPoint();
            GeoUtils.parseGeoPoint((XContentParser)parser, (GeoPoint)point, (boolean)true);
            pair = Pair.of((Object)point.getLat(), (Object)point.getLon());
        }
        catch (Throwable throwable) {
            try {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new OpenSearchParseException("error parsing geo point", (Throwable)ex, new Object[0]);
            }
        }
        parser.close();
        return pair;
    }

    private JsonNode value() {
        return this.value;
    }

    @Generated
    public OpenSearchJsonContent(JsonNode value) {
        this.value = value;
    }
}

