/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.esdomain;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.legacy.esdomain.mapping.IndexMappings;
import org.opensearch.sql.opensearch.setting.OpenSearchSettings;
import org.opensearch.transport.client.Client;

public class LocalClusterState {
    private static final Logger LOG = LogManager.getLogger();
    private static LocalClusterState INSTANCE;
    private ClusterService clusterService;
    private Client client;
    private OpenSearchSettings pluginSettings;
    private final Map<String, Object> latestSettings = new ConcurrentHashMap<String, Object>();

    public static synchronized LocalClusterState state() {
        if (INSTANCE == null) {
            INSTANCE = new LocalClusterState();
        }
        return INSTANCE;
    }

    public static synchronized void state(LocalClusterState instance) {
        INSTANCE = instance;
    }

    public void setClusterService(@NonNull ClusterService clusterService) {
        if (clusterService == null) {
            throw new NullPointerException("clusterService is marked non-null but is null");
        }
        this.clusterService = clusterService;
    }

    public void setClient(@NonNull Client client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.client = client;
    }

    public void setPluginSettings(@NonNull OpenSearchSettings settings) {
        if (settings == null) {
            throw new NullPointerException("settings is marked non-null but is null");
        }
        this.pluginSettings = settings;
        for (Setting<?> setting : settings.getSettings()) {
            this.clusterService.getClusterSettings().addSettingsUpdateConsumer(setting, newVal -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The value of setting [{}] changed to [{}]", (Object)setting.getKey(), newVal);
                }
                this.latestSettings.put(setting.getKey(), newVal);
            });
        }
    }

    public <T> T getSettingValue(Settings.Key key) {
        Objects.requireNonNull(this.pluginSettings, "SQL plugin setting is null");
        return (T)this.latestSettings.getOrDefault(key.getKeyValue(), this.pluginSettings.getSettingValue(key));
    }

    public IndexMappings getFieldMappings(String[] indices) {
        Objects.requireNonNull(this.client, "Client is null");
        try {
            Map mappingMetadata = ((GetMappingsResponse)((GetMappingsRequestBuilder)((GetMappingsRequestBuilder)this.client.admin().indices().prepareGetMappings(indices).setLocal(true)).setIndicesOptions(IndicesOptions.strictExpandOpen())).execute().actionGet(0L, TimeUnit.NANOSECONDS)).mappings();
            IndexMappings mappings = new IndexMappings(mappingMetadata);
            LOG.debug("Found mappings: {}", (Object)mappings);
            return mappings;
        }
        catch (IndexNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read mapping in cluster state for indices=" + Arrays.toString(indices), e);
        }
    }

    private LocalClusterState() {
    }
}

