/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.PPLReturnTypes;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class WeekdayFunction
extends ImplementorUDF {
    public WeekdayFunction() {
        super(new WeekdayImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return PPLReturnTypes.INTEGER_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrap((CompositeOperandTypeChecker)OperandTypes.DATETIME.or(OperandTypes.STRING).or((SqlSingleOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.DATETIME, SqlTypeFamily.INTEGER})));
    }

    public static class WeekdayImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator rexToLixTranslator, RexCall rexCall, List<Expression> operands) {
            MethodCallExpression functionProperties = Expressions.call(UserDefinedFunctionUtils.class, (String)"restoreFunctionProperties", (Expression[])new Expression[]{rexToLixTranslator.getRoot()});
            ExprType dateType = OpenSearchTypeFactory.convertRelDataTypeToExprType(((RexNode)rexCall.getOperands().getFirst()).getType());
            MethodCallExpression date = Expressions.call(ExprValueUtils.class, (String)"fromObjectValue", (Expression[])new Expression[]{operands.getFirst(), Expressions.constant((Object)dateType)});
            if (ExprCoreType.TIME.equals(dateType)) {
                return Expressions.call(WeekdayImplementor.class, (String)"weekdayForTime", (Expression[])new Expression[]{functionProperties});
            }
            return Expressions.call(WeekdayImplementor.class, (String)"weekday", (Expression[])new Expression[]{date});
        }

        public static int weekday(ExprValue date) {
            return DateTimeFunctions.exprWeekday(date).integerValue();
        }

        public static int weekdayForTime(FunctionProperties functionProperties) {
            return DateTimeFunctions.formatNow(functionProperties.getQueryStartClock()).getDayOfWeek().getValue() - 1;
        }
    }
}

