/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.grok;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.sql.common.grok.Grok;
import org.opensearch.sql.common.grok.GrokUtils;
import org.opensearch.sql.common.grok.exception.GrokException;

public class GrokCompiler
implements Serializable {
    private static final Pattern patternLinePattern = Pattern.compile("^([a-zA-Z0-9_]+)\\s+(.*)$");
    private final Map<String, String> grokPatternDefinitions = new HashMap<String, String>();

    private GrokCompiler() {
    }

    public static GrokCompiler newInstance() {
        return new GrokCompiler();
    }

    public Map<String, String> getPatternDefinitions() {
        return this.grokPatternDefinitions;
    }

    public void register(String name, String pattern) {
        name = Objects.requireNonNull(name).trim();
        pattern = Objects.requireNonNull(pattern).trim();
        if (!name.isEmpty() && !pattern.isEmpty()) {
            this.grokPatternDefinitions.put(name, pattern);
        }
    }

    public void register(Map<String, String> patternDefinitions) {
        Objects.requireNonNull(patternDefinitions);
        patternDefinitions.forEach(this::register);
    }

    public void register(InputStream input) throws IOException {
        this.register(input, StandardCharsets.UTF_8);
    }

    public void register(InputStream input, Charset charset) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(input, charset));){
            in.lines().map(patternLinePattern::matcher).filter(Matcher::matches).forEach(m -> this.register(m.group(1), m.group(2)));
        }
    }

    public void register(Reader input) throws IOException {
        new BufferedReader(input).lines().map(patternLinePattern::matcher).filter(Matcher::matches).forEach(m -> this.register(m.group(1), m.group(2)));
    }

    public void registerDefaultPatterns() {
        this.registerPatternFromClasspath("/patterns/patterns");
    }

    public void registerPatternFromClasspath(String path) throws GrokException {
        this.registerPatternFromClasspath(path, StandardCharsets.UTF_8);
    }

    public void registerPatternFromClasspath(String path, Charset charset) throws GrokException {
        InputStream inputStream = this.getClass().getResourceAsStream(path);
        try (InputStreamReader reader = new InputStreamReader(inputStream, charset);){
            this.register(reader);
        }
        catch (IOException e) {
            throw new GrokException(e.getMessage(), e);
        }
    }

    public Grok compile(String pattern) throws IllegalArgumentException {
        return this.compile(pattern, false);
    }

    public Grok compile(String pattern, boolean namedOnly) throws IllegalArgumentException {
        return this.compile(pattern, ZoneOffset.systemDefault(), namedOnly);
    }

    public Grok compile(String pattern, ZoneId defaultTimeZone, boolean namedOnly) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)pattern)) {
            throw new IllegalArgumentException("{pattern} should not be empty or null");
        }
        String namedRegex = pattern;
        int index = 0;
        int iterationLeft = 1000;
        Boolean continueIteration = true;
        HashMap<String, String> patternDefinitions = new HashMap<String, String>(this.grokPatternDefinitions);
        HashMap<String, String> namedRegexCollection = new HashMap<String, String>();
        while (continueIteration.booleanValue()) {
            continueIteration = false;
            if (iterationLeft <= 0) {
                throw new IllegalArgumentException("Deep recursion pattern compilation of " + pattern);
            }
            --iterationLeft;
            Set<String> namedGroups = GrokUtils.getNameGroups(GrokUtils.GROK_PATTERN.pattern());
            Matcher matcher = GrokUtils.GROK_PATTERN.matcher(namedRegex);
            if (!matcher.find()) continue;
            continueIteration = true;
            Map<String, String> group = GrokUtils.namedGroups(matcher, namedGroups);
            if (group.get("definition") != null) {
                patternDefinitions.put(group.get("pattern"), group.get("definition"));
                group.put("name", group.get("name") + "=" + group.get("definition"));
            }
            int count = StringUtils.countMatches((CharSequence)namedRegex, (CharSequence)("%{" + group.get("name") + "}"));
            for (int i = 0; i < count; ++i) {
                String definitionOfPattern = (String)patternDefinitions.get(group.get("pattern"));
                if (definitionOfPattern == null) {
                    throw new IllegalArgumentException(String.format("No definition for key '%s' found, aborting", group.get("pattern")));
                }
                String replacement = String.format(Locale.ROOT, "(?<name%d>%s)", index, definitionOfPattern);
                if (namedOnly && group.get("subname") == null) {
                    replacement = String.format(Locale.ROOT, "(?:%s)", definitionOfPattern);
                }
                namedRegexCollection.put("name" + index, group.get("subname") != null ? group.get("subname") : group.get("name"));
                namedRegex = StringUtils.replace((String)namedRegex, (String)("%{" + group.get("name") + "}"), (String)replacement, (int)1);
                ++index;
            }
        }
        if (namedRegex.isEmpty()) {
            throw new IllegalArgumentException("Pattern not found");
        }
        return new Grok(pattern, namedRegex, namedRegexCollection, patternDefinitions, defaultTimeZone);
    }
}

