/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.DrbgParameters;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomParameters;
import java.security.SecureRandomSpi;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.fips.DRBG;
import org.bouncycastle.crypto.util.EntropyUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class FipsSecureRandom
extends SecureRandom {
    private final SecureRandom randomSource;
    private final String algorithmName;
    private final DRBG drbg;
    private final boolean predictionResistant;

    FipsSecureRandom(SecureRandom randomSource, String algorithmName, DRBG drbg, EntropySource entropySource, boolean predictionResistant) {
        super(new Random11Spi(randomSource, drbg, entropySource, predictionResistant), new RandomProvider());
        this.randomSource = randomSource;
        this.algorithmName = algorithmName;
        this.drbg = drbg;
        this.predictionResistant = predictionResistant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSeed(long seed) {
        if (this.drbg != null) {
            DRBG dRBG = this.drbg;
            synchronized (dRBG) {
                this.randomSource.setSeed(seed);
            }
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithmName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextBytes(byte[] bytes, byte[] additionalInput) {
        DRBG dRBG = this.drbg;
        synchronized (dRBG) {
            if (this.drbg.generate(bytes, additionalInput, this.predictionResistant) < 0) {
                this.drbg.reseed(null);
                this.drbg.generate(bytes, additionalInput, this.predictionResistant);
            }
        }
    }

    public int getBlockSize() {
        return this.drbg.getBlockSize();
    }

    public boolean isPredictionResistant() {
        return this.predictionResistant;
    }

    public byte[] getPersonalizationString() {
        return this.drbg.getPersonalizationString();
    }

    public int getSecurityStrength() {
        return this.drbg.getSecurityStrength();
    }

    @Override
    public void reseed() {
        this.drbg.reseed(null);
    }

    public void reseed(byte[] additionalInput) {
        this.drbg.reseed(additionalInput);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class RandomProvider
    extends Provider {
        RandomProvider() {
            super("BCFIPS_RNG", 1.0, "BCFIPS Secure Random Provider");
        }
    }

    private static class Random11Spi
    extends SecureRandomSpi {
        private final SecureRandom randomSource;
        private final DRBG drbg;
        private final EntropySource entropySource;
        private final boolean predictionResistant;

        Random11Spi(SecureRandom randomSource, DRBG drbg, EntropySource entropySource, boolean predictionResistant) {
            this.randomSource = randomSource;
            this.drbg = drbg;
            this.entropySource = entropySource;
            this.predictionResistant = predictionResistant;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineSetSeed(byte[] seed) {
            DRBG dRBG = this.drbg;
            synchronized (dRBG) {
                if (this.randomSource != null) {
                    this.randomSource.setSeed(seed);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineNextBytes(byte[] bytes, SecureRandomParameters params) {
            DRBG dRBG = this.drbg;
            synchronized (dRBG) {
                if (params instanceof DrbgParameters.NextBytes) {
                    DrbgParameters.NextBytes p = (DrbgParameters.NextBytes)params;
                    if (p.getStrength() > this.drbg.getSecurityStrength()) {
                        throw new IllegalArgumentException("maximum strength of DRBG is " + this.drbg.getSecurityStrength() + " bits");
                    }
                    if (p.getPredictionResistance() && !this.predictionResistant) {
                        throw new IllegalArgumentException("prediction resistance not available");
                    }
                    if (bytes == null) {
                        throw new NullPointerException("bytes cannot be null");
                    }
                    if (bytes.length != 0 && this.drbg.generate(bytes, p.getAdditionalInput(), this.predictionResistant) < 0) {
                        this.drbg.reseed(null);
                        this.drbg.generate(bytes, p.getAdditionalInput(), this.predictionResistant);
                    }
                } else {
                    throw new IllegalArgumentException("unrecognized DrbgParameters: " + params.getClass());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineNextBytes(byte[] bytes) {
            DRBG dRBG = this.drbg;
            synchronized (dRBG) {
                if (bytes == null) {
                    throw new NullPointerException("bytes cannot be null");
                }
                if (bytes.length != 0 && this.drbg.generate(bytes, null, this.predictionResistant) < 0) {
                    this.drbg.reseed(null);
                    this.drbg.generate(bytes, null, this.predictionResistant);
                }
            }
        }

        @Override
        protected byte[] engineGenerateSeed(int numBytes) {
            return EntropyUtil.generateSeed(this.entropySource, numBytes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void engineReseed(SecureRandomParameters params) {
            DRBG dRBG = this.drbg;
            synchronized (dRBG) {
                if (params instanceof DrbgParameters.Reseed) {
                    DrbgParameters.Reseed p = (DrbgParameters.Reseed)params;
                    if (p.getPredictionResistance() && !this.predictionResistant) {
                        throw new IllegalArgumentException("prediction resistance not available");
                    }
                    this.drbg.reseed(p.getAdditionalInput());
                } else {
                    if (params != null) {
                        throw new IllegalArgumentException("unrecognized DrbgParameters: " + params.getClass());
                    }
                    this.drbg.reseed(null);
                }
            }
        }

        @Override
        protected SecureRandomParameters engineGetParameters() {
            return DrbgParameters.instantiation(this.drbg.getSecurityStrength(), this.predictionResistant ? DrbgParameters.Capability.PR_AND_RESEED : DrbgParameters.Capability.RESEED_ONLY, this.drbg.getPersonalizationString());
        }
    }
}

