/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.model;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.model.CiphertextHeaders;
import com.amazonaws.encryptionsdk.model.KeyBlob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DecryptionMaterialsRequest {
    private final CryptoAlgorithm algorithm;
    private final Map<String, String> encryptionContext;
    private final Map<String, String> reproducedEncryptionContext;
    private final List<KeyBlob> encryptedDataKeys;

    private DecryptionMaterialsRequest(Builder b) {
        this.algorithm = b.getAlgorithm();
        this.encryptionContext = b.getEncryptionContext();
        this.reproducedEncryptionContext = b.getReproducedEncryptionContext();
        this.encryptedDataKeys = b.getEncryptedDataKeys();
    }

    public CryptoAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext;
    }

    public Map<String, String> getReproducedEncryptionContext() {
        return this.reproducedEncryptionContext;
    }

    public List<KeyBlob> getEncryptedDataKeys() {
        return this.encryptedDataKeys;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DecryptionMaterialsRequest fromCiphertextHeaders(CiphertextHeaders headers) {
        return DecryptionMaterialsRequest.newBuilder().setAlgorithm(headers.getCryptoAlgoId()).setEncryptionContext(headers.getEncryptionContextMap()).setEncryptedDataKeys(headers.getEncryptedKeyBlobs()).build();
    }

    public static final class Builder {
        private CryptoAlgorithm algorithm;
        private Map<String, String> encryptionContext;
        private Map<String, String> reproducedEncryptionContext;
        private List<KeyBlob> encryptedDataKeys;

        private Builder(DecryptionMaterialsRequest request) {
            this.algorithm = request.getAlgorithm();
            this.encryptionContext = request.getEncryptionContext();
            this.reproducedEncryptionContext = request.getReproducedEncryptionContext();
            this.encryptedDataKeys = request.getEncryptedDataKeys();
        }

        private Builder() {
        }

        public DecryptionMaterialsRequest build() {
            return new DecryptionMaterialsRequest(this);
        }

        public CryptoAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        public Builder setAlgorithm(CryptoAlgorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Map<String, String> getEncryptionContext() {
            return this.encryptionContext;
        }

        public Builder setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = Collections.unmodifiableMap(new HashMap<String, String>(encryptionContext));
            return this;
        }

        public Map<String, String> getReproducedEncryptionContext() {
            return this.reproducedEncryptionContext;
        }

        public Builder setReproducedEncryptionContext(Map<String, String> reproducedEncryptionContext) {
            this.reproducedEncryptionContext = Collections.unmodifiableMap(new HashMap<String, String>(reproducedEncryptionContext));
            return this;
        }

        public List<KeyBlob> getEncryptedDataKeys() {
            return this.encryptedDataKeys;
        }

        public Builder setEncryptedDataKeys(List<KeyBlob> encryptedDataKeys) {
            this.encryptedDataKeys = Collections.unmodifiableList(new ArrayList<KeyBlob>(encryptedDataKeys));
            return this;
        }
    }
}

