/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.jce;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.UnsupportedProviderException;
import com.amazonaws.encryptionsdk.internal.JceKeyCipher;
import com.amazonaws.encryptionsdk.internal.Utils;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JceMasterKey
extends MasterKey<JceMasterKey> {
    private final String providerName_;
    private final String keyId_;
    private final byte[] keyIdBytes_;
    private final JceKeyCipher jceKeyCipher_;

    public static JceMasterKey getInstance(SecretKey key, String provider, String keyId, String wrappingAlgorithm) {
        switch (wrappingAlgorithm.toUpperCase(Locale.ROOT)) {
            case "AES/GCM/NOPADDING": {
                return new JceMasterKey(provider, keyId, JceKeyCipher.aesGcm(key));
            }
        }
        throw new IllegalArgumentException("Right now only AES/GCM/NoPadding is supported");
    }

    public static JceMasterKey getInstance(PublicKey wrappingKey, PrivateKey unwrappingKey, String provider, String keyId, String wrappingAlgorithm) {
        if (wrappingAlgorithm.toUpperCase(Locale.ROOT).startsWith("RSA/ECB/")) {
            return new JceMasterKey(provider, keyId, JceKeyCipher.rsa(wrappingKey, unwrappingKey, wrappingAlgorithm));
        }
        throw new UnsupportedOperationException("Currently only RSA asymmetric algorithms are supported");
    }

    protected JceMasterKey(String providerName, String keyId, JceKeyCipher jceKeyCipher) {
        this.providerName_ = providerName;
        this.keyId_ = keyId;
        this.keyIdBytes_ = this.keyId_.getBytes(StandardCharsets.UTF_8);
        this.jceKeyCipher_ = jceKeyCipher;
    }

    @Override
    public String getProviderId() {
        return this.providerName_;
    }

    @Override
    public String getKeyId() {
        return this.keyId_;
    }

    @Override
    public DataKey<JceMasterKey> generateDataKey(CryptoAlgorithm algorithm, Map<String, String> encryptionContext) {
        byte[] rawKey = new byte[algorithm.getDataKeyLength()];
        Utils.getSecureRandom().nextBytes(rawKey);
        EncryptedDataKey encryptedDataKey = this.jceKeyCipher_.encryptKey(rawKey, this.keyId_, this.providerName_, encryptionContext);
        return new DataKey<JceMasterKey>(new SecretKeySpec(rawKey, algorithm.getDataKeyAlgo()), encryptedDataKey.getEncryptedDataKey(), encryptedDataKey.getProviderInformation(), this);
    }

    @Override
    public DataKey<JceMasterKey> encryptDataKey(CryptoAlgorithm algorithm, Map<String, String> encryptionContext, DataKey<?> dataKey) {
        SecretKey key = dataKey.getKey();
        if (!key.getFormat().equals("RAW")) {
            throw new IllegalArgumentException("Can only re-encrypt data keys which are in RAW format, not " + dataKey.getKey().getFormat());
        }
        if (!key.getAlgorithm().equalsIgnoreCase(algorithm.getDataKeyAlgo())) {
            throw new IllegalArgumentException("Incorrect key algorithm. Expected " + key.getAlgorithm() + " but got " + algorithm.getKeyAlgo());
        }
        EncryptedDataKey encryptedDataKey = this.jceKeyCipher_.encryptKey(key.getEncoded(), this.keyId_, this.providerName_, encryptionContext);
        return new DataKey<JceMasterKey>(key, encryptedDataKey.getEncryptedDataKey(), encryptedDataKey.getProviderInformation(), this);
    }

    @Override
    public DataKey<JceMasterKey> decryptDataKey(CryptoAlgorithm algorithm, Collection<? extends EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext) throws UnsupportedProviderException, AwsCryptoException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (EncryptedDataKey encryptedDataKey : encryptedDataKeys) {
            try {
                byte[] decryptedKey;
                if (!encryptedDataKey.getProviderId().equals(this.getProviderId()) || !Utils.arrayPrefixEquals(encryptedDataKey.getProviderInformation(), this.keyIdBytes_, this.keyIdBytes_.length) || (decryptedKey = this.jceKeyCipher_.decryptKey(encryptedDataKey, this.keyId_, encryptionContext)).length != algorithm.getDataKeyLength()) continue;
                return new DataKey<JceMasterKey>(new SecretKeySpec(decryptedKey, algorithm.getDataKeyAlgo()), encryptedDataKey.getEncryptedDataKey(), encryptedDataKey.getProviderInformation(), this);
            }
            catch (Exception ex) {
                exceptions.add(ex);
            }
        }
        throw this.buildCannotDecryptDksException(exceptions);
    }
}

