/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.ubi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.ubi.QuerySampler;
import org.opensearch.transport.client.Client;

public class TopNQuerySampler
extends QuerySampler {
    public static final String NAME = "topn";
    private static final Logger LOGGER = LogManager.getLogger(TopNQuerySampler.class);
    private static final String AGGREGATION_NAME = "By_User_Query";

    public TopNQuerySampler(int size, Client client) {
        super(size, client);
    }

    @Override
    public CompletableFuture<Map<String, Integer>> sample() {
        final CompletableFuture<Map<String, Integer>> future = new CompletableFuture<Map<String, Integer>>();
        try {
            SearchRequest searchRequest = this.buildSearchRequest();
            this.getClient().search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse searchResponse) {
                    try {
                        Map<String, Integer> querySet = TopNQuerySampler.this.processSearchResponse(searchResponse);
                        if (querySet.isEmpty()) {
                            LOGGER.warn("No queries found in the search response");
                        }
                        future.complete(querySet);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error processing search response: {}", (Object)e.getMessage(), (Object)e);
                        future.complete(new HashMap());
                    }
                }

                public void onFailure(Exception e) {
                    LOGGER.error("Search request failed: {}", (Object)e.getMessage(), (Object)e);
                    future.complete(new HashMap());
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error creating search request: {}", (Object)e.getMessage(), (Object)e);
            future.complete(new HashMap());
        }
        return future;
    }

    private SearchRequest buildSearchRequest() {
        TermsAggregationBuilder userQueryAggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)AGGREGATION_NAME).field("user_query")).size(this.getSize());
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"user_query")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"user_query", (String)""));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQuery).aggregation((AggregationBuilder)userQueryAggregation).size(0);
        return new SearchRequest(new String[]{"ubi_queries"}).source(searchSourceBuilder);
    }

    private Map<String, Integer> processSearchResponse(SearchResponse searchResponse) {
        HashMap<String, Integer> querySet = new HashMap<String, Integer>();
        Terms byUserQuery = (Terms)searchResponse.getAggregations().get(AGGREGATION_NAME);
        List buckets = byUserQuery.getBuckets();
        for (Terms.Bucket bucket : buckets) {
            String query = bucket.getKeyAsString();
            long count = bucket.getDocCount();
            if (query == null || query.trim().isEmpty()) continue;
            LOGGER.debug("Adding query to set: {} (count: {})", (Object)query, (Object)count);
            querySet.put(query, Math.toIntExact(count));
        }
        LOGGER.info("Created query set with {} queries", (Object)querySet.size());
        return querySet;
    }
}

