/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.ubi;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.opensearch.index.query.functionscore.RandomScoreFunctionBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.collapse.CollapseBuilder;
import org.opensearch.searchrelevance.ubi.QuerySampler;
import org.opensearch.transport.client.Client;

public class RandomQuerySampler
extends QuerySampler {
    public static final String NAME = "random";
    private static final Logger LOGGER = LogManager.getLogger(RandomQuerySampler.class);
    private static final int SEARCH_TIMEOUT_SECONDS = 30;

    public RandomQuerySampler(int size, Client client) {
        super(size, client);
    }

    @Override
    public CompletableFuture<Map<String, Integer>> sample() {
        final CompletableFuture<Map<String, Integer>> future = new CompletableFuture<Map<String, Integer>>();
        SearchRequest searchRequest = this.buildSearchRequest();
        this.getClient().search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                ((CompletableFuture)RandomQuerySampler.this.getQuerySet(searchResponse).thenAccept(result -> {
                    if (result.isEmpty()) {
                        LOGGER.warn("No queries found in the search response");
                    }
                    future.complete(result);
                })).exceptionally(ex -> {
                    LOGGER.error("Error processing query set: {}", (Object)ex.getMessage(), ex);
                    future.complete(new HashMap());
                    return null;
                });
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Error executing search request: {}", (Object)ex.getMessage(), (Object)ex);
                future.complete(new HashMap());
            }
        });
        return future;
    }

    private SearchRequest buildSearchRequest() {
        RandomScoreFunctionBuilder randomScoreFunction = ScoreFunctionBuilders.randomFunction();
        FunctionScoreQueryBuilder functionScoreQueryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FunctionScoreQueryBuilder.FilterFunctionBuilder[])new FunctionScoreQueryBuilder.FilterFunctionBuilder[]{new FunctionScoreQueryBuilder.FilterFunctionBuilder((ScoreFunctionBuilder)randomScoreFunction)});
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"user_query")).must((QueryBuilder)functionScoreQueryBuilder).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"user_query", (String)""));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).collapse(new CollapseBuilder("user_query")).size(this.getSize());
        return new SearchRequest(new String[]{"ubi_queries"}).source(searchSourceBuilder);
    }

    private CompletableFuture<Map<String, Integer>> getQuerySet(SearchResponse searchResponse) {
        HashMap querySet = new HashMap();
        CompletableFuture[] futures = new CompletableFuture[searchResponse.getHits().getHits().length];
        int i = 0;
        for (SearchHit hit : searchResponse.getHits().getHits()) {
            String userQuery = (String)hit.getSourceAsMap().get("user_query");
            futures[i++] = this.getUserQueryCount(userQuery).thenAccept(count -> {
                LOGGER.info("Adding user query to query set: {} with frequency {}", (Object)userQuery, count);
                querySet.put(userQuery, Math.toIntExact(count));
            });
        }
        return CompletableFuture.allOf(futures).thenApply(v -> querySet);
    }

    private CompletableFuture<Long> getUserQueryCount(final String userQuery) {
        final CompletableFuture future = new CompletableFuture();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"user_query", (String)userQuery)).size(0).trackTotalHits(true);
        SearchRequest searchRequest = new SearchRequest(new String[]{"ubi_queries"}).source(searchSourceBuilder);
        this.getClient().search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                future.complete(searchResponse.getHits().getTotalHits().value());
            }

            public void onFailure(Exception ex) {
                LOGGER.error("Error getting user query count for {}: {}", (Object)userQuery, (Object)ex.getMessage(), (Object)ex);
                future.complete(0L);
            }
        });
        return future.orTimeout(30L, TimeUnit.SECONDS).exceptionally(ex -> {
            LOGGER.error("Operation timed out or failed for query {}: {}", (Object)userQuery, (Object)ex.getMessage(), ex);
            return 0L;
        });
    }
}

