/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.judgment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.searchrelevance.dao.JudgmentDao;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.judgments.BaseJudgmentsProcessor;
import org.opensearch.searchrelevance.judgments.JudgmentsProcessorFactory;
import org.opensearch.searchrelevance.model.AsyncStatus;
import org.opensearch.searchrelevance.model.Judgment;
import org.opensearch.searchrelevance.transport.judgment.PutImportJudgmentRequest;
import org.opensearch.searchrelevance.transport.judgment.PutJudgmentRequest;
import org.opensearch.searchrelevance.transport.judgment.PutLlmJudgmentRequest;
import org.opensearch.searchrelevance.transport.judgment.PutUbiJudgmentRequest;
import org.opensearch.searchrelevance.ubi.UbiValidator;
import org.opensearch.searchrelevance.utils.TimeUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class PutJudgmentTransportAction
extends HandledTransportAction<PutJudgmentRequest, IndexResponse> {
    private final ClusterService clusterService;
    private final JudgmentDao judgmentDao;
    private final JudgmentsProcessorFactory judgmentsProcessorFactory;
    private static final Logger LOGGER = LogManager.getLogger(PutJudgmentTransportAction.class);

    @Inject
    public PutJudgmentTransportAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, JudgmentDao judgmentDao, JudgmentsProcessorFactory judgmentsProcessorFactory) {
        super("cluster:admin/opensearch/search_relevance/judgment/create", transportService, actionFilters, PutUbiJudgmentRequest::new);
        this.clusterService = clusterService;
        this.judgmentDao = judgmentDao;
        this.judgmentsProcessorFactory = judgmentsProcessorFactory;
    }

    protected void doExecute(Task task, PutJudgmentRequest request, ActionListener<IndexResponse> listener) {
        if (request == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Request cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            String id = UUID.randomUUID().toString();
            Judgment initialJudgment = new Judgment(id, TimeUtils.getTimestamp(), request.getName(), AsyncStatus.PROCESSING, request.getType(), this.buildMetadata(request), new ArrayList<Map<String, Object>>());
            this.judgmentDao.putJudgement(initialJudgment, ActionListener.wrap(response -> {
                listener.onResponse((Object)((IndexResponse)response));
                this.triggerAsyncProcessing(id, request, initialJudgment.getMetadata());
            }, e -> {
                LOGGER.error("Failed to create initial judgment", (Throwable)e);
                listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to create initial judgment", (Throwable)e, RestStatus.INTERNAL_SERVER_ERROR)));
            }));
        }
        catch (Exception e2) {
            LOGGER.error("Failed to process judgment request", (Throwable)e2);
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to process judgment request", e2, RestStatus.INTERNAL_SERVER_ERROR)));
        }
    }

    private Map<String, Object> buildMetadata(PutJudgmentRequest request) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        switch (request.getType()) {
            case LLM_JUDGMENT: {
                PutLlmJudgmentRequest llmRequest = (PutLlmJudgmentRequest)request;
                metadata.put("modelId", llmRequest.getModelId());
                metadata.put("querySetId", llmRequest.getQuerySetId());
                metadata.put("size", llmRequest.getSize());
                metadata.put("searchConfigurationList", llmRequest.getSearchConfigurationList());
                metadata.put("tokenLimit", llmRequest.getTokenLimit());
                metadata.put("contextFields", llmRequest.getContextFields());
                metadata.put("ignoreFailure", llmRequest.isIgnoreFailure());
                break;
            }
            case UBI_JUDGMENT: {
                if (!UbiValidator.checkUbiIndicesExist(this.clusterService)) {
                    throw new SearchRelevanceException("UBI is not initialized", RestStatus.CONFLICT);
                }
                PutUbiJudgmentRequest ubiRequest = (PutUbiJudgmentRequest)request;
                metadata.put("clickModel", ubiRequest.getClickModel());
                metadata.put("maxRank", ubiRequest.getMaxRank());
                break;
            }
            case IMPORT_JUDGMENT: {
                PutImportJudgmentRequest importRequest = (PutImportJudgmentRequest)request;
                metadata.put("judgmentRatings", importRequest.getJudgmentRatings());
            }
        }
        return metadata;
    }

    private void triggerAsyncProcessing(String judgmentId, PutJudgmentRequest request, Map<String, Object> metadata) {
        LOGGER.info("Starting async processing for judgment: {}, type: {}, metadata: {}", (Object)judgmentId, (Object)request.getType(), metadata);
        BaseJudgmentsProcessor processor = this.judgmentsProcessorFactory.getProcessor(request.getType());
        processor.generateJudgmentRating(metadata, (ActionListener<List<Map<String, Object>>>)ActionListener.wrap(judgmentRatings -> {
            LOGGER.info("Generated judgment ratings for {}, ratings size: {}", (Object)judgmentId, (Object)(judgmentRatings != null ? judgmentRatings.size() : 0));
            this.updateFinalJudgment(judgmentId, request, metadata, (List<Map<String, Object>>)judgmentRatings);
        }, error -> this.handleAsyncFailure(judgmentId, request, "Failed to generate judgment ratings", (Exception)error)));
    }

    private void updateFinalJudgment(String judgmentId, PutJudgmentRequest request, Map<String, Object> metadata, List<Map<String, Object>> judgmentScores) {
        Judgment finalJudgment = new Judgment(judgmentId, TimeUtils.getTimestamp(), request.getName(), AsyncStatus.COMPLETED, request.getType(), metadata, judgmentScores);
        this.judgmentDao.updateJudgment(finalJudgment, ActionListener.wrap(response -> LOGGER.debug("Updated final judgment: {}", (Object)judgmentId), error -> this.handleAsyncFailure(judgmentId, request, "Failed to update final judgment", (Exception)error)));
    }

    private void handleAsyncFailure(String judgmentId, PutJudgmentRequest request, String message, Exception error) {
        LOGGER.error(message + " for judgment: " + judgmentId, (Throwable)error);
        Judgment errorJudgment = new Judgment(judgmentId, TimeUtils.getTimestamp(), request.getName(), AsyncStatus.ERROR, request.getType(), Map.of("error", error.getMessage()), new ArrayList<Map<String, Object>>());
        this.judgmentDao.updateJudgment(errorJudgment, ActionListener.wrap(response -> LOGGER.info("Updated judgment {} status to ERROR", (Object)judgmentId), e -> LOGGER.error("Failed to update error status for judgment: " + judgmentId, (Throwable)e)));
    }
}

