/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.searchrelevance.model.QueryWithReference;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.transport.queryset.PutQuerySetAction;
import org.opensearch.searchrelevance.transport.queryset.PutQuerySetRequest;
import org.opensearch.searchrelevance.utils.TextValidationUtil;
import org.opensearch.transport.client.node.NodeClient;

public class RestPutQuerySetAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(RestPutQuerySetAction.class);
    private static final String PUT_QUERYSET_ACTION = "put_queryset_action";
    private SearchRelevanceSettingsAccessor settingsAccessor;

    public String getName() {
        return PUT_QUERYSET_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_search_relevance/query_sets"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        List<QueryWithReference> querySetQueries;
        TextValidationUtil.ValidationResult descriptionValidation;
        if (!this.settingsAccessor.isWorkbenchEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Search Relevance Workbench is disabled"));
        }
        XContentParser parser = request.contentParser();
        Map source = parser.map();
        String name = (String)source.get("name");
        TextValidationUtil.ValidationResult nameValidation = TextValidationUtil.validateText(name);
        if (!nameValidation.isValid()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Invalid name: " + nameValidation.getErrorMessage()));
        }
        String description = (String)source.get("description");
        if (description != null && !(descriptionValidation = TextValidationUtil.validateText(description)).isValid()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Invalid description: " + descriptionValidation.getErrorMessage()));
        }
        String sampling = source.getOrDefault("sampling", "manual");
        if (sampling.equals("manual")) {
            List rawQueries = (List)source.get("querySetQueries");
            if (rawQueries.size() > this.settingsAccessor.getMaxQuerySetAllowed()) {
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Query Set Limit Exceeded."));
            }
            querySetQueries = rawQueries.stream().map(obj -> {
                Map queryMap = (Map)obj;
                return new QueryWithReference((String)queryMap.get("queryText"), queryMap.getOrDefault("referenceAnswer", ""));
            }).collect(Collectors.toList());
        } else {
            querySetQueries = Collections.emptyList();
        }
        PutQuerySetRequest putRequest = new PutQuerySetRequest(name, description, sampling, querySetQueries);
        return channel -> client.execute((ActionType)PutQuerySetAction.INSTANCE, (ActionRequest)putRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse response) {
                try {
                    XContentBuilder builder = channel.newBuilder();
                    builder.startObject();
                    builder.field("query_set_id", response.getId());
                    builder.field("query_set_result", (Object)response.getResult());
                    builder.endObject();
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.INTERNAL_SERVER_ERROR, e));
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to send error response", (Throwable)ex);
                }
            }
        });
    }

    @Generated
    public RestPutQuerySetAction(SearchRelevanceSettingsAccessor settingsAccessor) {
        this.settingsAccessor = settingsAccessor;
    }
}

