/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.plugin;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ClusterPlugin;
import org.opensearch.plugins.ExtensiblePlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.searchrelevance.dao.EvaluationResultDao;
import org.opensearch.searchrelevance.dao.ExperimentDao;
import org.opensearch.searchrelevance.dao.ExperimentVariantDao;
import org.opensearch.searchrelevance.dao.JudgmentCacheDao;
import org.opensearch.searchrelevance.dao.JudgmentDao;
import org.opensearch.searchrelevance.dao.QuerySetDao;
import org.opensearch.searchrelevance.dao.SearchConfigurationDao;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndicesManager;
import org.opensearch.searchrelevance.metrics.MetricsHelper;
import org.opensearch.searchrelevance.ml.MLAccessor;
import org.opensearch.searchrelevance.rest.RestCreateQuerySetAction;
import org.opensearch.searchrelevance.rest.RestDeleteExperimentAction;
import org.opensearch.searchrelevance.rest.RestDeleteJudgmentAction;
import org.opensearch.searchrelevance.rest.RestDeleteQuerySetAction;
import org.opensearch.searchrelevance.rest.RestDeleteSearchConfigurationAction;
import org.opensearch.searchrelevance.rest.RestGetExperimentAction;
import org.opensearch.searchrelevance.rest.RestGetJudgmentAction;
import org.opensearch.searchrelevance.rest.RestGetQuerySetAction;
import org.opensearch.searchrelevance.rest.RestGetSearchConfigurationAction;
import org.opensearch.searchrelevance.rest.RestPutExperimentAction;
import org.opensearch.searchrelevance.rest.RestPutJudgmentAction;
import org.opensearch.searchrelevance.rest.RestPutQuerySetAction;
import org.opensearch.searchrelevance.rest.RestPutSearchConfigurationAction;
import org.opensearch.searchrelevance.rest.RestSearchRelevanceStatsAction;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettings;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.stats.events.EventStatsManager;
import org.opensearch.searchrelevance.stats.info.InfoStatsManager;
import org.opensearch.searchrelevance.transport.experiment.DeleteExperimentAction;
import org.opensearch.searchrelevance.transport.experiment.DeleteExperimentTransportAction;
import org.opensearch.searchrelevance.transport.experiment.GetExperimentAction;
import org.opensearch.searchrelevance.transport.experiment.GetExperimentTransportAction;
import org.opensearch.searchrelevance.transport.experiment.PutExperimentAction;
import org.opensearch.searchrelevance.transport.experiment.PutExperimentTransportAction;
import org.opensearch.searchrelevance.transport.judgment.DeleteJudgmentAction;
import org.opensearch.searchrelevance.transport.judgment.DeleteJudgmentTransportAction;
import org.opensearch.searchrelevance.transport.judgment.GetJudgmentAction;
import org.opensearch.searchrelevance.transport.judgment.GetJudgmentTransportAction;
import org.opensearch.searchrelevance.transport.judgment.PutJudgmentAction;
import org.opensearch.searchrelevance.transport.judgment.PutJudgmentTransportAction;
import org.opensearch.searchrelevance.transport.queryset.DeleteQuerySetAction;
import org.opensearch.searchrelevance.transport.queryset.DeleteQuerySetTransportAction;
import org.opensearch.searchrelevance.transport.queryset.GetQuerySetAction;
import org.opensearch.searchrelevance.transport.queryset.GetQuerySetTransportAction;
import org.opensearch.searchrelevance.transport.queryset.PostQuerySetAction;
import org.opensearch.searchrelevance.transport.queryset.PostQuerySetTransportAction;
import org.opensearch.searchrelevance.transport.queryset.PutQuerySetAction;
import org.opensearch.searchrelevance.transport.queryset.PutQuerySetTransportAction;
import org.opensearch.searchrelevance.transport.searchConfiguration.DeleteSearchConfigurationAction;
import org.opensearch.searchrelevance.transport.searchConfiguration.DeleteSearchConfigurationTransportAction;
import org.opensearch.searchrelevance.transport.searchConfiguration.GetSearchConfigurationAction;
import org.opensearch.searchrelevance.transport.searchConfiguration.GetSearchConfigurationTransportAction;
import org.opensearch.searchrelevance.transport.searchConfiguration.PutSearchConfigurationAction;
import org.opensearch.searchrelevance.transport.searchConfiguration.PutSearchConfigurationTransportAction;
import org.opensearch.searchrelevance.transport.stats.SearchRelevanceStatsAction;
import org.opensearch.searchrelevance.transport.stats.SearchRelevanceStatsTransportAction;
import org.opensearch.searchrelevance.utils.ClusterUtil;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.watcher.ResourceWatcherService;

public class SearchRelevancePlugin
extends Plugin
implements ActionPlugin,
SystemIndexPlugin,
ClusterPlugin,
ExtensiblePlugin {
    private Client client;
    private ClusterService clusterService;
    private SearchRelevanceIndicesManager searchRelevanceIndicesManager;
    private QuerySetDao querySetDao;
    private SearchConfigurationDao searchConfigurationDao;
    private ExperimentDao experimentDao;
    private ExperimentVariantDao experimentVariantDao;
    private JudgmentDao judgmentDao;
    private EvaluationResultDao evaluationResultDao;
    private JudgmentCacheDao judgmentCacheDao;
    private MLAccessor mlAccessor;
    private MetricsHelper metricsHelper;
    private SearchRelevanceSettingsAccessor settingsAccessor;
    private ClusterUtil clusterUtil;
    private InfoStatsManager infoStatsManager;

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return List.of(new SystemIndexDescriptor(".plugins-search-relevance-experiment", "System index used for experiment data"), new SystemIndexDescriptor(".plugins-search-relevance-judgment-cache", "System index used for judgment cache data"));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.client = client;
        this.clusterService = clusterService;
        this.searchRelevanceIndicesManager = new SearchRelevanceIndicesManager(clusterService, client);
        this.experimentDao = new ExperimentDao(this.searchRelevanceIndicesManager);
        this.experimentVariantDao = new ExperimentVariantDao(this.searchRelevanceIndicesManager);
        this.querySetDao = new QuerySetDao(this.searchRelevanceIndicesManager);
        this.searchConfigurationDao = new SearchConfigurationDao(this.searchRelevanceIndicesManager);
        this.judgmentDao = new JudgmentDao(this.searchRelevanceIndicesManager);
        this.evaluationResultDao = new EvaluationResultDao(this.searchRelevanceIndicesManager);
        this.judgmentCacheDao = new JudgmentCacheDao(this.searchRelevanceIndicesManager);
        MachineLearningNodeClient mlClient = new MachineLearningNodeClient(client);
        this.mlAccessor = new MLAccessor(mlClient);
        this.metricsHelper = new MetricsHelper(clusterService, client, this.judgmentDao, this.evaluationResultDao, this.experimentVariantDao);
        this.settingsAccessor = new SearchRelevanceSettingsAccessor(clusterService, environment.settings());
        this.clusterUtil = new ClusterUtil(clusterService);
        this.infoStatsManager = new InfoStatsManager(this.settingsAccessor);
        EventStatsManager.instance().initialize(this.settingsAccessor);
        return List.of(this.searchRelevanceIndicesManager, this.querySetDao, this.searchConfigurationDao, this.experimentDao, this.experimentVariantDao, this.judgmentDao, this.evaluationResultDao, this.judgmentCacheDao, this.mlAccessor, this.metricsHelper, this.infoStatsManager);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of(new RestHandler[]{new RestCreateQuerySetAction(this.settingsAccessor), new RestPutQuerySetAction(this.settingsAccessor), new RestDeleteQuerySetAction(this.settingsAccessor), new RestGetQuerySetAction(this.settingsAccessor), new RestPutJudgmentAction(this.settingsAccessor), new RestDeleteJudgmentAction(this.settingsAccessor), new RestGetJudgmentAction(this.settingsAccessor), new RestPutSearchConfigurationAction(this.settingsAccessor), new RestDeleteSearchConfigurationAction(this.settingsAccessor), new RestGetSearchConfigurationAction(this.settingsAccessor), new RestPutExperimentAction(this.settingsAccessor), new RestGetExperimentAction(this.settingsAccessor), new RestDeleteExperimentAction(this.settingsAccessor), new RestSearchRelevanceStatsAction(this.settingsAccessor, this.clusterUtil)});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)PostQuerySetAction.INSTANCE, PostQuerySetTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutQuerySetAction.INSTANCE, PutQuerySetTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteQuerySetAction.INSTANCE, DeleteQuerySetTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetQuerySetAction.INSTANCE, GetQuerySetTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutJudgmentAction.INSTANCE, PutJudgmentTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteJudgmentAction.INSTANCE, DeleteJudgmentTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetJudgmentAction.INSTANCE, GetJudgmentTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutSearchConfigurationAction.INSTANCE, PutSearchConfigurationTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteSearchConfigurationAction.INSTANCE, DeleteSearchConfigurationTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetSearchConfigurationAction.INSTANCE, GetSearchConfigurationTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutExperimentAction.INSTANCE, PutExperimentTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteExperimentAction.INSTANCE, DeleteExperimentTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetExperimentAction.INSTANCE, GetExperimentTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchRelevanceStatsAction.INSTANCE, SearchRelevanceStatsTransportAction.class, new Class[0]));
    }

    public List<Setting<?>> getSettings() {
        return List.of(SearchRelevanceSettings.SEARCH_RELEVANCE_WORKBENCH_ENABLED, SearchRelevanceSettings.SEARCH_RELEVANCE_STATS_ENABLED, SearchRelevanceSettings.SEARCH_RELEVANCE_QUERY_SET_MAX_LIMIT);
    }
}

