/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.judgments;

import org.opensearch.common.inject.Inject;
import org.opensearch.searchrelevance.dao.JudgmentCacheDao;
import org.opensearch.searchrelevance.dao.QuerySetDao;
import org.opensearch.searchrelevance.dao.SearchConfigurationDao;
import org.opensearch.searchrelevance.judgments.BaseJudgmentsProcessor;
import org.opensearch.searchrelevance.judgments.ImportJudgmentsProcessor;
import org.opensearch.searchrelevance.judgments.LlmJudgmentsProcessor;
import org.opensearch.searchrelevance.judgments.UbiJudgmentsProcessor;
import org.opensearch.searchrelevance.ml.MLAccessor;
import org.opensearch.searchrelevance.model.JudgmentType;
import org.opensearch.transport.client.Client;

public class JudgmentsProcessorFactory {
    private final MLAccessor mlAccessor;
    private final QuerySetDao querySetDao;
    private final SearchConfigurationDao searchConfigurationDao;
    private final JudgmentCacheDao judgmentCacheDao;
    private final Client client;

    @Inject
    public JudgmentsProcessorFactory(MLAccessor mlAccessor, QuerySetDao querySetDao, SearchConfigurationDao searchConfigurationDao, JudgmentCacheDao judgmentCacheDao, Client client) {
        this.mlAccessor = mlAccessor;
        this.querySetDao = querySetDao;
        this.searchConfigurationDao = searchConfigurationDao;
        this.judgmentCacheDao = judgmentCacheDao;
        this.client = client;
    }

    public BaseJudgmentsProcessor getProcessor(JudgmentType type) {
        return switch (type) {
            case JudgmentType.LLM_JUDGMENT -> new LlmJudgmentsProcessor(this.mlAccessor, this.querySetDao, this.searchConfigurationDao, this.judgmentCacheDao, this.client);
            case JudgmentType.UBI_JUDGMENT -> new UbiJudgmentsProcessor(this.client);
            case JudgmentType.IMPORT_JUDGMENT -> new ImportJudgmentsProcessor(this.client);
            default -> throw new IllegalArgumentException("Unsupported judgment type: " + String.valueOf((Object)type));
        };
    }
}

