/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.dao;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.StepListener;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndices;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndicesManager;
import org.opensearch.searchrelevance.model.SearchConfiguration;

public class SearchConfigurationDao {
    private static final Logger LOGGER = LogManager.getLogger(SearchConfigurationDao.class);
    private final SearchRelevanceIndicesManager searchRelevanceIndicesManager;

    @Inject
    public SearchConfigurationDao(SearchRelevanceIndicesManager searchRelevanceIndicesManager) {
        this.searchRelevanceIndicesManager = searchRelevanceIndicesManager;
    }

    public void createIndexIfAbsent(StepListener<Void> stepListener) {
        this.searchRelevanceIndicesManager.createIndexIfAbsent(SearchRelevanceIndices.SEARCH_CONFIGURATION, stepListener);
    }

    public void putSearchConfiguration(SearchConfiguration searchConfiguration, ActionListener listener) {
        if (searchConfiguration == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("SearchConfiguration cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.putDoc(searchConfiguration.id(), searchConfiguration.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.SEARCH_CONFIGURATION, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store searchConfiguration", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void deleteSearchConfiguration(String searchConfigurationId, ActionListener<DeleteResponse> listener) {
        this.searchRelevanceIndicesManager.deleteDocByDocId(searchConfigurationId, SearchRelevanceIndices.SEARCH_CONFIGURATION, listener);
    }

    public SearchResponse getSearchConfiguration(String searchConfigurationId, ActionListener<SearchResponse> listener) {
        if (searchConfigurationId == null || searchConfigurationId.isEmpty()) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("searchConfigurationId must not be null or empty", RestStatus.BAD_REQUEST)));
            return null;
        }
        return this.searchRelevanceIndicesManager.getDocByDocId(searchConfigurationId, SearchRelevanceIndices.SEARCH_CONFIGURATION, listener);
    }

    public SearchConfiguration getSearchConfigurationSync(String searchConfigurationId) {
        if (searchConfigurationId == null || searchConfigurationId.isEmpty()) {
            throw new SearchRelevanceException("searchConfigurationId must not be null or empty", RestStatus.BAD_REQUEST);
        }
        SearchResponse response = this.searchRelevanceIndicesManager.getDocByDocIdSync(searchConfigurationId, SearchRelevanceIndices.SEARCH_CONFIGURATION);
        return this.convertToSearchConfiguration(response);
    }

    public SearchResponse listSearchConfiguration(SearchSourceBuilder sourceBuilder, ActionListener<SearchResponse> listener) {
        if (sourceBuilder == null) {
            sourceBuilder = new SearchSourceBuilder();
        }
        if (sourceBuilder.query() == null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        return this.searchRelevanceIndicesManager.listDocsBySearchRequest(sourceBuilder, SearchRelevanceIndices.SEARCH_CONFIGURATION, listener);
    }

    public void getSearchConfigsWithStepListener(List<String> searchConfigurationList, Map<String, Object> results, ActionListener<Map<String, Object>> stepListener) {
        final HashMap indexAndQueries = new HashMap();
        final GroupedActionListener groupedListener = new GroupedActionListener(ActionListener.wrap(responses -> {
            results.put("indexAndQueries", indexAndQueries);
            stepListener.onResponse((Object)results);
        }, arg_0 -> stepListener.onFailure(arg_0)), searchConfigurationList.size());
        for (final String searchConfigurationId : searchConfigurationList) {
            this.getSearchConfiguration(searchConfigurationId, new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    try {
                        LOGGER.info("Successfully get response for searchConfigurationId [{}]: [{}]", (Object)searchConfigurationId, (Object)response);
                        SearchConfiguration searchConfig = SearchConfigurationDao.this.convertToSearchConfiguration(response);
                        LOGGER.debug("Converted response into SearchConfiguration: [{}]", (Object)searchConfig);
                        indexAndQueries.put(searchConfigurationId, Arrays.asList(searchConfig.index(), searchConfig.query(), searchConfig.searchPipeline()));
                        groupedListener.onResponse((Object)response);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to convert response: [{}] into SearchConfiguration for id: [{}]", (Object)response, (Object)searchConfigurationId, (Object)e);
                        groupedListener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to convert SearchConfiguration", e, RestStatus.INTERNAL_SERVER_ERROR)));
                    }
                }

                public void onFailure(Exception e) {
                    LOGGER.error("Failed to retrieve SearchConfiguration for id: [{}]", (Object)searchConfigurationId, (Object)e);
                    groupedListener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to retrieve SearchConfiguration", e, RestStatus.INTERNAL_SERVER_ERROR)));
                }
            });
        }
    }

    private SearchConfiguration convertToSearchConfiguration(SearchResponse response) {
        Map source = response.getHits().getHits()[0].getSourceAsMap();
        return new SearchConfiguration((String)source.get("id"), (String)source.get("name"), (String)source.get("timestamp"), (String)source.get("index"), (String)source.get("query"), (String)source.get("searchPipeline"));
    }
}

