/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.dao;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.StepListener;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndices;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndicesManager;
import org.opensearch.searchrelevance.model.EvaluationResult;

public class EvaluationResultDao {
    private static final Logger LOGGER = LogManager.getLogger(EvaluationResultDao.class);
    private final SearchRelevanceIndicesManager searchRelevanceIndicesManager;

    public EvaluationResultDao(SearchRelevanceIndicesManager searchRelevanceIndicesManager) {
        this.searchRelevanceIndicesManager = searchRelevanceIndicesManager;
    }

    public void createIndexIfAbsent(StepListener<Void> stepListener) {
        this.searchRelevanceIndicesManager.createIndexIfAbsent(SearchRelevanceIndices.EVALUATION_RESULT, stepListener);
    }

    public void putEvaluationResult(EvaluationResult evaluationResult, ActionListener listener) {
        if (evaluationResult == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("EvaluationResult cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.putDoc(evaluationResult.id(), evaluationResult.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.EVALUATION_RESULT, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store evaluationResult", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void deleteEvaluationResult(String evaluationResultId, ActionListener<DeleteResponse> listener) {
        this.searchRelevanceIndicesManager.deleteDocByDocId(evaluationResultId, SearchRelevanceIndices.EVALUATION_RESULT, listener);
    }

    public SearchResponse getEvaluationResult(String evaluationResultId, ActionListener<SearchResponse> listener) {
        if (evaluationResultId == null || evaluationResultId.isEmpty()) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("evaluationResultId must not be null or empty", RestStatus.BAD_REQUEST)));
            return null;
        }
        return this.searchRelevanceIndicesManager.getDocByDocId(evaluationResultId, SearchRelevanceIndices.EVALUATION_RESULT, listener);
    }

    public SearchResponse listExperiment(SearchSourceBuilder sourceBuilder, ActionListener<SearchResponse> listener) {
        if (sourceBuilder == null) {
            sourceBuilder = new SearchSourceBuilder();
        }
        if (sourceBuilder.query() == null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        return this.searchRelevanceIndicesManager.listDocsBySearchRequest(sourceBuilder, SearchRelevanceIndices.EVALUATION_RESULT, listener);
    }
}

