/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.ActionType;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.AlertingPluginInterface;
import org.opensearch.commons.alerting.action.DeleteMonitorResponse;
import org.opensearch.commons.alerting.action.DeleteWorkflowResponse;
import org.opensearch.commons.alerting.action.IndexMonitorRequest;
import org.opensearch.commons.alerting.action.IndexMonitorResponse;
import org.opensearch.commons.alerting.action.IndexWorkflowResponse;
import org.opensearch.commons.alerting.model.BucketLevelTrigger;
import org.opensearch.commons.alerting.model.DataSources;
import org.opensearch.commons.alerting.model.DocLevelMonitorInput;
import org.opensearch.commons.alerting.model.DocLevelQuery;
import org.opensearch.commons.alerting.model.DocumentLevelTrigger;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.SearchInput;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.commons.alerting.model.action.Action;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.rest.RestRequest;
import org.opensearch.script.Script;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.action.GetIndexMappingsAction;
import org.opensearch.securityanalytics.action.GetIndexMappingsRequest;
import org.opensearch.securityanalytics.action.GetIndexMappingsResponse;
import org.opensearch.securityanalytics.action.IndexDetectorRequest;
import org.opensearch.securityanalytics.action.IndexDetectorResponse;
import org.opensearch.securityanalytics.config.monitors.DetectorMonitorConfig;
import org.opensearch.securityanalytics.logtype.LogTypeService;
import org.opensearch.securityanalytics.mapper.MapperService;
import org.opensearch.securityanalytics.mapper.MapperUtils;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.model.DetectorInput;
import org.opensearch.securityanalytics.model.DetectorRule;
import org.opensearch.securityanalytics.model.DetectorTrigger;
import org.opensearch.securityanalytics.model.LogType;
import org.opensearch.securityanalytics.model.Rule;
import org.opensearch.securityanalytics.model.Value;
import org.opensearch.securityanalytics.rules.aggregation.AggregationItem;
import org.opensearch.securityanalytics.rules.backend.OSQueryBackend;
import org.opensearch.securityanalytics.rules.backend.QueryBackend;
import org.opensearch.securityanalytics.rules.exceptions.SigmaConditionError;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.threatIntel.service.DetectorThreatIntelService;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.DetectorIndices;
import org.opensearch.securityanalytics.util.ExceptionChecker;
import org.opensearch.securityanalytics.util.IndexUtils;
import org.opensearch.securityanalytics.util.MonitorService;
import org.opensearch.securityanalytics.util.RuleIndices;
import org.opensearch.securityanalytics.util.RuleTopicIndices;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.securityanalytics.util.ThrowableCheckingPredicates;
import org.opensearch.securityanalytics.util.WorkflowService;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.node.NodeClient;

public class TransportIndexDetectorAction
extends HandledTransportAction<IndexDetectorRequest, IndexDetectorResponse>
implements SecureTransportAction {
    public static final String PLUGIN_OWNER_FIELD = "security_analytics";
    private static final Logger log = LogManager.getLogger(TransportIndexDetectorAction.class);
    public static final String TIMESTAMP_FIELD_ALIAS = "timestamp";
    public static final String CHAINED_FINDINGS_MONITOR_STRING = "chained_findings_monitor";
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final DetectorIndices detectorIndices;
    private final RuleTopicIndices ruleTopicIndices;
    private final RuleIndices ruleIndices;
    private final MapperService mapperService;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final LogTypeService logTypeService;
    private volatile Boolean filterByEnabled;
    private volatile Boolean enabledWorkflowUsage;
    private volatile Boolean enableDetectorWithDedicatedQueryIndices;
    private final Settings settings;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final WorkflowService workflowService;
    private final MonitorService monitorService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final DetectorThreatIntelService detectorThreatIntelService;
    private final ExceptionChecker exceptionChecker;
    private final TimeValue indexTimeout;

    @Inject
    public TransportIndexDetectorAction(TransportService transportService, Client client, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry, DetectorIndices detectorIndices, RuleTopicIndices ruleTopicIndices, RuleIndices ruleIndices, MapperService mapperService, ClusterService clusterService, Settings settings, NamedWriteableRegistry namedWriteableRegistry, LogTypeService logTypeService, IndexNameExpressionResolver indexNameExpressionResolver, DetectorThreatIntelService detectorThreatIntelService, ExceptionChecker exceptionChecker) {
        super("cluster:admin/opensearch/securityanalytics/detector/write", transportService, actionFilters, IndexDetectorRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.detectorIndices = detectorIndices;
        this.ruleTopicIndices = ruleTopicIndices;
        this.ruleIndices = ruleIndices;
        this.mapperService = mapperService;
        this.clusterService = clusterService;
        this.settings = settings;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.logTypeService = logTypeService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.detectorThreatIntelService = detectorThreatIntelService;
        this.threadPool = this.detectorIndices.getThreadPool();
        this.indexTimeout = (TimeValue)SecurityAnalyticsSettings.INDEX_TIMEOUT.get(this.settings);
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
        this.enabledWorkflowUsage = (Boolean)SecurityAnalyticsSettings.ENABLE_WORKFLOW_USAGE.get(this.settings);
        this.enableDetectorWithDedicatedQueryIndices = (Boolean)SecurityAnalyticsSettings.ENABLE_DETECTORS_WITH_DEDICATED_QUERY_INDICES.get(this.settings);
        this.monitorService = new MonitorService(client);
        this.workflowService = new WorkflowService(client, this.monitorService);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, this::setFilterByEnabled);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.ENABLE_WORKFLOW_USAGE, this::setEnabledWorkflowUsage);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.ENABLE_DETECTORS_WITH_DEDICATED_QUERY_INDICES, this::setEnabledDetectorsWithDedicatedQueryIndices);
        this.exceptionChecker = exceptionChecker;
    }

    protected void doExecute(Task task, IndexDetectorRequest request, ActionListener<IndexDetectorResponse> listener) {
        User user = this.readUserFromThreadContext(this.threadPool);
        String validateBackendRoleMessage = this.validateUserBackendRoles(user, this.filterByEnabled);
        if (!"".equals(validateBackendRoleMessage)) {
            listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(validateBackendRoleMessage, RestStatus.FORBIDDEN, new Object[0]))));
            return;
        }
        this.checkIndicesAndExecute(task, request, listener, user);
    }

    private void checkIndicesAndExecute(final Task task, final IndexDetectorRequest request, final ActionListener<IndexDetectorResponse> listener, final User user) {
        log.debug("check indices and execute began");
        final String[] detectorIndices = (String[])request.getDetector().getInputs().stream().flatMap(detectorInput -> detectorInput.getIndices().stream()).toArray(String[]::new);
        SearchRequest searchRequest = new SearchRequest(detectorIndices).source(SearchSourceBuilder.searchSource().size(1).query((QueryBuilder)QueryBuilders.matchAllQuery()));
        searchRequest.setCancelAfterTimeInterval(TimeValue.timeValueSeconds((long)30L));
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                log.debug("check indices and execute completed. Took {} millis", (Object)searchResponse.getTook().millis());
                AsyncIndexDetectorsAction asyncAction = new AsyncIndexDetectorsAction(user, task, request, (ActionListener<IndexDetectorResponse>)listener);
                asyncAction.start();
            }

            public void onFailure(Exception e) {
                log.debug("check indices and execute failed", (Throwable)e);
                if (e instanceof OpenSearchStatusException) {
                    listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(String.format(Locale.getDefault(), "User doesn't have read permissions for one or more configured index %s", new Object[]{detectorIndices}), RestStatus.FORBIDDEN, new Object[0]))));
                } else if (e instanceof IndexNotFoundException) {
                    listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(String.format(Locale.getDefault(), "Indices not found %s", String.join((CharSequence)", ", detectorIndices)), RestStatus.NOT_FOUND, new Object[0]))));
                } else {
                    listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap(e)));
                }
            }
        });
    }

    private void createMonitorFromQueries(final List<Pair<String, Rule>> rulesById, final Detector detector, final ActionListener<List<IndexMonitorResponse>> listener, final WriteRequest.RefreshPolicy refreshPolicy, final List<String> queryFieldNames) {
        final List docLevelRules = rulesById.stream().filter(it -> !((Rule)it.getRight()).isAggregationRule()).collect(Collectors.toList());
        final List bucketLevelRules = rulesById.stream().filter(it -> ((Rule)it.getRight()).isAggregationRule()).collect(Collectors.toList());
        this.addThreatIntelBasedDocLevelQueries(detector, new ActionListener<List<DocLevelQuery>>(){

            public void onResponse(List<DocLevelQuery> dlqs) {
                try {
                    ArrayList<IndexMonitorRequest> monitorRequests = new ArrayList<IndexMonitorRequest>();
                    if (!docLevelRules.isEmpty() || detector.getThreatIntelEnabled().booleanValue()) {
                        monitorRequests.add(TransportIndexDetectorAction.this.createDocLevelMonitorRequest(docLevelRules, dlqs != null ? dlqs : List.of(), detector, refreshPolicy, "", RestRequest.Method.POST, queryFieldNames));
                    }
                    if (!bucketLevelRules.isEmpty()) {
                        StepListener bucketLevelMonitorRequests = new StepListener();
                        TransportIndexDetectorAction.this.buildBucketLevelMonitorRequests(bucketLevelRules, detector, refreshPolicy, "", RestRequest.Method.POST, (ActionListener<List<IndexMonitorRequest>>)bucketLevelMonitorRequests);
                        bucketLevelMonitorRequests.whenComplete(indexMonitorRequests -> {
                            log.debug("bucket level monitor request built");
                            monitorRequests.addAll((Collection<IndexMonitorRequest>)indexMonitorRequests);
                            if (monitorRequests.isEmpty()) {
                                listener.onResponse(Collections.emptyList());
                                return;
                            }
                            ArrayList monitorResponses = new ArrayList();
                            StepListener addFirstMonitorStep = new StepListener();
                            AlertingPluginInterface.INSTANCE.indexMonitor((NodeClient)TransportIndexDetectorAction.this.client, (IndexMonitorRequest)monitorRequests.get(0), TransportIndexDetectorAction.this.namedWriteableRegistry, (ActionListener)addFirstMonitorStep);
                            addFirstMonitorStep.whenComplete(addedFirstMonitorResponse -> {
                                log.debug("first monitor created id {} of type {}", (Object)addedFirstMonitorResponse.getId(), (Object)addedFirstMonitorResponse.getMonitor().getMonitorType());
                                monitorResponses.add(addedFirstMonitorResponse);
                                StepListener indexMonitorsStep = new StepListener();
                                indexMonitorsStep.whenComplete(indexMonitorResponses -> TransportIndexDetectorAction.this.saveWorkflow(rulesById, detector, (List<IndexMonitorResponse>)indexMonitorResponses, refreshPolicy, (ActionListener<List<IndexMonitorResponse>>)listener), e -> {
                                    log.error("Failed to index the workflow", (Throwable)e);
                                    listener.onFailure(e);
                                });
                                int numberOfUnprocessedResponses = monitorRequests.size() - 1;
                                if (numberOfUnprocessedResponses == 0) {
                                    TransportIndexDetectorAction.this.saveWorkflow(rulesById, detector, monitorResponses, refreshPolicy, (ActionListener<List<IndexMonitorResponse>>)listener);
                                } else {
                                    TransportIndexDetectorAction.this.saveMonitors(monitorRequests, monitorResponses, numberOfUnprocessedResponses, (ActionListener<List<IndexMonitorResponse>>)indexMonitorsStep);
                                }
                            }, e1 -> {
                                log.error("Failed to index doc level monitor in detector creation", (Throwable)e1);
                                listener.onFailure(e1);
                            });
                        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                    } else {
                        if (monitorRequests.isEmpty()) {
                            listener.onFailure((Exception)new OpenSearchStatusException("Detector cannot be created as no compatible rules were provided", RestStatus.BAD_REQUEST, new Object[0]));
                            return;
                        }
                        ArrayList monitorResponses = new ArrayList();
                        StepListener indexDocLevelMonitorStep = new StepListener();
                        AlertingPluginInterface.INSTANCE.indexMonitor((NodeClient)TransportIndexDetectorAction.this.client, (IndexMonitorRequest)monitorRequests.get(0), TransportIndexDetectorAction.this.namedWriteableRegistry, (ActionListener)indexDocLevelMonitorStep);
                        indexDocLevelMonitorStep.whenComplete(addedFirstMonitorResponse -> {
                            monitorResponses.add(addedFirstMonitorResponse);
                            TransportIndexDetectorAction.this.saveWorkflow(rulesById, detector, monitorResponses, refreshPolicy, (ActionListener<List<IndexMonitorResponse>>)listener);
                        }, e -> listener.onFailure(e));
                    }
                }
                catch (Exception ex) {
                    this.onFailure(ex);
                }
            }

            public void onFailure(Exception e) {
                log.error("Failed to convert threat intel feed to. Proceeding with detector creation", (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    private void saveMonitors(List<IndexMonitorRequest> monitorRequests, final List<IndexMonitorResponse> monitorResponses, int numberOfUnprocessedResponses, final ActionListener<List<IndexMonitorResponse>> listener) {
        GroupedActionListener monitorResponseListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<IndexMonitorResponse>>(){

            public void onResponse(Collection<IndexMonitorResponse> indexMonitorResponses) {
                monitorResponses.addAll(indexMonitorResponses.stream().collect(Collectors.toList()));
                listener.onResponse((Object)monitorResponses);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, numberOfUnprocessedResponses);
        for (int i = 1; i < monitorRequests.size(); ++i) {
            AlertingPluginInterface.INSTANCE.indexMonitor((NodeClient)this.client, monitorRequests.get(i), this.namedWriteableRegistry, (ActionListener)monitorResponseListener);
        }
    }

    private void saveWorkflow(List<Pair<String, Rule>> rulesById, final Detector detector, final List<IndexMonitorResponse> monitorResponses, WriteRequest.RefreshPolicy refreshPolicy, final ActionListener<List<IndexMonitorResponse>> actionListener) {
        if (this.enabledWorkflowUsage.booleanValue()) {
            this.workflowService.upsertWorkflow(rulesById, monitorResponses, null, detector, refreshPolicy, "", RestRequest.Method.POST, new ActionListener<IndexWorkflowResponse>(this){

                public void onResponse(IndexWorkflowResponse workflowResponse) {
                    detector.setWorkflowIds(List.of(workflowResponse.getId()));
                    actionListener.onResponse((Object)monitorResponses);
                }

                public void onFailure(Exception e) {
                    log.error("Error saving workflow", (Throwable)e);
                    actionListener.onFailure(e);
                }
            });
        } else {
            actionListener.onResponse(monitorResponses);
        }
    }

    private void updateMonitorFromQueries(String index, final List<Pair<String, Rule>> rulesById, final Detector detector, final ActionListener<List<IndexMonitorResponse>> listener, final WriteRequest.RefreshPolicy refreshPolicy, final List<String> queryFieldNames) {
        final ArrayList monitorsToBeUpdated = new ArrayList();
        final List bucketLevelRules = rulesById.stream().filter(it -> ((Rule)it.getRight()).isAggregationRule()).collect(Collectors.toList());
        this.addThreatIntelBasedDocLevelQueries(detector, new ActionListener<List<DocLevelQuery>>(){

            public void onResponse(final List<DocLevelQuery> docLevelQueries) {
                final ArrayList<IndexMonitorRequest> monitorsToBeAdded = new ArrayList<IndexMonitorRequest>();
                if (!bucketLevelRules.isEmpty()) {
                    TransportIndexDetectorAction.this.logTypeService.getRuleFieldMappings(new ActionListener<Map<String, Map<String, String>>>(){

                        public void onResponse(Map<String, Map<String, String>> ruleFieldMappings) {
                            try {
                                List ruleCategories = bucketLevelRules.stream().map(Pair::getRight).map(Rule::getCategory).distinct().collect(Collectors.toList());
                                HashMap<String, OSQueryBackend> queryBackendMap = new HashMap<String, OSQueryBackend>();
                                for (String category : ruleCategories) {
                                    Map<String, String> fieldMappings = ruleFieldMappings.get(category);
                                    queryBackendMap.put(category, new OSQueryBackend(fieldMappings, true, true));
                                }
                                Map<String, String> monitorPerRule = detector.getRuleIdMonitorIdMap();
                                final GroupedActionListener groupedActionListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<IndexMonitorRequest>>(){

                                    public void onResponse(Collection<IndexMonitorRequest> indexMonitorRequests) {
                                        if (detector.getRuleIdMonitorIdMap().containsKey(TransportIndexDetectorAction.CHAINED_FINDINGS_MONITOR_STRING)) {
                                            String cmfId = detector.getRuleIdMonitorIdMap().get(TransportIndexDetectorAction.CHAINED_FINDINGS_MONITOR_STRING);
                                            if (TransportIndexDetectorAction.this.shouldAddChainedFindingDocMonitor(indexMonitorRequests.isEmpty(), rulesById)) {
                                                monitorsToBeUpdated.add(TransportIndexDetectorAction.this.createDocLevelMonitorMatchAllRequest(detector, WriteRequest.RefreshPolicy.IMMEDIATE, cmfId, RestRequest.Method.PUT, rulesById));
                                            }
                                        } else if (TransportIndexDetectorAction.this.shouldAddChainedFindingDocMonitor(indexMonitorRequests.isEmpty(), rulesById)) {
                                            monitorsToBeAdded.add(TransportIndexDetectorAction.this.createDocLevelMonitorMatchAllRequest(detector, WriteRequest.RefreshPolicy.IMMEDIATE, detector.getId() + "_chained_findings", RestRequest.Method.POST, rulesById));
                                        }
                                        TransportIndexDetectorAction.this.onIndexMonitorRequestCreation(monitorsToBeUpdated, monitorsToBeAdded, rulesById, detector, refreshPolicy, docLevelQueries, queryFieldNames, (ActionListener<List<IndexMonitorResponse>>)listener);
                                    }

                                    public void onFailure(Exception e) {
                                        listener.onFailure(e);
                                    }
                                }, bucketLevelRules.size());
                                for (Pair query : bucketLevelRules) {
                                    Rule rule = (Rule)query.getRight();
                                    if (rule.getAggregationQueries() == null) continue;
                                    if (monitorPerRule.containsKey(rule.getId())) {
                                        String monitorId = monitorPerRule.get(rule.getId());
                                        TransportIndexDetectorAction.this.createBucketLevelMonitorRequest((Rule)query.getRight(), detector, refreshPolicy, monitorId, RestRequest.Method.PUT, (QueryBackend)queryBackendMap.get(rule.getCategory()), new ActionListener<IndexMonitorRequest>(){

                                            public void onResponse(IndexMonitorRequest indexMonitorRequest) {
                                                monitorsToBeUpdated.add(indexMonitorRequest);
                                                groupedActionListener.onResponse((Object)indexMonitorRequest);
                                            }

                                            public void onFailure(Exception e) {
                                                log.error("Failed to create bucket level monitor request", (Throwable)e);
                                                listener.onFailure(e);
                                            }
                                        });
                                        continue;
                                    }
                                    TransportIndexDetectorAction.this.createBucketLevelMonitorRequest((Rule)query.getRight(), detector, refreshPolicy, "", RestRequest.Method.POST, (QueryBackend)queryBackendMap.get(rule.getCategory()), new ActionListener<IndexMonitorRequest>(){

                                        public void onResponse(IndexMonitorRequest indexMonitorRequest) {
                                            monitorsToBeAdded.add(indexMonitorRequest);
                                            groupedActionListener.onResponse((Object)indexMonitorRequest);
                                        }

                                        public void onFailure(Exception e) {
                                            log.error("Failed to create bucket level monitor request", (Throwable)e);
                                            listener.onFailure(e);
                                        }
                                    });
                                }
                            }
                            catch (Exception ex) {
                                listener.onFailure(ex);
                            }
                        }

                        public void onFailure(Exception e) {
                            listener.onFailure(e);
                        }
                    });
                } else {
                    TransportIndexDetectorAction.this.onIndexMonitorRequestCreation(monitorsToBeUpdated, monitorsToBeAdded, rulesById, detector, refreshPolicy, docLevelQueries, queryFieldNames, (ActionListener<List<IndexMonitorResponse>>)listener);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private boolean shouldAddChainedFindingDocMonitor(boolean bucketLevelMonitorsExist, List<Pair<String, Rule>> rulesById) {
        return this.enabledWorkflowUsage != false && !bucketLevelMonitorsExist && rulesById.stream().anyMatch(it -> ((Rule)it.getRight()).isAggregationRule());
    }

    private void onIndexMonitorRequestCreation(List<IndexMonitorRequest> monitorsToBeUpdated, List<IndexMonitorRequest> monitorsToBeAdded, List<Pair<String, Rule>> rulesById, Detector detector, WriteRequest.RefreshPolicy refreshPolicy, List<DocLevelQuery> docLevelQueries, List<String> queryFieldNames, ActionListener<List<IndexMonitorResponse>> listener) {
        List<Pair<String, Rule>> docLevelRules = rulesById.stream().filter(it -> !((Rule)it.getRight()).isAggregationRule()).collect(Collectors.toList());
        if (!docLevelRules.isEmpty() || detector.getThreatIntelEnabled().booleanValue()) {
            if (detector.getDocLevelMonitorId() == null) {
                monitorsToBeAdded.add(this.createDocLevelMonitorRequest(docLevelRules, docLevelQueries != null ? docLevelQueries : List.of(), detector, refreshPolicy, "", RestRequest.Method.POST, queryFieldNames));
            } else {
                monitorsToBeUpdated.add(this.createDocLevelMonitorRequest(docLevelRules, docLevelQueries != null ? docLevelQueries : List.of(), detector, refreshPolicy, detector.getDocLevelMonitorId(), RestRequest.Method.PUT, queryFieldNames));
            }
        }
        List<String> monitorIdsToBeDeleted = detector.getRuleIdMonitorIdMap().values().stream().collect(Collectors.toList());
        monitorIdsToBeDeleted.removeAll(monitorsToBeUpdated.stream().map(IndexMonitorRequest::getMonitorId).collect(Collectors.toList()));
        this.updateAlertingMonitors(rulesById, detector, monitorsToBeAdded, monitorsToBeUpdated, monitorIdsToBeDeleted, refreshPolicy, listener);
    }

    private void updateAlertingMonitors(List<Pair<String, Rule>> rulesById, Detector detector, List<IndexMonitorRequest> monitorsToBeAdded, List<IndexMonitorRequest> monitorsToBeUpdated, List<String> monitorsToBeDeleted, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<List<IndexMonitorResponse>> listener) {
        ArrayList updatedMonitors = new ArrayList();
        StepListener addNewMonitorsStep = new StepListener();
        this.executeMonitorActionRequest(monitorsToBeAdded, (ActionListener<List<IndexMonitorResponse>>)addNewMonitorsStep);
        addNewMonitorsStep.whenComplete(addNewMonitorsResponse -> {
            if (addNewMonitorsResponse != null && !addNewMonitorsResponse.isEmpty()) {
                updatedMonitors.addAll(addNewMonitorsResponse);
            }
            StepListener updateMonitorsStep = new StepListener();
            this.executeMonitorActionRequest(monitorsToBeUpdated, (ActionListener<List<IndexMonitorResponse>>)updateMonitorsStep);
            updateMonitorsStep.whenComplete(updateMonitorResponse -> {
                if (updateMonitorResponse != null && !updateMonitorResponse.isEmpty()) {
                    updatedMonitors.addAll(updateMonitorResponse);
                }
                if (detector.isWorkflowSupported() && this.enabledWorkflowUsage.booleanValue()) {
                    this.updateWorkflowStep(rulesById, detector, monitorsToBeDeleted, refreshPolicy, listener, updatedMonitors, (List<IndexMonitorResponse>)addNewMonitorsResponse, (List<IndexMonitorResponse>)updateMonitorResponse);
                } else {
                    this.deleteMonitorStep(monitorsToBeDeleted, refreshPolicy, updatedMonitors, listener);
                }
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
        }, arg_0 -> listener.onFailure(arg_0));
    }

    private void deleteMonitorStep(List<String> monitorsToBeDeleted, WriteRequest.RefreshPolicy refreshPolicy, final List<IndexMonitorResponse> updatedMonitors, final ActionListener<List<IndexMonitorResponse>> listener) {
        this.monitorService.deleteAlertingMonitors(monitorsToBeDeleted, refreshPolicy, new ActionListener<List<DeleteMonitorResponse>>(this){

            public void onResponse(List<DeleteMonitorResponse> deleteMonitorResponses) {
                listener.onResponse((Object)updatedMonitors);
            }

            public void onFailure(Exception e) {
                log.error("Failed to delete the monitors", (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    private void updateWorkflowStep(List<Pair<String, Rule>> rulesById, final Detector detector, final List<String> monitorsToBeDeleted, final WriteRequest.RefreshPolicy refreshPolicy, final ActionListener<List<IndexMonitorResponse>> listener, final List<IndexMonitorResponse> updatedMonitors, List<IndexMonitorResponse> addNewMonitorsResponse, List<IndexMonitorResponse> updateMonitorResponse) {
        List addedMonitorIds = addNewMonitorsResponse.stream().map(IndexMonitorResponse::getId).collect(Collectors.toList());
        List updatedMonitorIds = updateMonitorResponse.stream().map(IndexMonitorResponse::getId).collect(Collectors.toList());
        if (addedMonitorIds.isEmpty() && updatedMonitorIds.isEmpty()) {
            this.workflowService.deleteWorkflow(detector.getWorkflowIds().get(0), new ActionListener<DeleteWorkflowResponse>(){

                public void onResponse(DeleteWorkflowResponse deleteWorkflowResponse) {
                    detector.setWorkflowIds(Collections.emptyList());
                    TransportIndexDetectorAction.this.deleteMonitorStep(monitorsToBeDeleted, refreshPolicy, updatedMonitors, (ActionListener<List<IndexMonitorResponse>>)listener);
                }

                public void onFailure(Exception e) {
                    log.error("Failed to delete the workflow", (Throwable)e);
                    listener.onFailure(e);
                }
            });
        } else {
            this.workflowService.upsertWorkflow(rulesById, addNewMonitorsResponse, updateMonitorResponse, detector, refreshPolicy, detector.getWorkflowIds().get(0), RestRequest.Method.PUT, new ActionListener<IndexWorkflowResponse>(){

                public void onResponse(IndexWorkflowResponse workflowResponse) {
                    TransportIndexDetectorAction.this.deleteMonitorStep(monitorsToBeDeleted, refreshPolicy, updatedMonitors, (ActionListener<List<IndexMonitorResponse>>)listener);
                }

                public void onFailure(Exception e) {
                    TransportIndexDetectorAction.this.handleUpsertWorkflowFailure(e, (ActionListener<List<IndexMonitorResponse>>)listener, detector, monitorsToBeDeleted, refreshPolicy, updatedMonitors);
                }
            });
        }
    }

    private IndexMonitorRequest createDocLevelMonitorRequest(List<Pair<String, Rule>> queries, List<DocLevelQuery> threatIntelQueries, Detector detector, WriteRequest.RefreshPolicy refreshPolicy, String monitorId, RestRequest.Method restMethod, List<String> queryFieldNames) {
        ArrayList<DocLevelMonitorInput> docLevelMonitorInputs = new ArrayList<DocLevelMonitorInput>();
        ArrayList<DocLevelQuery> docLevelQueries = new ArrayList<DocLevelQuery>();
        for (Pair<String, Rule> query : queries) {
            String id = (String)query.getLeft();
            Rule rule = (Rule)query.getRight();
            String name = rule.getTitle();
            String actualQuery = rule.getQueries().get(0).getValue();
            ArrayList<String> tags = new ArrayList<String>();
            tags.add(rule.getLevel());
            tags.add(rule.getCategory());
            tags.addAll(rule.getTags().stream().map(Value::getValue).collect(Collectors.toList()));
            DocLevelQuery docLevelQuery = new DocLevelQuery(id, name, Collections.emptyList(), actualQuery, tags, queryFieldNames);
            docLevelQueries.add(docLevelQuery);
        }
        docLevelQueries.addAll(threatIntelQueries);
        DocLevelMonitorInput docLevelMonitorInput = new DocLevelMonitorInput(detector.getName(), detector.getInputs().get(0).getIndices(), docLevelQueries, Boolean.valueOf(true));
        docLevelMonitorInputs.add(docLevelMonitorInput);
        ArrayList<DocumentLevelTrigger> triggers = new ArrayList<DocumentLevelTrigger>();
        List<DetectorTrigger> detectorTriggers = detector.getTriggers();
        for (DetectorTrigger detectorTrigger : detectorTriggers) {
            String id = detectorTrigger.getId();
            String name = detectorTrigger.getName();
            String severity = detectorTrigger.getSeverity();
            List<Action> actions = detectorTrigger.getActions();
            Script condition = detectorTrigger.convertToCondition();
            triggers.add(new DocumentLevelTrigger(id, name, severity, actions, condition));
        }
        Monitor monitor = new Monitor(monitorId, 1L, detector.getName(), false, detector.getSchedule(), detector.getLastUpdateTime(), null, Monitor.MonitorType.DOC_LEVEL_MONITOR.getValue(), detector.getUser(), 1, docLevelMonitorInputs, triggers, Map.of(), new DataSources(detector.getRuleIndex(), detector.getFindingsIndex(), detector.getFindingsIndexPattern(), detector.getAlertsIndex(), detector.getAlertsHistoryIndex(), detector.getAlertsHistoryIndexPattern(), DetectorMonitorConfig.getRuleIndexMappingsByType(), Boolean.valueOf(true)), this.enableDetectorWithDedicatedQueryIndices, null, PLUGIN_OWNER_FIELD);
        return new IndexMonitorRequest(monitorId, -2L, 0L, refreshPolicy, restMethod, monitor, null);
    }

    private void handleUpsertWorkflowFailure(Exception e, ActionListener<List<IndexMonitorResponse>> listener, Detector detector, List<String> monitorsToBeDeleted, WriteRequest.RefreshPolicy refreshPolicy, List<IndexMonitorResponse> updatedMonitors) {
        if (this.exceptionChecker.doesGroupedActionListenerExceptionMatch(e, List.of(ThrowableCheckingPredicates.WORKFLOW_NOT_FOUND))) {
            if (detector.getEnabled().booleanValue()) {
                String errorMessage = String.format("Underlying workflow associated with detector %s not found. Delete and recreate the detector to restore functionality.", detector.getName());
                log.error(errorMessage);
                listener.onFailure((Exception)((Object)new SecurityAnalyticsException(errorMessage, RestStatus.BAD_REQUEST, e)));
            } else {
                log.error("Underlying workflow associated with detector {} not found. Proceeding to disable detector.", (Object)detector.getName());
                this.deleteMonitorStep(monitorsToBeDeleted, refreshPolicy, updatedMonitors, listener);
            }
        } else {
            log.error("Failed to update the workflow");
            listener.onFailure(e);
        }
    }

    private void addThreatIntelBasedDocLevelQueries(Detector detector, ActionListener<List<DocLevelQuery>> listener) {
        try {
            if (detector.getThreatIntelEnabled().booleanValue()) {
                log.debug("threat intel enabled for detector {} . adding threat intel based doc level queries.", (Object)detector.getName());
                List<LogType.IocFields> iocFieldsList = this.logTypeService.getIocFieldsList(detector.getDetectorType());
                if (iocFieldsList == null || iocFieldsList.isEmpty()) {
                    listener.onResponse(List.of());
                } else {
                    this.detectorThreatIntelService.createDocLevelQueryFromThreatIntel(iocFieldsList, detector, listener);
                }
            } else {
                listener.onResponse(List.of());
            }
        }
        catch (Exception e) {
            log.error("Failed to add threat intel based doc level queries");
            listener.onFailure(e);
        }
    }

    private IndexMonitorRequest createDocLevelMonitorMatchAllRequest(Detector detector, WriteRequest.RefreshPolicy refreshPolicy, String monitorId, RestRequest.Method restMethod, List<Pair<String, Rule>> queries) {
        ArrayList<DocLevelMonitorInput> docLevelMonitorInputs = new ArrayList<DocLevelMonitorInput>();
        ArrayList<DocLevelQuery> docLevelQueries = new ArrayList<DocLevelQuery>();
        String monitorName = detector.getName() + "_chained_findings";
        String actualQuery = "_id:*";
        HashSet<String> tags = new HashSet<String>();
        for (Pair<String, Rule> query : queries) {
            if (!((Rule)query.getRight()).isAggregationRule()) continue;
            Rule rule = (Rule)query.getRight();
            tags.add(rule.getLevel());
            tags.add(rule.getId());
            tags.add(rule.getCategory());
            tags.addAll(rule.getTags().stream().map(Value::getValue).collect(Collectors.toList()));
        }
        tags.removeIf(Objects::isNull);
        List<String> queryFieldNames = List.of("_id");
        DocLevelQuery docLevelQuery = new DocLevelQuery(monitorName, monitorName + "doc", Collections.emptyList(), actualQuery, new ArrayList(tags), queryFieldNames);
        docLevelQueries.add(docLevelQuery);
        DocLevelMonitorInput docLevelMonitorInput = new DocLevelMonitorInput(detector.getName(), detector.getInputs().get(0).getIndices(), docLevelQueries, Boolean.valueOf(false));
        docLevelMonitorInputs.add(docLevelMonitorInput);
        ArrayList<DocumentLevelTrigger> triggers = new ArrayList<DocumentLevelTrigger>();
        List<DetectorTrigger> detectorTriggers = detector.getTriggers();
        for (DetectorTrigger detectorTrigger : detectorTriggers) {
            String id = detectorTrigger.getId();
            String name = detectorTrigger.getName();
            String severity = detectorTrigger.getSeverity();
            List<Action> actions = detectorTrigger.getActions();
            Script condition = detectorTrigger.convertToConditionForChainedFindings();
            triggers.add(new DocumentLevelTrigger(id, name, severity, actions, condition));
        }
        Monitor monitor = new Monitor(monitorId, 1L, monitorName, false, detector.getSchedule(), detector.getLastUpdateTime(), null, Monitor.MonitorType.DOC_LEVEL_MONITOR.getValue(), detector.getUser(), 1, docLevelMonitorInputs, triggers, Map.of(), new DataSources((String)(this.enableDetectorWithDedicatedQueryIndices != false ? detector.getRuleIndex() + "_chained_findings" : detector.getRuleIndex()), detector.getFindingsIndex(), detector.getFindingsIndexPattern(), detector.getAlertsIndex(), detector.getAlertsHistoryIndex(), detector.getAlertsHistoryIndexPattern(), DetectorMonitorConfig.getRuleIndexMappingsByType(), Boolean.valueOf(true)), this.enableDetectorWithDedicatedQueryIndices, Boolean.valueOf(true), PLUGIN_OWNER_FIELD);
        return new IndexMonitorRequest(monitorId, -2L, 0L, refreshPolicy, restMethod, monitor, null);
    }

    private void buildBucketLevelMonitorRequests(final List<Pair<String, Rule>> queries, final Detector detector, final WriteRequest.RefreshPolicy refreshPolicy, final String monitorId, final RestRequest.Method restMethod, final ActionListener<List<IndexMonitorRequest>> listener) throws Exception {
        log.debug("bucket level monitor request starting");
        log.debug("get rule field mappings request being made");
        this.logTypeService.getRuleFieldMappings(new ActionListener<Map<String, Map<String, String>>>(){

            public void onResponse(Map<String, Map<String, String>> ruleFieldMappings) {
                log.debug("got rule field mapping success");
                List ruleCategories = queries.stream().map(Pair::getRight).map(Rule::getCategory).distinct().collect(Collectors.toList());
                HashMap<String, OSQueryBackend> queryBackendMap = new HashMap<String, OSQueryBackend>();
                for (String category : ruleCategories) {
                    Map<String, String> fieldMappings = ruleFieldMappings.get(category);
                    try {
                        queryBackendMap.put(category, new OSQueryBackend(fieldMappings, true, true));
                    }
                    catch (IOException e) {
                        TransportIndexDetectorAction.this.logger.error("Failed to create OSQueryBackend from field mappings", (Throwable)e);
                        listener.onFailure((Exception)e);
                    }
                }
                final ArrayList monitorRequests = new ArrayList();
                final GroupedActionListener bucketLevelMonitorRequestsListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<IndexMonitorRequest>>(){

                    public void onResponse(Collection<IndexMonitorRequest> indexMonitorRequests) {
                        if (TransportIndexDetectorAction.this.shouldAddChainedFindingDocMonitor(monitorRequests.isEmpty(), queries)) {
                            monitorRequests.add(TransportIndexDetectorAction.this.createDocLevelMonitorMatchAllRequest(detector, WriteRequest.RefreshPolicy.IMMEDIATE, detector.getId() + "_chained_findings", RestRequest.Method.POST, queries));
                        }
                        listener.onResponse((Object)monitorRequests);
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                }, queries.size());
                for (Pair query : queries) {
                    Rule rule = (Rule)query.getRight();
                    if (rule.getAggregationQueries() != null) {
                        try {
                            TransportIndexDetectorAction.this.createBucketLevelMonitorRequest((Rule)query.getRight(), detector, refreshPolicy, monitorId, restMethod, (QueryBackend)queryBackendMap.get(rule.getCategory()), new ActionListener<IndexMonitorRequest>(){

                                public void onResponse(IndexMonitorRequest indexMonitorRequest) {
                                    monitorRequests.add(indexMonitorRequest);
                                    bucketLevelMonitorRequestsListener.onResponse((Object)indexMonitorRequest);
                                }

                                public void onFailure(Exception e) {
                                    TransportIndexDetectorAction.this.logger.error("Failed to build bucket level monitor requests", (Throwable)e);
                                    bucketLevelMonitorRequestsListener.onFailure(e);
                                }
                            });
                            continue;
                        }
                        catch (SigmaConditionError e) {
                            throw new RuntimeException(e);
                        }
                    }
                    log.debug("Aggregation query is null in rule {}", (Object)rule.getId());
                    bucketLevelMonitorRequestsListener.onResponse(null);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void createBucketLevelMonitorRequest(final Rule rule, final Detector detector, final WriteRequest.RefreshPolicy refreshPolicy, final String monitorId, final RestRequest.Method restMethod, QueryBackend queryBackend, final ActionListener<IndexMonitorRequest> listener) throws SigmaConditionError {
        log.debug(":create bucket level monitor response starting");
        final List<String> indices = detector.getInputs().get(0).getIndices();
        try {
            final AggregationItem aggItem = rule.getAggregationItemsFromRule().get(0);
            final OSQueryBackend.AggregationQueries aggregationQueries = queryBackend.convertAggregation(aggItem);
            final SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true)).query((QueryBuilder)QueryBuilders.queryStringQuery((String)rule.getQueries().get(0).getValue())).aggregation(aggregationQueries.getAggBuilder());
            final String concreteIndex = IndexUtils.getNewIndexByCreationDate(this.clusterService.state(), this.indexNameExpressionResolver, indices.get(0));
            this.client.execute((ActionType)GetIndexMappingsAction.INSTANCE, (ActionRequest)new GetIndexMappingsRequest(concreteIndex), (ActionListener)new ActionListener<GetIndexMappingsResponse>(){

                public void onResponse(GetIndexMappingsResponse getIndexMappingsResponse) {
                    MappingMetadata mappingMetadata = getIndexMappingsResponse.mappings().get(concreteIndex);
                    List<Pair<String, String>> pairs = null;
                    try {
                        pairs = MapperUtils.getAllAliasPathPairs(mappingMetadata);
                    }
                    catch (IOException e) {
                        TransportIndexDetectorAction.this.logger.debug("Failed to get alias path pairs from mapping metadata", (Throwable)e);
                        this.onFailure(e);
                    }
                    boolean timeStampAliasPresent = pairs.stream().anyMatch(p -> TransportIndexDetectorAction.TIMESTAMP_FIELD_ALIAS.equals(p.getLeft()) || TransportIndexDetectorAction.TIMESTAMP_FIELD_ALIAS.equals(p.getRight()));
                    if (timeStampAliasPresent) {
                        BoolQueryBuilder boolQueryBuilder = searchSourceBuilder.query() == null ? new BoolQueryBuilder() : QueryBuilders.boolQuery().must(searchSourceBuilder.query());
                        RangeQueryBuilder timeRangeFilter = QueryBuilders.rangeQuery((String)TransportIndexDetectorAction.TIMESTAMP_FIELD_ALIAS).gt((Object)("{{period_end}}||-" + (aggItem.getTimeframe() != null ? aggItem.getTimeframe() : "1h"))).lte((Object)"{{period_end}}").format("epoch_millis");
                        boolQueryBuilder.must((QueryBuilder)timeRangeFilter);
                        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
                    }
                    searchSourceBuilder.size(0);
                    ArrayList<SearchInput> bucketLevelMonitorInputs = new ArrayList<SearchInput>();
                    bucketLevelMonitorInputs.add(new SearchInput(indices, searchSourceBuilder));
                    ArrayList<BucketLevelTrigger> triggers = new ArrayList<BucketLevelTrigger>();
                    BucketLevelTrigger bucketLevelTrigger = new BucketLevelTrigger(rule.getId(), rule.getTitle(), rule.getLevel(), aggregationQueries.getCondition(), Collections.emptyList());
                    triggers.add(bucketLevelTrigger);
                    Monitor monitor = new Monitor(monitorId, 1L, detector.getName(), false, detector.getSchedule(), detector.getLastUpdateTime(), null, Monitor.MonitorType.BUCKET_LEVEL_MONITOR.getValue(), detector.getUser(), 1, bucketLevelMonitorInputs, triggers, Map.of(), new DataSources(detector.getRuleIndex(), detector.getFindingsIndex(), detector.getFindingsIndexPattern(), detector.getAlertsIndex(), detector.getAlertsHistoryIndex(), detector.getAlertsHistoryIndexPattern(), DetectorMonitorConfig.getRuleIndexMappingsByType(), Boolean.valueOf(true)), Boolean.valueOf(false), null, TransportIndexDetectorAction.PLUGIN_OWNER_FIELD);
                    listener.onResponse((Object)new IndexMonitorRequest(monitorId, -2L, 0L, refreshPolicy, restMethod, monitor, null));
                }

                public void onFailure(Exception e) {
                    log.error(String.format(Locale.getDefault(), "Unable to verify presence of timestamp alias for index [%s] in detector [%s]. Not setting time range filter for bucket level monitor.", concreteIndex, detector.getName()), (Throwable)e);
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to create bucket level monitor request", (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void executeMonitorActionRequest(List<IndexMonitorRequest> indexMonitors, final ActionListener<List<IndexMonitorResponse>> listener) {
        if (indexMonitors == null || indexMonitors.isEmpty()) {
            listener.onResponse(new ArrayList());
            return;
        }
        GroupedActionListener monitorResponseListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<IndexMonitorResponse>>(){

            public void onResponse(Collection<IndexMonitorResponse> indexMonitorResponse) {
                listener.onResponse(indexMonitorResponse.stream().collect(Collectors.toList()));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, indexMonitors.size());
        for (IndexMonitorRequest req : indexMonitors) {
            AlertingPluginInterface.INSTANCE.indexMonitor((NodeClient)this.client, req, this.namedWriteableRegistry, (ActionListener)monitorResponseListener);
        }
    }

    private void onCreateMappingsResponse(CreateIndexResponse response) throws Exception {
        if (!response.isAcknowledged()) {
            log.error(String.format(Locale.getDefault(), "Create %s mappings call not acknowledged.", ".opensearch-sap-detectors-config"));
            throw new OpenSearchStatusException(String.format(Locale.getDefault(), "Create %s mappings call not acknowledged", ".opensearch-sap-detectors-config"), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        log.info(String.format(Locale.getDefault(), "Created %s with mappings.", ".opensearch-sap-detectors-config"));
        IndexUtils.detectorIndexUpdated();
    }

    private void onUpdateMappingsResponse(AcknowledgedResponse response) {
        if (!response.isAcknowledged()) {
            log.error(String.format(Locale.getDefault(), "Update %s mappings call not acknowledged.", ".opensearch-sap-detectors-config"));
            throw new OpenSearchStatusException(String.format(Locale.getDefault(), "Update %s mappings call not acknowledged.", ".opensearch-sap-detectors-config"), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        log.info(String.format(Locale.getDefault(), "Updated  %s with mappings.", ".opensearch-sap-detectors-config"));
        IndexUtils.detectorIndexUpdated();
    }

    private void setFilterByEnabled(boolean filterByEnabled) {
        this.filterByEnabled = filterByEnabled;
    }

    private void setEnabledWorkflowUsage(boolean enabledWorkflowUsage) {
        this.enabledWorkflowUsage = enabledWorkflowUsage;
    }

    private void setEnabledDetectorsWithDedicatedQueryIndices(boolean enabledDetectorsWithDedicatedQueryIndices) {
        this.enableDetectorWithDedicatedQueryIndices = enabledDetectorsWithDedicatedQueryIndices;
    }

    class AsyncIndexDetectorsAction {
        private final IndexDetectorRequest request;
        private final ActionListener<IndexDetectorResponse> listener;
        private final AtomicReference<Object> response;
        private final AtomicBoolean counter = new AtomicBoolean();
        private final Task task;
        private final User user;

        AsyncIndexDetectorsAction(User user, Task task, IndexDetectorRequest request, ActionListener<IndexDetectorResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.user = user;
            this.response = new AtomicReference();
        }

        void start() {
            log.debug("stash context");
            TransportIndexDetectorAction.this.threadPool.getThreadContext().stashContext();
            log.debug("log type check : {}", (Object)this.request.getDetector().getDetectorType());
            TransportIndexDetectorAction.this.logTypeService.doesLogTypeExist(this.request.getDetector().getDetectorType().toLowerCase(Locale.ROOT), new ActionListener<Boolean>(){

                public void onResponse(Boolean exist) {
                    block6: {
                        if (exist.booleanValue()) {
                            log.debug("log type exists : {}", (Object)AsyncIndexDetectorsAction.this.request.getDetector().getDetectorType());
                            try {
                                if (!TransportIndexDetectorAction.this.detectorIndices.detectorIndexExists()) {
                                    log.debug("detector index creation");
                                    TransportIndexDetectorAction.this.detectorIndices.initDetectorIndex(new ActionListener<CreateIndexResponse>(){

                                        public void onResponse(CreateIndexResponse response) {
                                            try {
                                                log.debug("detector index created in {}");
                                                TransportIndexDetectorAction.this.onCreateMappingsResponse(response);
                                                AsyncIndexDetectorsAction.this.prepareDetectorIndexing();
                                            }
                                            catch (Exception e) {
                                                log.debug("detector index creation failed", (Throwable)e);
                                                AsyncIndexDetectorsAction.this.onFailures(e);
                                            }
                                        }

                                        public void onFailure(Exception e) {
                                            AsyncIndexDetectorsAction.this.onFailures(e);
                                        }
                                    });
                                    break block6;
                                }
                                if (!IndexUtils.detectorIndexUpdated.booleanValue()) {
                                    log.debug("detector index update mapping");
                                    IndexUtils.updateIndexMapping(".opensearch-sap-detectors-config", DetectorIndices.detectorMappings(), TransportIndexDetectorAction.this.clusterService.state(), TransportIndexDetectorAction.this.client.admin().indices(), new ActionListener<AcknowledgedResponse>(){

                                        public void onResponse(AcknowledgedResponse response) {
                                            log.debug("detector index mapping updated");
                                            TransportIndexDetectorAction.this.onUpdateMappingsResponse(response);
                                            try {
                                                AsyncIndexDetectorsAction.this.prepareDetectorIndexing();
                                            }
                                            catch (Exception e) {
                                                log.debug("detector index mapping FAILED updation", (Throwable)e);
                                                AsyncIndexDetectorsAction.this.onFailures(e);
                                            }
                                        }

                                        public void onFailure(Exception e) {
                                            AsyncIndexDetectorsAction.this.onFailures(e);
                                        }
                                    }, false);
                                    break block6;
                                }
                                AsyncIndexDetectorsAction.this.prepareDetectorIndexing();
                            }
                            catch (Exception e) {
                                AsyncIndexDetectorsAction.this.onFailures(e);
                            }
                        } else {
                            AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException(String.format("Detector cannot be created as logtype %s does not exist", AsyncIndexDetectorsAction.this.request.getDetector().getDetectorType().toLowerCase(Locale.ROOT)), RestStatus.BAD_REQUEST, new Object[0]));
                        }
                    }
                }

                public void onFailure(Exception e) {
                }
            });
        }

        void prepareDetectorIndexing() throws Exception {
            if (this.request.getMethod() == RestRequest.Method.POST) {
                this.createDetector();
            } else if (this.request.getMethod() == RestRequest.Method.PUT) {
                this.updateDetector();
            }
        }

        void createDetector() {
            Detector detector = this.request.getDetector();
            String ruleTopic = detector.getDetectorType();
            this.request.getDetector().setAlertsIndex(DetectorMonitorConfig.getAlertsIndex(ruleTopic));
            this.request.getDetector().setAlertsHistoryIndex(DetectorMonitorConfig.getAlertsHistoryIndex(ruleTopic));
            this.request.getDetector().setAlertsHistoryIndexPattern(DetectorMonitorConfig.getAlertsHistoryIndexPattern(ruleTopic));
            this.request.getDetector().setFindingsIndex(DetectorMonitorConfig.getFindingsIndex(ruleTopic));
            this.request.getDetector().setFindingsIndexPattern(DetectorMonitorConfig.getFindingsIndexPattern(ruleTopic));
            if (TransportIndexDetectorAction.this.enableDetectorWithDedicatedQueryIndices.booleanValue()) {
                this.request.getDetector().setRuleIndex(DetectorMonitorConfig.getRuleIndexOptimized(ruleTopic));
            } else {
                this.request.getDetector().setRuleIndex(DetectorMonitorConfig.getRuleIndex(ruleTopic));
            }
            User originalContextUser = this.user;
            log.debug("user from original context is {}", (Object)originalContextUser);
            this.request.getDetector().setUser(originalContextUser);
            if (!detector.getInputs().isEmpty()) {
                try {
                    log.debug("init rule index template");
                    TransportIndexDetectorAction.this.ruleTopicIndices.initRuleTopicIndexTemplate(new ActionListener<AcknowledgedResponse>(){

                        public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                            log.debug("init rule index template ack");
                            AsyncIndexDetectorsAction.this.initRuleIndexAndImportRules(AsyncIndexDetectorsAction.this.request, new ActionListener<List<IndexMonitorResponse>>(){

                                public void onResponse(List<IndexMonitorResponse> monitorResponses) {
                                    log.debug("monitors indexed");
                                    AsyncIndexDetectorsAction.this.request.getDetector().setMonitorIds(AsyncIndexDetectorsAction.this.getMonitorIds(monitorResponses));
                                    AsyncIndexDetectorsAction.this.request.getDetector().setRuleIdMonitorIdMap(AsyncIndexDetectorsAction.this.mapMonitorIds(monitorResponses));
                                    try {
                                        AsyncIndexDetectorsAction.this.indexDetector();
                                    }
                                    catch (Exception e) {
                                        TransportIndexDetectorAction.this.logger.debug("create detector failed", (Throwable)e);
                                        AsyncIndexDetectorsAction.this.onFailures(e);
                                    }
                                }

                                public void onFailure(Exception e) {
                                    TransportIndexDetectorAction.this.logger.debug("import rules failed", (Throwable)e);
                                    AsyncIndexDetectorsAction.this.onFailures(e);
                                }
                            });
                        }

                        public void onFailure(Exception e) {
                            TransportIndexDetectorAction.this.logger.debug("init rules index failed", (Throwable)e);
                            AsyncIndexDetectorsAction.this.onFailures(e);
                        }
                    });
                }
                catch (Exception e) {
                    TransportIndexDetectorAction.this.logger.debug("init rules index failed", (Throwable)e);
                    this.onFailures(e);
                }
            }
        }

        void updateDetector() {
            final String id = this.request.getDetectorId();
            final User originalContextUser = this.user;
            log.debug("user from original context is {}", (Object)originalContextUser);
            GetRequest request = new GetRequest(".opensearch-sap-detectors-config", id);
            TransportIndexDetectorAction.this.client.get(request, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    if (!response.isExists()) {
                        AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException(String.format(Locale.getDefault(), "Detector with %s is not found", id), RestStatus.NOT_FOUND, new Object[0]));
                        return;
                    }
                    try {
                        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)TransportIndexDetectorAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef(), (MediaType)XContentType.JSON);
                        Detector detector = Detector.docParse(xcp, response.getId(), response.getVersion());
                        if (!TransportIndexDetectorAction.this.checkUserPermissionsWithResource(originalContextUser, detector.getUser(), "detector", detector.getId(), TransportIndexDetectorAction.this.filterByEnabled)) {
                            this.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("Do not have permissions to resource", RestStatus.FORBIDDEN, new Object[0]))));
                            return;
                        }
                        AsyncIndexDetectorsAction.this.onGetResponse(detector, detector.getUser());
                    }
                    catch (Exception e) {
                        AsyncIndexDetectorsAction.this.onFailures(e);
                    }
                }

                public void onFailure(Exception e) {
                    AsyncIndexDetectorsAction.this.onFailures(e);
                }
            });
        }

        void onGetResponse(Detector currentDetector, User user) {
            if (this.request.getDetector().getEnabled().booleanValue() && currentDetector.getEnabled().booleanValue()) {
                this.request.getDetector().setEnabledTime(currentDetector.getEnabledTime());
            }
            this.request.getDetector().setMonitorIds(currentDetector.getMonitorIds());
            this.request.getDetector().setRuleIdMonitorIdMap(currentDetector.getRuleIdMonitorIdMap());
            this.request.getDetector().setWorkflowIds(currentDetector.getWorkflowIds());
            Detector detector = this.request.getDetector();
            String ruleTopic = detector.getDetectorType();
            log.debug("user in update detector {}", (Object)user);
            this.request.getDetector().setAlertsIndex(DetectorMonitorConfig.getAlertsIndex(ruleTopic));
            this.request.getDetector().setAlertsHistoryIndex(DetectorMonitorConfig.getAlertsHistoryIndex(ruleTopic));
            this.request.getDetector().setAlertsHistoryIndexPattern(DetectorMonitorConfig.getAlertsHistoryIndexPattern(ruleTopic));
            this.request.getDetector().setFindingsIndex(DetectorMonitorConfig.getFindingsIndex(ruleTopic));
            this.request.getDetector().setFindingsIndexPattern(DetectorMonitorConfig.getFindingsIndexPattern(ruleTopic));
            if (currentDetector.getRuleIndex().contains("optimized")) {
                this.request.getDetector().setRuleIndex(currentDetector.getRuleIndex());
            } else if (TransportIndexDetectorAction.this.enableDetectorWithDedicatedQueryIndices.booleanValue()) {
                this.request.getDetector().setRuleIndex(DetectorMonitorConfig.getRuleIndexOptimized(ruleTopic));
            } else {
                this.request.getDetector().setRuleIndex(DetectorMonitorConfig.getRuleIndex(ruleTopic));
            }
            this.request.getDetector().setUser(user);
            if (!detector.getInputs().isEmpty()) {
                try {
                    TransportIndexDetectorAction.this.ruleTopicIndices.initRuleTopicIndexTemplate(new ActionListener<AcknowledgedResponse>(){

                        public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                            AsyncIndexDetectorsAction.this.initRuleIndexAndImportRules(AsyncIndexDetectorsAction.this.request, new ActionListener<List<IndexMonitorResponse>>(){

                                public void onResponse(List<IndexMonitorResponse> monitorResponses) {
                                    AsyncIndexDetectorsAction.this.request.getDetector().setMonitorIds(AsyncIndexDetectorsAction.this.getMonitorIds(monitorResponses));
                                    AsyncIndexDetectorsAction.this.request.getDetector().setRuleIdMonitorIdMap(AsyncIndexDetectorsAction.this.mapMonitorIds(monitorResponses));
                                    try {
                                        AsyncIndexDetectorsAction.this.indexDetector();
                                    }
                                    catch (Exception e) {
                                        AsyncIndexDetectorsAction.this.onFailures(e);
                                    }
                                }

                                public void onFailure(Exception e) {
                                    AsyncIndexDetectorsAction.this.onFailures(e);
                                }
                            });
                        }

                        public void onFailure(Exception e) {
                            AsyncIndexDetectorsAction.this.onFailures(e);
                        }
                    });
                }
                catch (Exception e) {
                    this.onFailures(e);
                }
            }
        }

        public void initRuleIndexAndImportRules(final IndexDetectorRequest request, final ActionListener<List<IndexMonitorResponse>> listener) {
            TransportIndexDetectorAction.this.ruleIndices.initPrepackagedRulesIndex(new ActionListener<CreateIndexResponse>(){

                public void onResponse(CreateIndexResponse response) {
                    log.debug("prepackaged rule index created");
                    TransportIndexDetectorAction.this.ruleIndices.onCreateMappingsResponse(response, true);
                    TransportIndexDetectorAction.this.ruleIndices.importRules(WriteRequest.RefreshPolicy.IMMEDIATE, TransportIndexDetectorAction.this.indexTimeout, new ActionListener<BulkResponse>(){

                        public void onResponse(BulkResponse response) {
                            log.debug("rules imported");
                            if (!response.hasFailures()) {
                                AsyncIndexDetectorsAction.this.importRules(request, (ActionListener<List<IndexMonitorResponse>>)listener);
                            } else {
                                AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException(response.buildFailureMessage(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                            }
                        }

                        public void onFailure(Exception e) {
                            log.debug("failed to import rules", (Throwable)e);
                            AsyncIndexDetectorsAction.this.onFailures(e);
                        }
                    });
                }

                public void onFailure(Exception e) {
                    AsyncIndexDetectorsAction.this.onFailures(e);
                }
            }, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    TransportIndexDetectorAction.this.ruleIndices.onUpdateMappingsResponse(response, true);
                    TransportIndexDetectorAction.this.ruleIndices.deleteRules(new ActionListener<BulkByScrollResponse>(){

                        public void onResponse(BulkByScrollResponse response) {
                            TransportIndexDetectorAction.this.ruleIndices.importRules(WriteRequest.RefreshPolicy.IMMEDIATE, TransportIndexDetectorAction.this.indexTimeout, new ActionListener<BulkResponse>(){

                                public void onResponse(BulkResponse response) {
                                    if (!response.hasFailures()) {
                                        AsyncIndexDetectorsAction.this.importRules(request, (ActionListener<List<IndexMonitorResponse>>)listener);
                                    } else {
                                        AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException(response.buildFailureMessage(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                    }
                                }

                                public void onFailure(Exception e) {
                                    AsyncIndexDetectorsAction.this.onFailures(e);
                                }
                            });
                        }

                        public void onFailure(Exception e) {
                            AsyncIndexDetectorsAction.this.onFailures(e);
                        }
                    });
                }

                public void onFailure(Exception e) {
                    AsyncIndexDetectorsAction.this.onFailures(e);
                }
            }, new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    long count;
                    if (response.isTimedOut()) {
                        AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
                    }
                    if ((count = response.getHits().getTotalHits().value()) == 0L) {
                        TransportIndexDetectorAction.this.ruleIndices.importRules(WriteRequest.RefreshPolicy.IMMEDIATE, TransportIndexDetectorAction.this.indexTimeout, new ActionListener<BulkResponse>(){

                            public void onResponse(BulkResponse response) {
                                if (!response.hasFailures()) {
                                    AsyncIndexDetectorsAction.this.importRules(request, (ActionListener<List<IndexMonitorResponse>>)listener);
                                } else {
                                    AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException(response.buildFailureMessage(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                }
                            }

                            public void onFailure(Exception e) {
                                AsyncIndexDetectorsAction.this.onFailures(e);
                            }
                        });
                    } else {
                        AsyncIndexDetectorsAction.this.importRules(request, (ActionListener<List<IndexMonitorResponse>>)listener);
                    }
                }

                public void onFailure(Exception e) {
                    AsyncIndexDetectorsAction.this.onFailures(e);
                }
            });
        }

        public void importRules(IndexDetectorRequest request, final ActionListener<List<IndexMonitorResponse>> listener) {
            final Detector detector = request.getDetector();
            String ruleTopic = detector.getDetectorType();
            final DetectorInput detectorInput = detector.getInputs().get(0);
            final String logIndex = detectorInput.getIndices().get(0);
            List<String> ruleIds = detectorInput.getPrePackagedRules().stream().map(DetectorRule::getId).collect(Collectors.toList());
            NestedQueryBuilder queryBuilder = QueryBuilders.nestedQuery((String)"rule", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"rule.category", (Object)ruleTopic)).must((QueryBuilder)QueryBuilders.termsQuery((String)"_id", (String[])ruleIds.toArray(new String[0]))), (ScoreMode)ScoreMode.Avg);
            SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-pre-packaged-rules-config"}).source(new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder).size(10000)).preference(Preference.PRIMARY_FIRST.type());
            TransportIndexDetectorAction.this.logger.debug("importing prepackaged rules");
            TransportIndexDetectorAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    if (response.isTimedOut()) {
                        AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
                    }
                    TransportIndexDetectorAction.this.logger.debug("prepackaged rules fetch success");
                    SearchHits hits = response.getHits();
                    ArrayList<Pair<String, Rule>> queries = new ArrayList<Pair<String, Rule>>();
                    try {
                        for (SearchHit hit : hits) {
                            XContentParser xcp = XContentType.JSON.xContent().createParser(TransportIndexDetectorAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                            Rule rule = Rule.docParse(xcp, hit.getId(), hit.getVersion());
                            String id = hit.getId();
                            queries.add((Pair<String, Rule>)Pair.of((Object)id, (Object)rule));
                        }
                        if (TransportIndexDetectorAction.this.ruleIndices.ruleIndexExists(false)) {
                            AsyncIndexDetectorsAction.this.importCustomRules(detector, detectorInput, queries, (ActionListener<List<IndexMonitorResponse>>)listener);
                        } else if (detectorInput.getCustomRules().size() > 0) {
                            AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException("Custom Rule Index not found", RestStatus.NOT_FOUND, new Object[0]));
                        } else {
                            AsyncIndexDetectorsAction.this.resolveRuleFieldNamesAndUpsertMonitorFromQueries(queries, detector, logIndex, (ActionListener<List<IndexMonitorResponse>>)listener);
                        }
                    }
                    catch (Exception e) {
                        TransportIndexDetectorAction.this.logger.debug("failed to fetch prepackaged rules", (Throwable)e);
                        AsyncIndexDetectorsAction.this.onFailures(e);
                    }
                }

                public void onFailure(Exception e) {
                    AsyncIndexDetectorsAction.this.onFailures(e);
                }
            });
        }

        private void resolveRuleFieldNamesAndUpsertMonitorFromQueries(final List<Pair<String, Rule>> queries, final Detector detector, final String logIndex, final ActionListener<List<IndexMonitorResponse>> listener) {
            TransportIndexDetectorAction.this.logger.error("PERF_DEBUG_SAP: Fetching alias path pairs to construct rule_field_names");
            final long start = System.currentTimeMillis();
            final HashSet ruleFieldNames = new HashSet();
            for (Pair<String, Rule> query : queries) {
                List queryFieldNames = ((Rule)query.getValue()).getQueryFieldNames().stream().map(Value::getValue).collect(Collectors.toList());
                ruleFieldNames.addAll(queryFieldNames);
            }
            TransportIndexDetectorAction.this.client.execute((ActionType)GetIndexMappingsAction.INSTANCE, (ActionRequest)new GetIndexMappingsRequest(logIndex), (ActionListener)new ActionListener<GetIndexMappingsResponse>(){

                public void onResponse(GetIndexMappingsResponse getMappingsViewResponse) {
                    try {
                        List<Pair<String, String>> aliasPathPairs = MapperUtils.getAllAliasPathPairs(getMappingsViewResponse.getMappings().get(logIndex));
                        for (Pair<String, String> aliasPathPair : aliasPathPairs) {
                            if (!ruleFieldNames.contains(aliasPathPair.getLeft())) continue;
                            ruleFieldNames.remove(aliasPathPair.getLeft());
                            ruleFieldNames.add((String)aliasPathPair.getRight());
                        }
                        long took = System.currentTimeMillis() - start;
                        log.debug("completed collecting rule_field_names in {} millis", (Object)took);
                    }
                    catch (Exception e) {
                        TransportIndexDetectorAction.this.logger.error("Failure in parsing rule field names/aliases while " + detector.getId() == null ? "creating" : "updating detector. Not optimizing detector queries with relevant fields", (Throwable)e);
                        ruleFieldNames.clear();
                    }
                    AsyncIndexDetectorsAction.this.upsertMonitorQueries(queries, detector, (ActionListener<List<IndexMonitorResponse>>)listener, ruleFieldNames, logIndex);
                }

                public void onFailure(Exception e) {
                    log.error("Failed to fetch mappings view response for log index " + logIndex, (Throwable)e);
                    listener.onFailure(e);
                }
            });
        }

        private void upsertMonitorQueries(List<Pair<String, Rule>> queries, Detector detector, ActionListener<List<IndexMonitorResponse>> listener, Set<String> ruleFieldNames, String logIndex) {
            if (this.request.getMethod() == RestRequest.Method.POST) {
                TransportIndexDetectorAction.this.createMonitorFromQueries(queries, detector, listener, this.request.getRefreshPolicy(), new ArrayList<String>(ruleFieldNames));
            } else if (this.request.getMethod() == RestRequest.Method.PUT) {
                TransportIndexDetectorAction.this.updateMonitorFromQueries(logIndex, queries, detector, listener, this.request.getRefreshPolicy(), new ArrayList<String>(ruleFieldNames));
            }
        }

        public void importCustomRules(final Detector detector, DetectorInput detectorInput, final List<Pair<String, Rule>> queries, final ActionListener<List<IndexMonitorResponse>> listener) {
            final String logIndex = detectorInput.getIndices().get(0);
            List<String> ruleIds = detectorInput.getCustomRules().stream().map(DetectorRule::getId).collect(Collectors.toList());
            TermsQueryBuilder queryBuilder = QueryBuilders.termsQuery((String)"_id", (String[])ruleIds.toArray(new String[0]));
            SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-custom-rules-config"}).source(new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true)).query((QueryBuilder)queryBuilder).size(10000)).preference(Preference.PRIMARY_FIRST.type());
            TransportIndexDetectorAction.this.logger.debug("importing custom rules");
            TransportIndexDetectorAction.this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    if (response.isTimedOut()) {
                        AsyncIndexDetectorsAction.this.onFailures((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
                    }
                    TransportIndexDetectorAction.this.logger.debug("custom rules fetch successful");
                    SearchHits hits = response.getHits();
                    try {
                        for (SearchHit hit : hits) {
                            XContentParser xcp = XContentType.JSON.xContent().createParser(TransportIndexDetectorAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                            Rule rule = Rule.docParse(xcp, hit.getId(), hit.getVersion());
                            String id = hit.getId();
                            queries.add(Pair.of((Object)id, (Object)rule));
                        }
                        AsyncIndexDetectorsAction.this.resolveRuleFieldNamesAndUpsertMonitorFromQueries(queries, detector, logIndex, (ActionListener<List<IndexMonitorResponse>>)listener);
                    }
                    catch (Exception ex) {
                        AsyncIndexDetectorsAction.this.onFailures(ex);
                    }
                }

                public void onFailure(Exception e) {
                    AsyncIndexDetectorsAction.this.onFailures(e);
                }
            });
        }

        public void indexDetector() throws Exception {
            IndexRequest indexRequest;
            if (this.request.getMethod() == RestRequest.Method.POST) {
                indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-detectors-config").setRefreshPolicy(this.request.getRefreshPolicy())).source(this.request.getDetector().toXContentWithUser(XContentFactory.jsonBuilder(), (ToXContent.Params)new ToXContent.MapParams(Map.of("with_type", "true")))).timeout(TransportIndexDetectorAction.this.indexTimeout);
            } else {
                this.request.getDetector().setLastUpdateTime(Instant.now());
                indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-detectors-config").setRefreshPolicy(this.request.getRefreshPolicy())).source(this.request.getDetector().toXContentWithUser(XContentFactory.jsonBuilder(), (ToXContent.Params)new ToXContent.MapParams(Map.of("with_type", "true")))).id(this.request.getDetectorId()).timeout(TransportIndexDetectorAction.this.indexTimeout);
            }
            log.debug("indexing detector");
            TransportIndexDetectorAction.this.client.index(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse response) {
                    log.debug("detector indexed success.");
                    Detector responseDetector = AsyncIndexDetectorsAction.this.request.getDetector();
                    responseDetector.setId(response.getId());
                    AsyncIndexDetectorsAction.this.onOperation(response, responseDetector);
                }

                public void onFailure(final Exception e) {
                    TransportIndexDetectorAction.this.workflowService.deleteWorkflow(AsyncIndexDetectorsAction.this.request.getDetector().getWorkflowIds().get(0), new ActionListener<DeleteWorkflowResponse>(){

                        public void onResponse(DeleteWorkflowResponse deleteWorkflowResponse) {
                            TransportIndexDetectorAction.this.monitorService.deleteAlertingMonitors(AsyncIndexDetectorsAction.this.request.getDetector().getMonitorIds(), AsyncIndexDetectorsAction.this.request.getRefreshPolicy(), new ActionListener<List<DeleteMonitorResponse>>(){

                                public void onResponse(List<DeleteMonitorResponse> deleteMonitorResponses) {
                                    AsyncIndexDetectorsAction.this.onFailures(e);
                                }

                                public void onFailure(Exception e) {
                                    AsyncIndexDetectorsAction.this.onFailures(e);
                                }
                            });
                        }

                        public void onFailure(Exception e2) {
                            AsyncIndexDetectorsAction.this.onFailures(e2);
                        }
                    });
                }
            });
        }

        private void onOperation(IndexResponse response, Detector detector) {
            this.response.set(response);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(detector, null);
            }
        }

        private void onFailures(Exception t) {
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(null, t);
            }
        }

        private void finishHim(Detector detector, Exception t) {
            TransportIndexDetectorAction.this.threadPool.executor("generic").execute((Runnable)ActionRunnable.supply(this.listener, () -> {
                if (t != null) {
                    log.error("exception:", (Throwable)t);
                    if (t instanceof OpenSearchStatusException) {
                        throw t;
                    }
                    throw SecurityAnalyticsException.wrap(t);
                }
                return new IndexDetectorResponse(detector.getId(), detector.getVersion(), this.request.getMethod() == RestRequest.Method.POST ? RestStatus.CREATED : RestStatus.OK, detector);
            }));
        }

        private List<String> getMonitorIds(List<IndexMonitorResponse> monitorResponses) {
            return monitorResponses.stream().map(IndexMonitorResponse::getId).collect(Collectors.toList());
        }

        private Map<String, String> mapMonitorIds(List<IndexMonitorResponse> monitorResponses) {
            return monitorResponses.stream().collect(Collectors.toMap(it -> {
                if (Monitor.MonitorType.BUCKET_LEVEL_MONITOR.getValue().equals(it.getMonitor().getMonitorType())) {
                    return ((Trigger)it.getMonitor().getTriggers().get(0)).getId();
                }
                if (it.getMonitor().getName().contains("_chained_findings")) {
                    return TransportIndexDetectorAction.CHAINED_FINDINGS_MONITOR_STRING;
                }
                return "-1";
            }, IndexMonitorResponse::getId));
        }
    }
}

