/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.alerting.spi.RemoteMonitorRunner;
import org.opensearch.alerting.spi.RemoteMonitorRunnerExtension;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.LifecycleComponent;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.commons.alerting.action.AlertingActions;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.codec.CodecServiceFactory;
import org.opensearch.index.engine.EngineFactory;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.jobscheduler.spi.JobSchedulerExtension;
import org.opensearch.jobscheduler.spi.ScheduledJobParser;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ClusterPlugin;
import org.opensearch.plugins.EnginePlugin;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.securityanalytics.action.AckAlertsAction;
import org.opensearch.securityanalytics.action.AckCorrelationAlertsAction;
import org.opensearch.securityanalytics.action.CorrelatedFindingAction;
import org.opensearch.securityanalytics.action.CreateIndexMappingsAction;
import org.opensearch.securityanalytics.action.DeleteCorrelationRuleAction;
import org.opensearch.securityanalytics.action.DeleteCustomLogTypeAction;
import org.opensearch.securityanalytics.action.DeleteDetectorAction;
import org.opensearch.securityanalytics.action.DeleteRuleAction;
import org.opensearch.securityanalytics.action.GetAlertsAction;
import org.opensearch.securityanalytics.action.GetAllRuleCategoriesAction;
import org.opensearch.securityanalytics.action.GetCorrelationAlertsAction;
import org.opensearch.securityanalytics.action.GetDetectorAction;
import org.opensearch.securityanalytics.action.GetFindingsAction;
import org.opensearch.securityanalytics.action.GetIndexMappingsAction;
import org.opensearch.securityanalytics.action.GetMappingsViewAction;
import org.opensearch.securityanalytics.action.IndexCorrelationRuleAction;
import org.opensearch.securityanalytics.action.IndexCustomLogTypeAction;
import org.opensearch.securityanalytics.action.IndexDetectorAction;
import org.opensearch.securityanalytics.action.IndexRuleAction;
import org.opensearch.securityanalytics.action.ListCorrelationsAction;
import org.opensearch.securityanalytics.action.SearchCorrelationRuleAction;
import org.opensearch.securityanalytics.action.SearchCustomLogTypeAction;
import org.opensearch.securityanalytics.action.SearchDetectorAction;
import org.opensearch.securityanalytics.action.SearchRuleAction;
import org.opensearch.securityanalytics.action.TestS3ConnectionAction;
import org.opensearch.securityanalytics.action.UpdateIndexMappingsAction;
import org.opensearch.securityanalytics.action.ValidateRulesAction;
import org.opensearch.securityanalytics.correlation.alert.CorrelationAlertService;
import org.opensearch.securityanalytics.correlation.alert.notifications.NotificationService;
import org.opensearch.securityanalytics.correlation.index.codec.CorrelationCodecService;
import org.opensearch.securityanalytics.correlation.index.mapper.CorrelationVectorFieldMapper;
import org.opensearch.securityanalytics.correlation.index.query.CorrelationQueryBuilder;
import org.opensearch.securityanalytics.indexmanagment.DetectorIndexManagementService;
import org.opensearch.securityanalytics.jobscheduler.SecurityAnalyticsRunner;
import org.opensearch.securityanalytics.logtype.BuiltinLogTypeLoader;
import org.opensearch.securityanalytics.logtype.LogTypeService;
import org.opensearch.securityanalytics.mapper.IndexTemplateManager;
import org.opensearch.securityanalytics.mapper.MapperService;
import org.opensearch.securityanalytics.model.CustomLogType;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.model.DetectorInput;
import org.opensearch.securityanalytics.model.Rule;
import org.opensearch.securityanalytics.model.ThreatIntelFeedData;
import org.opensearch.securityanalytics.resthandler.RestAcknowledgeAlertsAction;
import org.opensearch.securityanalytics.resthandler.RestAcknowledgeCorrelationAlertsAction;
import org.opensearch.securityanalytics.resthandler.RestCreateIndexMappingsAction;
import org.opensearch.securityanalytics.resthandler.RestDeleteCorrelationRuleAction;
import org.opensearch.securityanalytics.resthandler.RestDeleteCustomLogTypeAction;
import org.opensearch.securityanalytics.resthandler.RestDeleteDetectorAction;
import org.opensearch.securityanalytics.resthandler.RestDeleteRuleAction;
import org.opensearch.securityanalytics.resthandler.RestGetAlertsAction;
import org.opensearch.securityanalytics.resthandler.RestGetAllRuleCategoriesAction;
import org.opensearch.securityanalytics.resthandler.RestGetCorrelationsAlertsAction;
import org.opensearch.securityanalytics.resthandler.RestGetDetectorAction;
import org.opensearch.securityanalytics.resthandler.RestGetFindingsAction;
import org.opensearch.securityanalytics.resthandler.RestGetIndexMappingsAction;
import org.opensearch.securityanalytics.resthandler.RestGetMappingsViewAction;
import org.opensearch.securityanalytics.resthandler.RestIndexCorrelationRuleAction;
import org.opensearch.securityanalytics.resthandler.RestIndexCustomLogTypeAction;
import org.opensearch.securityanalytics.resthandler.RestIndexDetectorAction;
import org.opensearch.securityanalytics.resthandler.RestIndexRuleAction;
import org.opensearch.securityanalytics.resthandler.RestListCorrelationAction;
import org.opensearch.securityanalytics.resthandler.RestSearchCorrelationAction;
import org.opensearch.securityanalytics.resthandler.RestSearchCorrelationRuleAction;
import org.opensearch.securityanalytics.resthandler.RestSearchCustomLogTypeAction;
import org.opensearch.securityanalytics.resthandler.RestSearchDetectorAction;
import org.opensearch.securityanalytics.resthandler.RestSearchRuleAction;
import org.opensearch.securityanalytics.resthandler.RestTestS3ConnectionAction;
import org.opensearch.securityanalytics.resthandler.RestUpdateIndexMappingsAction;
import org.opensearch.securityanalytics.resthandler.RestValidateRulesAction;
import org.opensearch.securityanalytics.services.STIX2IOCFetchService;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.threatIntel.action.GetIocFindingsAction;
import org.opensearch.securityanalytics.threatIntel.action.ListIOCsAction;
import org.opensearch.securityanalytics.threatIntel.action.PutTIFJobAction;
import org.opensearch.securityanalytics.threatIntel.action.SADeleteTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.action.SAGetTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.action.SAIndexTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.action.SARefreshTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.action.SASearchTIFSourceConfigsAction;
import org.opensearch.securityanalytics.threatIntel.action.monitor.DeleteThreatIntelMonitorAction;
import org.opensearch.securityanalytics.threatIntel.action.monitor.GetThreatIntelAlertsAction;
import org.opensearch.securityanalytics.threatIntel.action.monitor.IndexThreatIntelMonitorAction;
import org.opensearch.securityanalytics.threatIntel.action.monitor.SearchThreatIntelMonitorAction;
import org.opensearch.securityanalytics.threatIntel.action.monitor.UpdateThreatIntelAlertStatusAction;
import org.opensearch.securityanalytics.threatIntel.common.TIFLockService;
import org.opensearch.securityanalytics.threatIntel.feedMetadata.BuiltInTIFMetadataLoader;
import org.opensearch.securityanalytics.threatIntel.iocscan.dao.IocFindingService;
import org.opensearch.securityanalytics.threatIntel.iocscan.dao.ThreatIntelAlertService;
import org.opensearch.securityanalytics.threatIntel.iocscan.service.SaIoCScanService;
import org.opensearch.securityanalytics.threatIntel.iocscan.service.ThreatIntelMonitorRunner;
import org.opensearch.securityanalytics.threatIntel.jobscheduler.TIFJobRunner;
import org.opensearch.securityanalytics.threatIntel.jobscheduler.TIFSourceConfigRunner;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfig;
import org.opensearch.securityanalytics.threatIntel.model.TIFJobParameter;
import org.opensearch.securityanalytics.threatIntel.model.monitor.TransportThreatIntelMonitorFanOutAction;
import org.opensearch.securityanalytics.threatIntel.resthandler.RestDeleteTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.resthandler.RestGetIocFindingsAction;
import org.opensearch.securityanalytics.threatIntel.resthandler.RestGetTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.resthandler.RestIndexTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.resthandler.RestListIOCsAction;
import org.opensearch.securityanalytics.threatIntel.resthandler.RestRefreshTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.resthandler.RestSearchTIFSourceConfigsAction;
import org.opensearch.securityanalytics.threatIntel.resthandler.monitor.RestDeleteThreatIntelMonitorAction;
import org.opensearch.securityanalytics.threatIntel.resthandler.monitor.RestGetThreatIntelAlertsAction;
import org.opensearch.securityanalytics.threatIntel.resthandler.monitor.RestIndexThreatIntelMonitorAction;
import org.opensearch.securityanalytics.threatIntel.resthandler.monitor.RestSearchThreatIntelMonitorAction;
import org.opensearch.securityanalytics.threatIntel.resthandler.monitor.RestUpdateThreatIntelAlertsStatusAction;
import org.opensearch.securityanalytics.threatIntel.service.DefaultTifSourceConfigLoaderService;
import org.opensearch.securityanalytics.threatIntel.service.DetectorThreatIntelService;
import org.opensearch.securityanalytics.threatIntel.service.SATIFSourceConfigManagementService;
import org.opensearch.securityanalytics.threatIntel.service.SATIFSourceConfigService;
import org.opensearch.securityanalytics.threatIntel.service.TIFJobParameterService;
import org.opensearch.securityanalytics.threatIntel.service.TIFJobUpdateService;
import org.opensearch.securityanalytics.threatIntel.service.ThreatIntelFeedDataService;
import org.opensearch.securityanalytics.threatIntel.transport.TransportDeleteTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.transport.TransportGetIocFindingsAction;
import org.opensearch.securityanalytics.threatIntel.transport.TransportGetTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.transport.TransportIndexTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.transport.TransportListIOCsAction;
import org.opensearch.securityanalytics.threatIntel.transport.TransportPutTIFJobAction;
import org.opensearch.securityanalytics.threatIntel.transport.TransportRefreshTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.transport.TransportSearchTIFSourceConfigsAction;
import org.opensearch.securityanalytics.threatIntel.transport.monitor.TransportDeleteThreatIntelMonitorAction;
import org.opensearch.securityanalytics.threatIntel.transport.monitor.TransportGetThreatIntelAlertsAction;
import org.opensearch.securityanalytics.threatIntel.transport.monitor.TransportIndexThreatIntelMonitorAction;
import org.opensearch.securityanalytics.threatIntel.transport.monitor.TransportSearchThreatIntelMonitorAction;
import org.opensearch.securityanalytics.threatIntel.transport.monitor.TransportUpdateThreatIntelAlertStatusAction;
import org.opensearch.securityanalytics.transport.TransportAckCorrelationAlertsAction;
import org.opensearch.securityanalytics.transport.TransportAcknowledgeAlertsAction;
import org.opensearch.securityanalytics.transport.TransportCorrelateFindingAction;
import org.opensearch.securityanalytics.transport.TransportCreateIndexMappingsAction;
import org.opensearch.securityanalytics.transport.TransportDeleteCorrelationRuleAction;
import org.opensearch.securityanalytics.transport.TransportDeleteCustomLogTypeAction;
import org.opensearch.securityanalytics.transport.TransportDeleteDetectorAction;
import org.opensearch.securityanalytics.transport.TransportDeleteRuleAction;
import org.opensearch.securityanalytics.transport.TransportGetAlertsAction;
import org.opensearch.securityanalytics.transport.TransportGetAllRuleCategoriesAction;
import org.opensearch.securityanalytics.transport.TransportGetCorrelationAlertsAction;
import org.opensearch.securityanalytics.transport.TransportGetDetectorAction;
import org.opensearch.securityanalytics.transport.TransportGetFindingsAction;
import org.opensearch.securityanalytics.transport.TransportGetIndexMappingsAction;
import org.opensearch.securityanalytics.transport.TransportGetMappingsViewAction;
import org.opensearch.securityanalytics.transport.TransportIndexCorrelationRuleAction;
import org.opensearch.securityanalytics.transport.TransportIndexCustomLogTypeAction;
import org.opensearch.securityanalytics.transport.TransportIndexDetectorAction;
import org.opensearch.securityanalytics.transport.TransportIndexRuleAction;
import org.opensearch.securityanalytics.transport.TransportListCorrelationAction;
import org.opensearch.securityanalytics.transport.TransportSearchCorrelationAction;
import org.opensearch.securityanalytics.transport.TransportSearchCorrelationRuleAction;
import org.opensearch.securityanalytics.transport.TransportSearchCustomLogTypeAction;
import org.opensearch.securityanalytics.transport.TransportSearchDetectorAction;
import org.opensearch.securityanalytics.transport.TransportSearchRuleAction;
import org.opensearch.securityanalytics.transport.TransportTestS3ConnectionAction;
import org.opensearch.securityanalytics.transport.TransportUpdateIndexMappingsAction;
import org.opensearch.securityanalytics.transport.TransportValidateRulesAction;
import org.opensearch.securityanalytics.util.CorrelationIndices;
import org.opensearch.securityanalytics.util.CorrelationRuleIndices;
import org.opensearch.securityanalytics.util.CustomLogTypeIndices;
import org.opensearch.securityanalytics.util.DetectorIndices;
import org.opensearch.securityanalytics.util.RuleIndices;
import org.opensearch.securityanalytics.util.RuleTopicIndices;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.node.NodeClient;
import org.opensearch.watcher.ResourceWatcherService;
import reactor.util.annotation.NonNull;

public class SecurityAnalyticsPlugin
extends Plugin
implements ActionPlugin,
MapperPlugin,
SearchPlugin,
EnginePlugin,
ClusterPlugin,
SystemIndexPlugin,
JobSchedulerExtension,
RemoteMonitorRunnerExtension {
    private static final Logger log = LogManager.getLogger(SecurityAnalyticsPlugin.class);
    public static final String PLUGINS_BASE_URI = "/_plugins/_security_analytics";
    public static final String MAPPER_BASE_URI = "/_plugins/_security_analytics/mappings";
    public static final String MAPPINGS_VIEW_BASE_URI = "/_plugins/_security_analytics/mappings/view";
    public static final String FINDINGS_BASE_URI = "/_plugins/_security_analytics/findings";
    public static final String ALERTS_BASE_URI = "/_plugins/_security_analytics/alerts";
    public static final String DETECTOR_BASE_URI = "/_plugins/_security_analytics/detectors";
    public static final String RULE_BASE_URI = "/_plugins/_security_analytics/rules";
    public static final String FINDINGS_CORRELATE_URI = "/_plugins/_security_analytics/findings/correlate";
    public static final String LIST_CORRELATIONS_URI = "/_plugins/_security_analytics/correlations";
    public static final String CORRELATION_RULES_BASE_URI = "/_plugins/_security_analytics/correlation/rules";
    public static final String THREAT_INTEL_BASE_URI = "/_plugins/_security_analytics/threat_intel";
    public static final String THREAT_INTEL_SOURCE_URI = "/_plugins/_security_analytics/threat_intel/sources";
    public static final String THREAT_INTEL_MONITOR_URI = "/_plugins/_security_analytics/threat_intel/monitors";
    public static final String LIST_IOCS_URI = "/_plugins/_security_analytics/threat_intel/iocs";
    public static final String THREAT_INTEL_ALERTS_URI = "/_plugins/_security_analytics/threat_intel/alerts";
    public static final String THREAT_INTEL_ALERTS_STATUS_URI = "/_plugins/_security_analytics/threat_intel/alerts/status";
    public static final String TEST_CONNECTION_BASE_URI = "/_plugins/_security_analytics/connections/%s/test";
    public static final String TEST_S3_CONNECTION_URI = String.format("/_plugins/_security_analytics/connections/%s/test", "s3");
    public static final String CUSTOM_LOG_TYPE_URI = "/_plugins/_security_analytics/logtype";
    public static final String CORRELATIONS_ALERTS_BASE_URI = "/_plugins/_security_analytics/correlationAlerts";
    public static final String JOB_INDEX_NAME = ".opensearch-sap--job";
    public static final String JOB_TYPE = "opensearch_sap_job";
    public static final Map<String, Object> TIF_JOB_INDEX_SETTING = Map.of("index.number_of_shards", 1, "index.auto_expand_replicas", "0-all", "index.hidden", true);
    private CorrelationRuleIndices correlationRuleIndices;
    private DetectorIndices detectorIndices;
    private RuleTopicIndices ruleTopicIndices;
    private CorrelationIndices correlationIndices;
    private CustomLogTypeIndices customLogTypeIndices;
    private MapperService mapperService;
    private RuleIndices ruleIndices;
    private DetectorIndexManagementService detectorIndexManagementService;
    private IndexTemplateManager indexTemplateManager;
    private BuiltinLogTypeLoader builtinLogTypeLoader;
    private LogTypeService logTypeService;
    private SATIFSourceConfigService saTifSourceConfigService;

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        List<SystemIndexDescriptor> descriptors = List.of(new SystemIndexDescriptor(".opensearch-sap-threat-intel", "System index used for threat intel data"), new SystemIndexDescriptor(".opensearch-sap-correlation-alerts", "System index used for Correlation Alerts"));
        return descriptors;
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.builtinLogTypeLoader = new BuiltinLogTypeLoader();
        BuiltInTIFMetadataLoader builtInTIFMetadataLoader = new BuiltInTIFMetadataLoader();
        this.logTypeService = new LogTypeService(client, clusterService, xContentRegistry, this.builtinLogTypeLoader);
        this.detectorIndices = new DetectorIndices(client.admin(), clusterService, threadPool);
        this.ruleTopicIndices = new RuleTopicIndices(client, clusterService, this.logTypeService);
        this.correlationIndices = new CorrelationIndices(client, clusterService);
        this.customLogTypeIndices = new CustomLogTypeIndices(client.admin(), clusterService);
        this.indexTemplateManager = new IndexTemplateManager(client, clusterService, indexNameExpressionResolver, xContentRegistry);
        this.mapperService = new MapperService(client, clusterService, indexNameExpressionResolver, this.indexTemplateManager, this.logTypeService);
        this.ruleIndices = new RuleIndices(this.logTypeService, client, clusterService, threadPool);
        this.correlationRuleIndices = new CorrelationRuleIndices(client, clusterService);
        ThreatIntelFeedDataService threatIntelFeedDataService = new ThreatIntelFeedDataService(clusterService, client, indexNameExpressionResolver, xContentRegistry);
        DetectorThreatIntelService detectorThreatIntelService = new DetectorThreatIntelService(threatIntelFeedDataService, client, xContentRegistry);
        TIFJobParameterService tifJobParameterService = new TIFJobParameterService(client, clusterService);
        TIFJobUpdateService tifJobUpdateService = new TIFJobUpdateService(clusterService, tifJobParameterService, threatIntelFeedDataService, builtInTIFMetadataLoader);
        TIFLockService threatIntelLockService = new TIFLockService(clusterService, client);
        this.saTifSourceConfigService = new SATIFSourceConfigService(client, clusterService, threadPool, xContentRegistry, threatIntelLockService);
        STIX2IOCFetchService stix2IOCFetchService = new STIX2IOCFetchService(client, clusterService);
        SATIFSourceConfigManagementService saTifSourceConfigManagementService = new SATIFSourceConfigManagementService(this.saTifSourceConfigService, threatIntelLockService, stix2IOCFetchService, xContentRegistry, clusterService);
        SecurityAnalyticsRunner.getJobRunnerInstance();
        TIFSourceConfigRunner.getJobRunnerInstance().initialize(clusterService, threatIntelLockService, threadPool, saTifSourceConfigManagementService, this.saTifSourceConfigService);
        CorrelationAlertService correlationAlertService = new CorrelationAlertService(client, xContentRegistry);
        NotificationService notificationService = new NotificationService((NodeClient)client, scriptService);
        TIFJobRunner.getJobRunnerInstance().initialize(clusterService, tifJobUpdateService, tifJobParameterService, threatIntelLockService, threadPool, detectorThreatIntelService);
        IocFindingService iocFindingService = new IocFindingService(client, clusterService, xContentRegistry);
        ThreatIntelAlertService threatIntelAlertService = new ThreatIntelAlertService(client, clusterService, xContentRegistry);
        SaIoCScanService ioCScanService = new SaIoCScanService(client, clusterService, xContentRegistry, iocFindingService, threatIntelAlertService, notificationService);
        DefaultTifSourceConfigLoaderService defaultTifSourceConfigLoaderService = new DefaultTifSourceConfigLoaderService(builtInTIFMetadataLoader, client, saTifSourceConfigManagementService);
        return List.of(new Object[]{this.detectorIndices, this.correlationIndices, this.correlationRuleIndices, this.ruleTopicIndices, this.customLogTypeIndices, this.ruleIndices, threatIntelAlertService, this.mapperService, this.indexTemplateManager, this.builtinLogTypeLoader, builtInTIFMetadataLoader, threatIntelFeedDataService, detectorThreatIntelService, correlationAlertService, notificationService, tifJobUpdateService, tifJobParameterService, threatIntelLockService, this.saTifSourceConfigService, saTifSourceConfigManagementService, stix2IOCFetchService, ioCScanService, defaultTifSourceConfigLoaderService});
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        return List.of(DetectorIndexManagementService.class, BuiltinLogTypeLoader.class);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of(new RestHandler[]{new RestAcknowledgeAlertsAction(), new RestUpdateIndexMappingsAction(), new RestCreateIndexMappingsAction(), new RestGetIndexMappingsAction(), new RestIndexDetectorAction(), new RestGetDetectorAction(), new RestSearchDetectorAction(), new RestDeleteDetectorAction(), new RestGetFindingsAction(), new RestGetMappingsViewAction(), new RestGetAlertsAction(), new RestGetThreatIntelAlertsAction(), new RestUpdateThreatIntelAlertsStatusAction(), new RestIndexRuleAction(), new RestSearchRuleAction(), new RestDeleteRuleAction(), new RestValidateRulesAction(), new RestGetAllRuleCategoriesAction(), new RestSearchCorrelationAction(), new RestIndexCorrelationRuleAction(), new RestDeleteCorrelationRuleAction(), new RestListCorrelationAction(), new RestSearchCorrelationRuleAction(), new RestIndexCustomLogTypeAction(), new RestSearchCustomLogTypeAction(), new RestDeleteCustomLogTypeAction(), new RestIndexTIFSourceConfigAction(), new RestGetTIFSourceConfigAction(), new RestDeleteTIFSourceConfigAction(), new RestSearchTIFSourceConfigsAction(), new RestIndexThreatIntelMonitorAction(), new RestDeleteThreatIntelMonitorAction(), new RestSearchThreatIntelMonitorAction(), new RestRefreshTIFSourceConfigAction(), new RestListIOCsAction(), new RestGetIocFindingsAction(), new RestTestS3ConnectionAction(), new RestGetCorrelationsAlertsAction(), new RestAcknowledgeCorrelationAlertsAction()});
    }

    public String getJobType() {
        return JOB_TYPE;
    }

    public String getJobIndex() {
        return JOB_INDEX_NAME;
    }

    public ScheduledJobRunner getJobRunner() {
        return SecurityAnalyticsRunner.getJobRunnerInstance();
    }

    public ScheduledJobParser getJobParser() {
        return (xcp, id, jobDocVersion) -> {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                if (xcp.nextToken() == XContentParser.Token.START_OBJECT) {
                    switch (fieldName) {
                        case "source_config": {
                            return SATIFSourceConfig.parse(xcp, id, null);
                        }
                    }
                    log.error("Job parser failed for [{}] in security analytics job registration", (Object)fieldName);
                    xcp.skipChildren();
                    continue;
                }
                return TIFJobParameter.parseFromParser(xcp, id, jobDocVersion.getVersion());
            }
            return null;
        };
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return List.of(Detector.XCONTENT_REGISTRY, DetectorInput.XCONTENT_REGISTRY, Rule.XCONTENT_REGISTRY, CustomLogType.XCONTENT_REGISTRY, ThreatIntelFeedData.XCONTENT_REGISTRY);
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("sa_vector", new CorrelationVectorFieldMapper.TypeParser());
    }

    public Optional<EngineFactory> getEngineFactory(IndexSettings indexSettings) {
        return Optional.empty();
    }

    public Optional<CodecServiceFactory> getCustomCodecServiceFactory(IndexSettings indexSettings) {
        if (((Boolean)indexSettings.getValue(SecurityAnalyticsSettings.IS_CORRELATION_INDEX_SETTING)).booleanValue()) {
            return Optional.of(config -> new CorrelationCodecService(config, indexSettings));
        }
        return Optional.empty();
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("correlation", CorrelationQueryBuilder::new, CorrelationQueryBuilder::fromXContent));
    }

    public List<Setting<?>> getSettings() {
        return List.of(SecurityAnalyticsSettings.INDEX_TIMEOUT, SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, SecurityAnalyticsSettings.ALERT_HISTORY_ENABLED, SecurityAnalyticsSettings.ALERT_HISTORY_ROLLOVER_PERIOD, SecurityAnalyticsSettings.ALERT_HISTORY_INDEX_MAX_AGE, SecurityAnalyticsSettings.ALERT_HISTORY_MAX_DOCS, SecurityAnalyticsSettings.ALERT_HISTORY_RETENTION_PERIOD, SecurityAnalyticsSettings.REQUEST_TIMEOUT, SecurityAnalyticsSettings.MAX_ACTION_THROTTLE_VALUE, SecurityAnalyticsSettings.FINDING_HISTORY_ENABLED, SecurityAnalyticsSettings.FINDING_HISTORY_MAX_DOCS, SecurityAnalyticsSettings.FINDING_HISTORY_INDEX_MAX_AGE, SecurityAnalyticsSettings.FINDING_HISTORY_ROLLOVER_PERIOD, SecurityAnalyticsSettings.FINDING_HISTORY_RETENTION_PERIOD, SecurityAnalyticsSettings.CORRELATION_HISTORY_MAX_DOCS, SecurityAnalyticsSettings.CORRELATION_HISTORY_INDEX_MAX_AGE, SecurityAnalyticsSettings.CORRELATION_HISTORY_ROLLOVER_PERIOD, SecurityAnalyticsSettings.CORRELATION_HISTORY_RETENTION_PERIOD, SecurityAnalyticsSettings.IOC_FINDING_HISTORY_ENABLED, SecurityAnalyticsSettings.IOC_FINDING_HISTORY_MAX_DOCS, SecurityAnalyticsSettings.IOC_FINDING_HISTORY_INDEX_MAX_AGE, SecurityAnalyticsSettings.IOC_FINDING_HISTORY_ROLLOVER_PERIOD, SecurityAnalyticsSettings.IOC_FINDING_HISTORY_RETENTION_PERIOD, SecurityAnalyticsSettings.IS_CORRELATION_INDEX_SETTING, SecurityAnalyticsSettings.CORRELATION_TIME_WINDOW, SecurityAnalyticsSettings.ENABLE_AUTO_CORRELATIONS, SecurityAnalyticsSettings.DEFAULT_MAPPING_SCHEMA, SecurityAnalyticsSettings.ENABLE_WORKFLOW_USAGE, SecurityAnalyticsSettings.TIF_UPDATE_INTERVAL, SecurityAnalyticsSettings.BATCH_SIZE, SecurityAnalyticsSettings.THREAT_INTEL_TIMEOUT, SecurityAnalyticsSettings.IOC_INDEX_RETENTION_PERIOD, SecurityAnalyticsSettings.IOC_MAX_INDICES_PER_INDEX_PATTERN, SecurityAnalyticsSettings.IOC_SCAN_MAX_TERMS_COUNT, SecurityAnalyticsSettings.ENABLE_DETECTORS_WITH_DEDICATED_QUERY_INDICES);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)AckAlertsAction.INSTANCE, TransportAcknowledgeAlertsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateIndexMappingsAction.INSTANCE, TransportUpdateIndexMappingsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CreateIndexMappingsAction.INSTANCE, TransportCreateIndexMappingsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetIndexMappingsAction.INSTANCE, TransportGetIndexMappingsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)IndexDetectorAction.INSTANCE, TransportIndexDetectorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteDetectorAction.INSTANCE, TransportDeleteDetectorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetMappingsViewAction.INSTANCE, TransportGetMappingsViewAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetDetectorAction.INSTANCE, TransportGetDetectorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchDetectorAction.INSTANCE, TransportSearchDetectorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetFindingsAction.INSTANCE, TransportGetFindingsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetAlertsAction.INSTANCE, TransportGetAlertsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)IndexRuleAction.INSTANCE, TransportIndexRuleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchRuleAction.INSTANCE, TransportSearchRuleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteRuleAction.INSTANCE, TransportDeleteRuleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ValidateRulesAction.INSTANCE, TransportValidateRulesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetAllRuleCategoriesAction.INSTANCE, TransportGetAllRuleCategoriesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CorrelatedFindingAction.INSTANCE, TransportSearchCorrelationAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)IndexCorrelationRuleAction.INSTANCE, TransportIndexCorrelationRuleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteCorrelationRuleAction.INSTANCE, TransportDeleteCorrelationRuleAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.SUBSCRIBE_FINDINGS_ACTION_TYPE, TransportCorrelateFindingAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ListCorrelationsAction.INSTANCE, TransportListCorrelationAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchCorrelationRuleAction.INSTANCE, TransportSearchCorrelationRuleAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetThreatIntelAlertsAction.INSTANCE, TransportGetThreatIntelAlertsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateThreatIntelAlertStatusAction.INSTANCE, TransportUpdateThreatIntelAlertStatusAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)IndexCustomLogTypeAction.INSTANCE, TransportIndexCustomLogTypeAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchCustomLogTypeAction.INSTANCE, TransportSearchCustomLogTypeAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteCustomLogTypeAction.INSTANCE, TransportDeleteCustomLogTypeAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)IndexThreatIntelMonitorAction.INSTANCE, TransportIndexThreatIntelMonitorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteThreatIntelMonitorAction.INSTANCE, TransportDeleteThreatIntelMonitorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchThreatIntelMonitorAction.INSTANCE, TransportSearchThreatIntelMonitorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SAIndexTIFSourceConfigAction.INSTANCE, TransportIndexTIFSourceConfigAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SAGetTIFSourceConfigAction.INSTANCE, TransportGetTIFSourceConfigAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SADeleteTIFSourceConfigAction.INSTANCE, TransportDeleteTIFSourceConfigAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SASearchTIFSourceConfigsAction.INSTANCE, TransportSearchTIFSourceConfigsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SARefreshTIFSourceConfigAction.INSTANCE, TransportRefreshTIFSourceConfigAction.class, new Class[0]), new ActionPlugin.ActionHandler(ThreatIntelMonitorRunner.REMOTE_DOC_LEVEL_MONITOR_ACTION_INSTANCE, TransportThreatIntelMonitorFanOutAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ListIOCsAction.INSTANCE, TransportListIOCsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)TestS3ConnectionAction.INSTANCE, TransportTestS3ConnectionAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetIocFindingsAction.INSTANCE, TransportGetIocFindingsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutTIFJobAction.INSTANCE, TransportPutTIFJobAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetCorrelationAlertsAction.INSTANCE, TransportGetCorrelationAlertsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)AckCorrelationAlertsAction.INSTANCE, TransportAckCorrelationAlertsAction.class, new Class[0]));
    }

    public void onNodeStarted(DiscoveryNode localNode) {
        this.logTypeService.ensureConfigIndexIsInitialized(new ActionListener<Void>(this){

            public void onResponse(Void unused) {
                log.info("LogType config index successfully created and builtin log types loaded");
            }

            public void onFailure(Exception e) {
                log.warn("Failed to initialize LogType config index and builtin log types");
            }
        });
    }

    @NonNull
    public Map<String, RemoteMonitorRunner> getMonitorTypesToMonitorRunners() {
        return Map.of("ti_doc_level_monitor", ThreatIntelMonitorRunner.getMonitorRunner());
    }
}

