/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.transport.live_queries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.tasks.resourcetracker.TaskResourceStats;
import org.opensearch.core.tasks.resourcetracker.TaskResourceUsage;
import org.opensearch.plugin.insights.rules.action.live_queries.LiveQueriesRequest;
import org.opensearch.plugin.insights.rules.action.live_queries.LiveQueriesResponse;
import org.opensearch.plugin.insights.rules.model.Attribute;
import org.opensearch.plugin.insights.rules.model.Measurement;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskInfo;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportLiveQueriesAction
extends HandledTransportAction<LiveQueriesRequest, LiveQueriesResponse> {
    private static final Logger logger = LogManager.getLogger(TransportLiveQueriesAction.class);
    private static final String TOTAL = "total";
    private final Client client;

    @Inject
    public TransportLiveQueriesAction(TransportService transportService, Client client, ActionFilters actionFilters) {
        super("cluster:admin/opensearch/insights/live_queries", transportService, actionFilters, LiveQueriesRequest::new, "generic");
        this.client = client;
    }

    protected void doExecute(Task task, final LiveQueriesRequest request, final ActionListener<LiveQueriesResponse> listener) {
        ListTasksRequest listTasksRequest = (ListTasksRequest)new ListTasksRequest().setDetailed(request.isVerbose()).setActions(new String[]{"indices:data/read/search*"});
        String[] requestedNodeIds = request.nodesIds();
        if (requestedNodeIds != null && requestedNodeIds.length > 0) {
            listTasksRequest.setNodes(requestedNodeIds);
        }
        this.client.admin().cluster().listTasks(listTasksRequest, (ActionListener)new ActionListener<ListTasksResponse>(){

            public void onResponse(ListTasksResponse taskResponse) {
                try {
                    ArrayList<SearchQueryRecord> allFilteredRecords = new ArrayList<SearchQueryRecord>();
                    for (TaskInfo taskInfo : taskResponse.getTasks()) {
                        TaskResourceUsage totalUsage;
                        Map usageInfo;
                        if (!taskInfo.getAction().startsWith("indices:data/read/search")) continue;
                        long timestamp = taskInfo.getStartTime();
                        String nodeId = taskInfo.getTaskId().getNodeId();
                        long runningNanos = taskInfo.getRunningTimeNanos();
                        HashMap<MetricType, Measurement> measurements = new HashMap<MetricType, Measurement>();
                        measurements.put(MetricType.LATENCY, new Measurement(runningNanos));
                        long cpuNanos = 0L;
                        long memBytes = 0L;
                        TaskResourceStats stats = taskInfo.getResourceStats();
                        if (stats != null && (usageInfo = stats.getResourceUsageInfo()) != null && (totalUsage = (TaskResourceUsage)usageInfo.get(TransportLiveQueriesAction.TOTAL)) != null) {
                            cpuNanos = totalUsage.getCpuTimeInNanos();
                            memBytes = totalUsage.getMemoryInBytes();
                        }
                        measurements.put(MetricType.CPU, new Measurement(cpuNanos));
                        measurements.put(MetricType.MEMORY, new Measurement(memBytes));
                        HashMap<Attribute, Object> attributes = new HashMap<Attribute, Object>();
                        attributes.put(Attribute.NODE_ID, nodeId);
                        if (request.isVerbose()) {
                            attributes.put(Attribute.DESCRIPTION, taskInfo.getDescription());
                            attributes.put(Attribute.IS_CANCELLED, taskInfo.isCancelled());
                        }
                        SearchQueryRecord record = new SearchQueryRecord(timestamp, measurements, attributes, taskInfo.getTaskId().toString());
                        allFilteredRecords.add(record);
                    }
                    List<SearchQueryRecord> finalRecords = allFilteredRecords.stream().sorted((a, b) -> SearchQueryRecord.compare(b, a, request.getSortBy())).limit(request.getSize() < 0 ? Long.MAX_VALUE : (long)request.getSize()).toList();
                    listener.onResponse((Object)new LiveQueriesResponse(finalRecords));
                }
                catch (Exception ex) {
                    logger.error("Failed to process live queries response", (Throwable)ex);
                    listener.onFailure(ex);
                }
            }

            public void onFailure(Exception e) {
                logger.error("Failed to retrieve live queries", (Throwable)e);
                listener.onFailure(e);
            }
        });
    }
}

