/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.model;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.util.ArrayUtil;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.tasks.resourcetracker.TaskResourceInfo;
import org.opensearch.plugin.insights.rules.model.GroupingType;
import org.opensearch.search.builder.SearchSourceBuilder;

public enum Attribute {
    SEARCH_TYPE,
    SOURCE,
    TOTAL_SHARDS,
    INDICES,
    PHASE_LATENCY_MAP,
    NODE_ID,
    TASK_RESOURCE_USAGES,
    LABELS,
    QUERY_GROUP_HASHCODE,
    GROUP_BY,
    DESCRIPTION,
    TOP_N_QUERY,
    IS_CANCELLED;


    static Attribute readFromStream(StreamInput in) throws IOException {
        return Attribute.valueOf(in.readString().toUpperCase(Locale.ROOT));
    }

    static void writeTo(StreamOutput out, Attribute attribute) throws IOException {
        out.writeString(attribute.toString());
    }

    public static void writeValueTo(StreamOutput out, Object attributeValue) throws IOException {
        if (attributeValue instanceof List) {
            out.writeList((List)attributeValue);
        } else if (attributeValue instanceof SearchSourceBuilder) {
            ((SearchSourceBuilder)attributeValue).writeTo(out);
        } else if (attributeValue instanceof GroupingType) {
            out.writeString(((GroupingType)((Object)attributeValue)).getValue());
        } else {
            out.writeGenericValue(attributeValue);
        }
    }

    public static Object readAttributeValue(StreamInput in, Attribute attribute) throws IOException {
        if (attribute == TASK_RESOURCE_USAGES) {
            return in.readList(TaskResourceInfo::readFromStream);
        }
        if (attribute == SOURCE) {
            SearchSourceBuilder builder = new SearchSourceBuilder(in);
            return builder;
        }
        if (attribute == GROUP_BY) {
            return GroupingType.valueOf(in.readString().toUpperCase(Locale.ROOT));
        }
        return in.readGenericValue();
    }

    public static Map<Attribute, Object> readAttributeMap(StreamInput in) throws IOException {
        int size = Attribute.readArraySize(in);
        if (size == 0) {
            return Collections.emptyMap();
        }
        HashMap<Attribute, Object> map = new HashMap<Attribute, Object>(size);
        for (int i = 0; i < size; ++i) {
            Attribute key = Attribute.readFromStream(in);
            Object value = Attribute.readAttributeValue(in, key);
            map.put(key, value);
        }
        return map;
    }

    private static int readArraySize(StreamInput in) throws IOException {
        int arraySize = in.readVInt();
        if (arraySize > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalStateException("array length must be <= to " + ArrayUtil.MAX_ARRAY_LENGTH + " but was: " + arraySize);
        }
        if (arraySize < 0) {
            throw new NegativeArraySizeException("array size must be positive but was: " + arraySize);
        }
        return arraySize;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

