/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.Rewriteable;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.opensearch.search.aggregations.bucket.filter.FiltersAggregatorFactory;

public class FiltersAggregationBuilder
extends AbstractAggregationBuilder<FiltersAggregationBuilder> {
    public static final String NAME = "filters";
    private static final ParseField FILTERS_FIELD = new ParseField("filters", new String[0]);
    private static final ParseField OTHER_BUCKET_FIELD = new ParseField("other_bucket", new String[0]);
    private static final ParseField OTHER_BUCKET_KEY_FIELD = new ParseField("other_bucket_key", new String[0]);
    private final List<FiltersAggregator.KeyedFilter> filters;
    private final boolean keyed;
    private boolean otherBucket = false;
    private String otherBucketKey = "_other_";

    public FiltersAggregationBuilder(String name, FiltersAggregator.KeyedFilter ... filters) {
        this(name, Arrays.asList(filters), true);
    }

    private FiltersAggregationBuilder(String name, List<FiltersAggregator.KeyedFilter> filters, boolean keyed) {
        super(name);
        this.filters = new ArrayList<FiltersAggregator.KeyedFilter>(filters);
        if (keyed) {
            this.filters.sort(Comparator.comparing(FiltersAggregator.KeyedFilter::key));
            this.keyed = true;
        } else {
            this.keyed = false;
        }
    }

    public FiltersAggregationBuilder(String name, QueryBuilder ... filters) {
        super(name);
        ArrayList<FiltersAggregator.KeyedFilter> keyedFilters = new ArrayList<FiltersAggregator.KeyedFilter>(filters.length);
        for (int i = 0; i < filters.length; ++i) {
            keyedFilters.add(new FiltersAggregator.KeyedFilter(String.valueOf(i), filters[i]));
        }
        this.filters = keyedFilters;
        this.keyed = false;
    }

    public FiltersAggregationBuilder(FiltersAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.filters = new ArrayList<FiltersAggregator.KeyedFilter>(clone.filters);
        this.keyed = clone.keyed;
        this.otherBucket = clone.otherBucket;
        this.otherBucketKey = clone.otherBucketKey;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new FiltersAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public FiltersAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.keyed = in.readBoolean();
        int filtersSize = in.readVInt();
        this.filters = new ArrayList<FiltersAggregator.KeyedFilter>(filtersSize);
        if (this.keyed) {
            for (int i = 0; i < filtersSize; ++i) {
                this.filters.add(new FiltersAggregator.KeyedFilter(in));
            }
        } else {
            for (int i = 0; i < filtersSize; ++i) {
                this.filters.add(new FiltersAggregator.KeyedFilter(String.valueOf(i), (QueryBuilder)in.readNamedWriteable(QueryBuilder.class)));
            }
        }
        this.otherBucket = in.readBoolean();
        this.otherBucketKey = in.readString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.keyed);
        out.writeVInt(this.filters.size());
        if (this.keyed) {
            for (FiltersAggregator.KeyedFilter keyedFilter : this.filters) {
                keyedFilter.writeTo(out);
            }
        } else {
            for (FiltersAggregator.KeyedFilter keyedFilter : this.filters) {
                out.writeNamedWriteable((NamedWriteable)keyedFilter.filter());
            }
        }
        out.writeBoolean(this.otherBucket);
        out.writeString(this.otherBucketKey);
    }

    public FiltersAggregationBuilder otherBucket(boolean otherBucket) {
        this.otherBucket = otherBucket;
        return this;
    }

    public boolean otherBucket() {
        return this.otherBucket;
    }

    public List<FiltersAggregator.KeyedFilter> filters() {
        return Collections.unmodifiableList(this.filters);
    }

    public boolean isKeyed() {
        return this.keyed;
    }

    public FiltersAggregationBuilder otherBucketKey(String otherBucketKey) {
        if (otherBucketKey == null) {
            throw new IllegalArgumentException("[otherBucketKey] must not be null: [" + this.name + "]");
        }
        this.otherBucketKey = otherBucketKey;
        return this;
    }

    public String otherBucketKey() {
        return this.otherBucketKey;
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    @Override
    protected AggregationBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        ArrayList<FiltersAggregator.KeyedFilter> rewrittenFilters = new ArrayList<FiltersAggregator.KeyedFilter>(this.filters.size());
        boolean changed = false;
        for (FiltersAggregator.KeyedFilter kf : this.filters) {
            QueryBuilder result = Rewriteable.rewrite(kf.filter(), queryShardContext);
            rewrittenFilters.add(new FiltersAggregator.KeyedFilter(kf.key(), result));
            if (result == kf.filter()) continue;
            changed = true;
        }
        if (changed) {
            FiltersAggregationBuilder rewritten = new FiltersAggregationBuilder(this.getName(), rewrittenFilters, this.keyed);
            rewritten.otherBucket(this.otherBucket);
            rewritten.otherBucketKey(this.otherBucketKey);
            return rewritten;
        }
        return this;
    }

    @Override
    protected AggregatorFactory doBuild(QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new FiltersAggregatorFactory(this.name, this.filters, this.keyed, this.otherBucket, this.otherBucketKey, queryShardContext, parent, subFactoriesBuilder, this.metadata);
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.keyed) {
            builder.startObject(FiltersAggregator.FILTERS_FIELD.getPreferredName());
            for (FiltersAggregator.KeyedFilter keyedFilter : this.filters) {
                builder.field(keyedFilter.key(), (ToXContent)keyedFilter.filter());
            }
            builder.endObject();
        } else {
            builder.startArray(FiltersAggregator.FILTERS_FIELD.getPreferredName());
            for (FiltersAggregator.KeyedFilter keyedFilter : this.filters) {
                builder.value((Object)keyedFilter.filter());
            }
            builder.endArray();
        }
        builder.field(FiltersAggregator.OTHER_BUCKET_FIELD.getPreferredName(), this.otherBucket);
        builder.field(FiltersAggregator.OTHER_BUCKET_KEY_FIELD.getPreferredName(), this.otherBucketKey);
        builder.endObject();
        return builder;
    }

    public static FiltersAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        ArrayList<FiltersAggregator.KeyedFilter> filters = new ArrayList<FiltersAggregator.KeyedFilter>();
        String currentFieldName = null;
        String otherBucketKey = null;
        Boolean otherBucket = null;
        boolean keyed = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if (OTHER_BUCKET_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    otherBucket = parser.booleanValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (OTHER_BUCKET_KEY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    otherBucketKey = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (FILTERS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    String key = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            key = parser.currentName();
                            continue;
                        }
                        QueryBuilder filter = AbstractQueryBuilder.parseInnerQueryBuilder(parser);
                        filters.add(new FiltersAggregator.KeyedFilter(key, filter));
                    }
                    keyed = true;
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (FILTERS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    ArrayList<QueryBuilder> builders = new ArrayList<QueryBuilder>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        QueryBuilder filter = AbstractQueryBuilder.parseInnerQueryBuilder(parser);
                        builders.add(filter);
                    }
                    for (int i = 0; i < builders.size(); ++i) {
                        filters.add(new FiltersAggregator.KeyedFilter(String.valueOf(i), (QueryBuilder)builders.get(i)));
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unknown key for a " + String.valueOf(token) + " in [" + aggregationName + "]: [" + currentFieldName + "].", new Object[0]);
        }
        if (filters.isEmpty()) {
            throw new IllegalArgumentException("[" + String.valueOf(FILTERS_FIELD) + "] cannot be empty.");
        }
        FiltersAggregationBuilder factory = new FiltersAggregationBuilder(aggregationName, filters, keyed);
        if (otherBucket == null && otherBucketKey != null) {
            otherBucket = true;
        }
        if (otherBucket != null) {
            factory.otherBucket(otherBucket);
        }
        if (otherBucketKey != null) {
            factory.otherBucketKey(otherBucketKey);
        }
        return factory;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filters, this.keyed, this.otherBucket, this.otherBucketKey);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        FiltersAggregationBuilder other = (FiltersAggregationBuilder)obj;
        return Objects.equals(this.filters, other.filters) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.otherBucket, other.otherBucket) && Objects.equals(this.otherBucketKey, other.otherBucketKey);
    }

    @Override
    public String getType() {
        return NAME;
    }
}

