/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;

public class GetConversationRequest
extends ActionRequest {
    private String conversationId;

    public GetConversationRequest(StreamInput in) throws IOException {
        super(in);
        this.conversationId = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.conversationId);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.conversationId == null) {
            exception = ValidateActions.addValidationError((String)"GetConversation Request must have a conversation id", exception);
        }
        return exception;
    }

    public static GetConversationRequest fromRestRequest(RestRequest request) throws IOException {
        String conversationId = request.param("memory_id");
        return new GetConversationRequest(conversationId);
    }

    @Generated
    public GetConversationRequest(String conversationId) {
        this.conversationId = conversationId;
    }

    @Generated
    public String getConversationId() {
        return this.conversationId;
    }
}

