/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.zoo;

import ai.djl.Application;
import ai.djl.engine.Engine;
import ai.djl.repository.Repository;
import ai.djl.repository.Version;
import ai.djl.repository.VersionRange;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelZoo;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class HfModelZoo
extends ModelZoo {
    private static final String REPO = "https://mlrepo.djl.ai/";
    private static final Repository REPOSITORY = Repository.newInstance((String)"Huggingface", (String)"https://mlrepo.djl.ai/");
    private static final String GROUP_ID = "ai.djl.huggingface.pytorch";
    private volatile boolean initialized;

    HfModelZoo() {
    }

    public String getGroupId() {
        return GROUP_ID;
    }

    public Set<String> getSupportedEngines() {
        return Collections.singleton("PyTorch");
    }

    public Collection<ModelLoader> getModelLoaders() {
        this.init();
        return super.getModelLoaders();
    }

    public ModelLoader getModelLoader(String name) {
        this.init();
        return super.getModelLoader(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (this.initialized) return;
        Class<HfModelZoo> clazz = HfModelZoo.class;
        synchronized (HfModelZoo.class) {
            if (this.initialized) return;
            Version version = new Version(Engine.getDjlVersion());
            this.addModels(Application.NLP.FILL_MASK, version);
            this.addModels(Application.NLP.QUESTION_ANSWER, version);
            this.addModels(Application.NLP.TEXT_CLASSIFICATION, version);
            this.addModels(Application.NLP.TEXT_EMBEDDING, version);
            this.addModels(Application.NLP.TOKEN_CLASSIFICATION, version);
            this.initialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void addModels(Application app, Version version) {
        Map map = this.listModels(REPOSITORY, app);
        for (Map.Entry entry : map.entrySet()) {
            VersionRange range;
            String requires;
            Map model = (Map)entry.getValue();
            if ("failed".equals(model.get("result")) || (requires = (String)model.get("requires")) != null && !(range = VersionRange.parse((String)requires)).contains(version)) continue;
            String artifactId = (String)entry.getKey();
            this.addModel(REPOSITORY.model(app, GROUP_ID, artifactId, "0.0.1"));
        }
    }
}

