/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.opensearch.index.search.NestedHelper;
import org.opensearch.neuralsearch.query.HybridQuery;
import org.opensearch.search.internal.SearchContext;

public class HybridQueryUtil {
    public static boolean isHybridQuery(Query query, SearchContext searchContext) {
        return query instanceof HybridQuery || Objects.nonNull(searchContext.parsedQuery()) && searchContext.parsedQuery().query() instanceof HybridQuery;
    }

    private static boolean hasNestedFieldOrNestedDocs(Query query, SearchContext searchContext) {
        return searchContext.mapperService().hasNested() && new NestedHelper(searchContext.mapperService()).mightMatchNestedDocs(query);
    }

    private static boolean isWrappedHybridQuery(Query query) {
        return query instanceof BooleanQuery && ((BooleanQuery)query).clauses().stream().anyMatch(clauseQuery -> clauseQuery.query() instanceof HybridQuery);
    }

    private static boolean hasAliasFilter(Query query, SearchContext searchContext) {
        return Objects.nonNull(searchContext.aliasFilter());
    }

    public static boolean isHybridQueryWrappedInBooleanQuery(SearchContext searchContext, Query query) {
        return (HybridQueryUtil.hasAliasFilter(query, searchContext) || HybridQueryUtil.hasNestedFieldOrNestedDocs(query, searchContext)) && HybridQueryUtil.isWrappedHybridQuery(query) && !((BooleanQuery)query).clauses().isEmpty();
    }

    @Generated
    private HybridQueryUtil() {
    }
}

