/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import org.apache.derby.iapi.services.monitor.DerbyObservable;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.ContainerHandleActionOnCommit;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class TruncateOnCommit
extends ContainerHandleActionOnCommit {
    private boolean commitAsWell;

    public TruncateOnCommit(ContainerKey identity, boolean commitAsWell) {
        super(identity);
        this.commitAsWell = commitAsWell;
        if (identity.getSegmentId() != -1L) {
            SanityManager.THROWASSERT((String)("segment id is not temp segment " + identity.getSegmentId()));
        }
    }

    @Override
    public void update(DerbyObservable obj, Object arg) {
        if (arg == null) {
            SanityManager.THROWASSERT((String)("still on observer list " + String.valueOf(this)));
        }
        if (arg.equals(RawTransaction.ABORT) || arg.equals(RawTransaction.SAVEPOINT_ROLLBACK) || this.commitAsWell && arg.equals(RawTransaction.COMMIT)) {
            this.openContainerAndDoIt((RawTransaction)obj);
        }
        if (arg.equals(RawTransaction.COMMIT) || arg.equals(RawTransaction.ABORT) || arg.equals(this.identity)) {
            obj.deleteObserver(this);
        }
    }

    @Override
    protected void doIt(BaseContainerHandle handle) throws StandardException {
        handle.container.truncate(handle);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TruncateOnCommit) {
            if (((TruncateOnCommit)other).commitAsWell != this.commitAsWell) {
                return false;
            }
            return super.equals(other);
        }
        return false;
    }
}

