/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.console.AeshConsole;
import io.quarkus.deployment.console.ConsoleCommand;
import io.quarkus.deployment.console.ConsoleStateManager;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.testing.MessageFormat;
import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestController;
import io.quarkus.deployment.dev.testing.TestListener;
import io.quarkus.deployment.dev.testing.TestResult;
import io.quarkus.deployment.dev.testing.TestRunListener;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.dev.console.StatusLine;
import io.quarkus.dev.spi.DevModeType;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;

public class TestConsoleHandler
implements TestListener {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.test");
    public static final ConsoleCommand TOGGLE_TEST_OUTPUT = new ConsoleCommand('o', "Toggle test output", "Toggle test output", 1000, new ConsoleCommand.HelpState(TestSupport.instance().get()::isDisplayTestOutput), () -> TestSupport.instance().get().toggleTestOutput());
    final DevModeType devModeType;
    boolean firstRun = true;
    boolean disabled = true;
    boolean currentlyFailing = false;
    volatile TestController testController;
    private String lastResults;
    private volatile ConsoleStateManager.ConsoleContext consoleContext;
    private volatile StatusLine resultsOutput;
    private volatile StatusLine testsStatusOutput;

    public TestConsoleHandler(DevModeType devModeType) {
        this.devModeType = devModeType;
    }

    public void install() {
        QuarkusClassLoader classLoader = (QuarkusClassLoader)this.getClass().getClassLoader();
        classLoader.addCloseTask(new Runnable(){

            @Override
            public void run() {
                if (TestConsoleHandler.this.resultsOutput != null) {
                    TestConsoleHandler.this.resultsOutput.close();
                }
                if (TestConsoleHandler.this.testsStatusOutput != null) {
                    TestConsoleHandler.this.testsStatusOutput.close();
                }
                if (TestConsoleHandler.this.consoleContext != null) {
                    TestConsoleHandler.this.consoleContext.reset(new ConsoleCommand[0]);
                }
            }
        });
    }

    @Override
    public void listenerRegistered(TestController testController) {
        this.testController = testController;
        this.consoleContext = ConsoleStateManager.INSTANCE.createContext("Continuous Testing");
        this.resultsOutput = QuarkusConsole.INSTANCE.registerStatusLine(200);
        this.testsStatusOutput = QuarkusConsole.INSTANCE.registerStatusLine(100);
        this.setupPausedConsole();
    }

    private void setupPausedConsole() {
        this.testsStatusOutput.setMessage("\u001b[94mTests paused\u001b[39m");
        this.consoleContext.reset(new ConsoleCommand('r', "Resume testing", "to resume testing", 500, null, new Runnable(){

            @Override
            public void run() {
                if (TestConsoleHandler.this.lastResults == null) {
                    TestConsoleHandler.this.testsStatusOutput.setMessage("\u001b[94mStarting tests\u001b[39m");
                } else {
                    TestConsoleHandler.this.testsStatusOutput.setMessage(null);
                }
                TestConsoleHandler.this.setupTestsRunningConsole();
                TestSupport.instance().get().start();
            }
        }));
        this.addTestOutput();
    }

    private void setupFirstRunConsole() {
        if (this.lastResults != null) {
            this.resultsOutput.setMessage(this.lastResults);
        } else {
            this.testsStatusOutput.setMessage("\u001b[94mRunning tests for the first time\u001b[39m");
        }
        if (this.firstRun) {
            this.consoleContext.reset(new ConsoleCommand[0]);
            this.addTestOutput();
        }
    }

    void addTestOutput() {
        if (this.devModeType != DevModeType.TEST_ONLY) {
            this.consoleContext.addCommand(TOGGLE_TEST_OUTPUT);
        }
    }

    private void setupTestsRunningConsole() {
        ConsoleCommand[] consoleCommandArray = new ConsoleCommand[5];
        consoleCommandArray[0] = new ConsoleCommand('r', "Re-run all tests", "to re-run", 500, null, () -> this.testController.runAllTests());
        consoleCommandArray[1] = new ConsoleCommand('f', "Re-run failed tests", null, () -> this.testController.runFailedTests());
        consoleCommandArray[2] = new ConsoleCommand('b', "Toggle 'broken only' mode, where only failing tests are run", new ConsoleCommand.HelpState(this.testController::isBrokenOnlyMode), () -> this.testController.toggleBrokenOnlyMode());
        consoleCommandArray[3] = new ConsoleCommand('v', "Print failures from the last test run", null, () -> this.testController.printFullResults());
        consoleCommandArray[4] = new ConsoleCommand('p', "Pause tests", null, () -> TestSupport.instance().get().stop());
        this.consoleContext.reset(consoleCommandArray);
        this.addTestOutput();
    }

    @Override
    public void testsEnabled() {
        this.disabled = false;
        this.setupFirstRunConsole();
    }

    @Override
    public void testsDisabled() {
        this.disabled = true;
        this.setupPausedConsole();
    }

    @Override
    public void testRunStarted(Consumer<TestRunListener> listenerConsumer) {
        final AtomicLong totalNoTests = new AtomicLong();
        final AtomicLong skipped = new AtomicLong();
        final AtomicLong methodCount = new AtomicLong();
        final AtomicLong failureCount = new AtomicLong();
        listenerConsumer.accept(new TestRunListener(){

            @Override
            public void runStarted(long toRun) {
                totalNoTests.set(toRun);
                TestConsoleHandler.this.testsStatusOutput.setMessage("Starting test run, " + toRun + " tests to run.");
            }

            @Override
            public void testComplete(TestResult result) {
                if (result.getTestExecutionResult().getStatus() == TestExecutionResult.Status.FAILED) {
                    failureCount.incrementAndGet();
                } else if (result.getTestExecutionResult().getStatus() == TestExecutionResult.Status.ABORTED) {
                    skipped.incrementAndGet();
                }
                methodCount.incrementAndGet();
            }

            @Override
            public void runComplete(TestRunResults results) {
                if (TestConsoleHandler.this.firstRun) {
                    TestConsoleHandler.this.setupTestsRunningConsole();
                }
                TestConsoleHandler.this.firstRun = false;
                SimpleDateFormat df = new SimpleDateFormat("kk:mm:ss");
                String end = " Tests completed at " + df.format(new Date());
                if (results.getTrigger() != null) {
                    ClassScanResult trigger = results.getTrigger();
                    LinkedHashSet<Path> linkedHashSet = new LinkedHashSet<Path>();
                    linkedHashSet.addAll(trigger.getChangedClasses());
                    linkedHashSet.addAll(trigger.getAddedClasses());
                    linkedHashSet.addAll(trigger.getDeletedClasses());
                    end = linkedHashSet.size() == 1 ? end + " due to changes to " + String.valueOf(((Path)linkedHashSet.iterator().next()).getFileName()) + "." : (linkedHashSet.size() > 1 ? end + " due to changes to " + String.valueOf(((Path)linkedHashSet.iterator().next()).getFileName()) + " and " + (linkedHashSet.size() - 1) + " other files." : end + ".");
                } else {
                    end = end + ".";
                }
                if (results.getTotalCount() == 0L) {
                    TestConsoleHandler.this.lastResults = "\u001b[94mNo tests found\u001b[39m";
                } else if (results.getFailedCount() == 0L && results.getPassedCount() == 0L) {
                    TestConsoleHandler.this.lastResults = String.format("\u001b[94mAll %d tests were skipped\u001b[39m", results.getSkippedCount());
                } else if (results.getCurrentFailing().isEmpty()) {
                    if (TestConsoleHandler.this.currentlyFailing) {
                        log.info((Object)"\u001b[32mAll tests are now passing\u001b[39m");
                    }
                    TestConsoleHandler.this.currentlyFailing = false;
                    TestConsoleHandler.this.lastResults = String.format("\u001b[32mAll %d " + TestConsoleHandler.pluralize("test is", "tests are", results.getPassedCount()) + " passing (%d skipped), %d " + TestConsoleHandler.pluralize("test was", "tests were", results.getCurrentTotalCount() - results.getCurrentSkippedCount()) + " run in %dms." + end + "\u001b[39m", results.getPassedCount(), results.getSkippedCount(), results.getCurrentTotalCount() - results.getCurrentSkippedCount(), results.getTotalTime());
                } else {
                    TestConsoleHandler.this.currentlyFailing = true;
                    log.error((Object)MessageFormat.statusHeader("TEST REPORT #" + results.getId()));
                    for (Map.Entry entry : results.getCurrentFailing().entrySet()) {
                        for (TestResult test : ((TestClassResult)entry.getValue()).getFailing()) {
                            if (!test.isReportable()) continue;
                            log.error((Object)("\u001b[91mTest " + test.getDisplayName() + " failed \n\u001b[39m"), (Throwable)test.getTestExecutionResult().getThrowable().get());
                        }
                    }
                    StringBuilder summary = new StringBuilder(MessageFormat.statusFooter("\u001b[91mSummary:") + "\n");
                    for (Map.Entry<String, TestClassResult> classEntry : results.getCurrentFailing().entrySet()) {
                        for (TestResult test : classEntry.getValue().getFailing()) {
                            if (!test.isReportable()) continue;
                            StackTraceElement testclass = null;
                            for (StackTraceElement i : ((Throwable)test.getTestExecutionResult().getThrowable().get()).getStackTrace()) {
                                if (!i.getClassName().equals(test.testClass)) continue;
                                testclass = i;
                                break;
                            }
                            if (summary.charAt(summary.length() - 1) != '\n') {
                                summary.append("\n");
                            }
                            if (testclass != null) {
                                summary.append(testclass.getClassName() + "#" + testclass.getMethodName() + "(" + testclass.getFileName() + ":" + testclass.getLineNumber() + ") ");
                            }
                            summary.append("\u001b[91m" + test.getDisplayName() + "\u001b[39m " + ((Throwable)test.getTestExecutionResult().getThrowable().get()).getMessage());
                        }
                    }
                    while (summary.charAt(summary.length() - 1) == '\n') {
                        summary.setLength(summary.length() - 1);
                    }
                    log.error((Object)summary.toString());
                    log.error((Object)MessageFormat.statusFooter("\u001b[91m" + results.getCurrentFailedCount() + " " + TestConsoleHandler.pluralize("TEST", "TESTS", results.getCurrentFailedCount()) + " FAILED"));
                    TestConsoleHandler.this.lastResults = String.format("\u001b[91m%d " + TestConsoleHandler.pluralize("test", "tests", results.getCurrentFailedCount()) + " failed\u001b[39m (\u001b[32m%d passing\u001b[39m, \u001b[94m%d skipped\u001b[39m), \u001b[91m%d " + TestConsoleHandler.pluralize("test was", "tests were", results.getCurrentTotalCount() - results.getCurrentSkippedCount()) + " run in %dms." + end + "\u001b[39m", results.getCurrentFailedCount(), results.getPassedCount(), results.getSkippedCount(), results.getCurrentTotalCount() - results.getCurrentSkippedCount(), results.getTotalTime());
                }
                if (!TestConsoleHandler.this.disabled) {
                    TestConsoleHandler.this.resultsOutput.setMessage(TestConsoleHandler.this.lastResults);
                    TestConsoleHandler.this.testsStatusOutput.setMessage(null);
                }
            }

            @Override
            public void runAborted() {
                TestConsoleHandler.this.firstRun = false;
            }

            @Override
            public void testStarted(TestIdentifier testIdentifier, String className) {
                String status = "Running " + (methodCount.get() + 1L) + "/" + String.valueOf(totalNoTests) + (String)(failureCount.get() == 0L ? "." : ". \u001b[91m" + String.valueOf(failureCount) + " " + TestConsoleHandler.pluralize("failure", "failures", failureCount) + " so far.\u001b[39m") + " Running: " + className + "#" + testIdentifier.getDisplayName();
                if (TestSupport.instance().get().isDisplayTestOutput() && QuarkusConsole.INSTANCE instanceof AeshConsole) {
                    log.info((Object)status);
                }
                TestConsoleHandler.this.testsStatusOutput.setMessage(status);
            }

            @Override
            public void dynamicTestRegistered(TestIdentifier testIdentifier) {
                totalNoTests.incrementAndGet();
            }
        });
    }

    private static String pluralize(String singular, String plural, long number) {
        if (number == 1L) {
            return singular;
        }
        return plural;
    }

    private static String pluralize(String singular, String plural, AtomicLong number) {
        return TestConsoleHandler.pluralize(singular, plural, number.get());
    }
}

