/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import org.hibernate.dialect.XmlHelper;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.StructJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class DB2StructJdbcType
implements StructJdbcType {
    public static final DB2StructJdbcType INSTANCE = new DB2StructJdbcType();
    private final String structTypeName;
    private final EmbeddableMappingType embeddableMappingType;
    private final ValueExtractor<Object[]> objectArrayExtractor;

    private DB2StructJdbcType() {
        this(null, null);
    }

    public DB2StructJdbcType(EmbeddableMappingType embeddableMappingType, String structTypeName) {
        this.embeddableMappingType = embeddableMappingType;
        this.structTypeName = structTypeName;
        this.objectArrayExtractor = this.createBasicExtractor(new UnknownBasicJavaType<Object[]>(Object[].class));
    }

    @Override
    public int getJdbcTypeCode() {
        return 2009;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 2002;
    }

    @Override
    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new DB2StructJdbcType(mappingType, sqlType);
    }

    @Override
    public EmbeddableMappingType getEmbeddableMappingType() {
        return this.embeddableMappingType;
    }

    @Override
    public String getStructTypeName() {
        return this.structTypeName;
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        if (this.embeddableMappingType == null) {
            return typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)Object[].class));
        }
        return this.embeddableMappingType.getMappedJavaType();
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setSQLXML(index, DB2StructJdbcType.this.createJdbcValue(value, options));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setSQLXML(name, DB2StructJdbcType.this.createJdbcValue(value, options));
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        if (javaType.getJavaTypeClass() == Object[].class) {
            return this.objectArrayExtractor;
        }
        return this.createBasicExtractor(javaType);
    }

    private <X> BasicExtractor<X> createBasicExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getValue(rs.getSQLXML(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getValue(statement.getSQLXML(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getValue(statement.getSQLXML(name), options);
            }

            private X getValue(SQLXML object, WrapperOptions options) throws SQLException {
                if (object == null) {
                    return null;
                }
                return XmlHelper.fromString(DB2StructJdbcType.this.embeddableMappingType, object.getString(), javaType.getJavaTypeClass() != Object[].class, options);
            }
        };
    }

    @Override
    public SQLXML createJdbcValue(Object value, WrapperOptions options) throws SQLException {
        SQLXML sqlxml = options.getSession().getJdbcCoordinator().getLogicalConnection().getPhysicalConnection().createSQLXML();
        sqlxml.setString(XmlHelper.toString(this.embeddableMappingType, value, options));
        return sqlxml;
    }

    @Override
    public Object[] extractJdbcValues(Object rawJdbcValue, WrapperOptions options) throws SQLException {
        return (Object[])XmlHelper.fromString(this.embeddableMappingType, (String)rawJdbcValue, false, options);
    }
}

