/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.OperationIO;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class PathItemOperationIO<V, A extends V, O extends V, AB, OB>
extends OperationIO<V, A, O, AB, OB> {
    public PathItemOperationIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.PATH_ITEM_OPERATION);
    }

    @Override
    public Operation read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@PathItemOperation");
        Operation operation = OASFactory.createOperation();
        operation.setTags(this.processTags(annotation.value("tags")));
        operation.setSummary((String)this.value(annotation, "summary"));
        operation.setDescription((String)this.value(annotation, "description"));
        operation.setExternalDocs((ExternalDocumentation)this.extDocIO().read(annotation.value("externalDocs")));
        operation.setOperationId((String)this.value(annotation, "operationId"));
        operation.setParameters(this.parameterIO().readList(annotation.value("parameters")));
        operation.setRequestBody((RequestBody)this.requestBodyIO().read(annotation.value("requestBody")));
        operation.setResponses(this.apiResponsesIO().read(annotation.value("responses")));
        operation.setCallbacks(this.callbackIO().readMap(annotation.value("callbacks")));
        operation.setDeprecated((Boolean)this.value(annotation, "deprecated"));
        operation.setSecurity(this.securityIO().readRequirements(annotation.value("security"), annotation.value("securitySets")));
        operation.setServers(this.serverIO().readList(annotation.value("servers")));
        operation.setExtensions(this.extensionIO().readExtensible(annotation));
        return operation;
    }

    private List<String> processTags(AnnotationValue tagAnnotations) {
        return Optional.ofNullable(tagAnnotations).map(AnnotationValue::asNestedArray).map(this::processTags).orElse(null);
    }

    private List<String> processTags(AnnotationInstance[] tagAnnotations) {
        LinkedHashSet tagNames = new LinkedHashSet();
        this.tagIO().readList(tagAnnotations).stream().filter(tag -> Objects.nonNull(tag.getName())).forEach(tag -> {
            tagNames.add(tag.getName());
            ModelUtil.addTag(this.scannerContext().getOpenApi(), tag);
        });
        this.tagIO().readReferences(tagAnnotations).forEach(tagNames::add);
        return new ArrayList<String>(tagNames);
    }
}

