/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.LinkedHashSet;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SelectMembersAction
extends AbstractRelationAction {
    private final boolean add;

    public SelectMembersAction(boolean add) {
        this.putValue("ShortDescription", add ? I18n.tr("Add the members of all selected relations to current selection", new Object[0]) : I18n.tr("Select the members of all selected relations", new Object[0]));
        new ImageProvider("selectall").getResource().attachImageIcon(this, true);
        this.putValue("Name", add ? I18n.tr("Select members (add)", new Object[0]) : I18n.tr("Select members", new Object[0]));
        this.add = add;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled() || this.relations.isEmpty() || !MainApplication.isDisplayingMapView()) {
            return;
        }
        LinkedHashSet<IPrimitive> members = new LinkedHashSet<IPrimitive>();
        for (IRelation r : this.relations) {
            members.addAll(r.getMemberPrimitivesList());
        }
        if (this.add) {
            MainApplication.getLayerManager().getActiveData().addSelected(members);
        } else {
            MainApplication.getLayerManager().getActiveData().setSelected(members);
        }
    }
}

