/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.util.Translate;

public class TranslateReader
extends FilterReader {
    private final String _bundle;
    private final I2PAppContext _ctx;
    private final StringBuilder _inBuf;
    private final StringBuilder _outBuf;
    private final StringBuilder _argBuf;
    private final List<String> _args;
    private S _state = S.START;
    private TagHook _hook;
    private static final int MAX_ARGS = 9;

    public TranslateReader(I2PAppContext ctx, String bundle, InputStream in) throws IOException {
        this(ctx, bundle, new BufferedReader(new InputStreamReader(in, "UTF-8")));
    }

    public TranslateReader(I2PAppContext ctx, String bundle, Reader in) throws IOException {
        super(in);
        this._ctx = ctx;
        this._bundle = bundle;
        this._args = new ArrayList<String>(4);
        this._inBuf = new StringBuilder(64);
        this._outBuf = new StringBuilder(64);
        this._argBuf = new StringBuilder(64);
    }

    @Override
    public int read() throws IOException {
        int rv = this.popit();
        if (rv > 0) {
            return rv;
        }
        return this.parse();
    }

    private int parse() throws IOException {
        block42: while (true) {
            int c;
            if ((c = this.in.read()) >= 0) {
                this.pushit((char)c);
            }
            switch (c) {
                case -1: 
                case 10: 
                case 13: {
                    return this.flushit();
                }
                case 95: {
                    switch (this._state) {
                        case START: {
                            this._state = S.UNDER;
                            continue block42;
                        }
                        case BACK: {
                            this._state = S.QUOTE;
                        }
                        case QUOTE: {
                            this._argBuf.append((char)c);
                            continue block42;
                        }
                    }
                    return this.flushit();
                }
                case 40: {
                    switch (this._state) {
                        case UNDER: {
                            this._args.clear();
                            this._state = S.LPAREN;
                            continue block42;
                        }
                        case BACK: {
                            this._state = S.QUOTE;
                        }
                        case QUOTE: {
                            this._argBuf.append((char)c);
                            continue block42;
                        }
                    }
                    return this.flushit();
                }
                case 34: {
                    switch (this._state) {
                        case LPAREN: {
                            if (this._args.size() >= 9) {
                                return this.flushit();
                            }
                            this._argBuf.setLength(0);
                            this._state = S.QUOTE;
                            continue block42;
                        }
                        case BACK: {
                            this._argBuf.append((char)c);
                            this._state = S.QUOTE;
                            continue block42;
                        }
                        case QUOTE: {
                            this._args.add(this._argBuf.toString());
                            this._state = S.LPAREN;
                            continue block42;
                        }
                    }
                    return this.flushit();
                }
                case 92: {
                    switch (this._state) {
                        case QUOTE: {
                            this._state = S.BACK;
                            continue block42;
                        }
                        case BACK: {
                            this._argBuf.append((char)c);
                            this._state = S.QUOTE;
                            continue block42;
                        }
                    }
                    return this.flushit();
                }
                case 9: 
                case 32: 
                case 44: {
                    switch (this._state) {
                        case BACK: {
                            this._state = S.QUOTE;
                        }
                        case QUOTE: {
                            this._argBuf.append((char)c);
                            continue block42;
                        }
                        case LPAREN: {
                            continue block42;
                        }
                    }
                    return this.flushit();
                }
                case 41: {
                    switch (this._state) {
                        case BACK: {
                            this._state = S.QUOTE;
                        }
                        case QUOTE: {
                            this._argBuf.append((char)c);
                            continue block42;
                        }
                        case LPAREN: {
                            this.translate();
                            return this.popit();
                        }
                    }
                    return this.flushit();
                }
            }
            switch (this._state) {
                case BACK: {
                    this._state = S.QUOTE;
                }
                case QUOTE: {
                    this._argBuf.append((char)c);
                    continue block42;
                }
            }
            break;
        }
        return this.flushit();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c < 0) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cbuf[off + i] = (char)c;
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        for (long i = 0L; i < n; ++i) {
            int c = this.read();
            if (c >= 0) continue;
            if (i == 0L) {
                return -1L;
            }
            return i;
        }
        return n;
    }

    @Override
    public boolean ready() throws IOException {
        return this._outBuf.length() > 0 || this._inBuf.length() > 0 || this.in.ready();
    }

    @Override
    public void close() throws IOException {
        this._inBuf.setLength(0);
        this._outBuf.setLength(0);
        this._state = S.START;
        this.in.close();
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void pushit(char c) {
        this._inBuf.append(c);
    }

    private int flushit() {
        this._state = S.START;
        if (this._inBuf.length() > 0) {
            this._outBuf.append((CharSequence)this._inBuf);
            this._inBuf.setLength(0);
        }
        return this.popit();
    }

    private int popit() {
        if (this._outBuf.length() > 0) {
            int rv = this._outBuf.charAt(0) & 0xFFFF;
            this._outBuf.deleteCharAt(0);
            return rv;
        }
        return -1;
    }

    private void translate() {
        int argCount = this._args.size();
        if (argCount <= 0 || argCount > 9) {
            this.flushit();
            return;
        }
        this._state = S.START;
        this._inBuf.setLength(0);
        if (this._hook != null) {
            this._hook.tag(this._args);
            return;
        }
        String tx = null;
        tx = argCount == 1 ? Translate.getString(this._args.get(0), this._ctx, this._bundle) : Translate.getString(this._args.get(0), this._ctx, this._bundle, this._args.subList(1, this._args.size()).toArray());
        this._outBuf.append(tx);
    }

    public static void main(String[] args) {
        try {
            if (args.length >= 2 && args[0].equals("test")) {
                TranslateReader.test(args[1]);
            } else if (args.length >= 2 && args[0].equals("tag")) {
                TranslateReader.tag(args);
            } else {
                System.err.println("Usage:\n\ttest file (output to stdout)\n\ttag file (output to file.java)\n\ttag dir outfile\n\ttag file1 [file2...] outfile");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void test(String file) throws IOException {
        TranslateReader r = null;
        try {
            int c;
            r = new TranslateReader(I2PAppContext.getGlobalContext(), "net.i2p.router.web.messages", new FileInputStream(file));
            while ((c = r.read()) >= 0) {
                System.out.print((char)c);
            }
            System.out.flush();
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tag(String[] files) throws IOException {
        List<String> filelist;
        String outfile;
        char[] buf = new char[256];
        if (files.length == 2) {
            outfile = files[1] + ".java";
            filelist = Collections.singletonList(files[1]);
        } else if (files.length == 3 && new File(files[1]).isDirectory()) {
            outfile = files[2];
            File dir = new File(files[1]);
            File[] listing = dir.listFiles();
            if (listing == null) {
                throw new IOException();
            }
            filelist = new ArrayList<String>(listing.length);
            for (int i = 0; i < listing.length; ++i) {
                File f = listing[i];
                if (f.isDirectory()) continue;
                filelist.add(f.getAbsolutePath());
            }
        } else {
            outfile = files[files.length - 1];
            filelist = Arrays.asList(files).subList(1, files.length - 1);
        }
        try (Tagger tagger = null;){
            tagger = new Tagger(outfile);
            for (String file : filelist) {
                TranslateReader r = null;
                try {
                    r = new TranslateReader(I2PAppContext.getGlobalContext(), null, new FileInputStream(file));
                    r._hook = tagger;
                    while (r.read(buf, 0, buf.length) >= 0) {
                    }
                }
                finally {
                    if (r == null) continue;
                    r.close();
                }
            }
        }
    }

    private static class Tagger
    implements TagHook {
        private final PrintStream _out;
        private final String _name;
        private int _count;

        public Tagger(String file) throws IOException {
            this._name = file;
            this._out = new PrintStream(file, "UTF-8");
            this._out.println("// Automatically generated, do not edit");
            this._out.println("package dummy;");
            this._out.println("class Dummy {");
            this._out.println("    void dummy() {");
        }

        @Override
        public void tag(List<String> args) {
            if (args.size() <= 0) {
                return;
            }
            this._out.print("\t_t(");
            for (int i = 0; i < args.size(); ++i) {
                if (i > 0) {
                    this._out.print(", ");
                }
                this._out.print('\"');
                this._out.print(args.get(i).replace("\"", "\\\""));
                this._out.print('\"');
            }
            this._out.println(");");
            ++this._count;
        }

        @Override
        public void close() throws IOException {
            this._out.println("    }");
            this._out.println("}");
            if (this._out.checkError()) {
                throw new IOException();
            }
            this._out.close();
            System.out.println(this._count + " strings written to " + this._name);
        }
    }

    private static interface TagHook
    extends Closeable {
        public void tag(List<String> var1);
    }

    private static enum S {
        START,
        UNDER,
        LPAREN,
        QUOTE,
        BACK;

    }
}

