/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class WorkMessage
extends AttributeMessage {
    public static final String TAG = "work";
    private static final String UNIT_TAG = "unit";
    private static final String WORK_LOCATION_TAG = "workLocation";

    public WorkMessage(Unit unit, WorkLocation workLocation) {
        super(TAG, UNIT_TAG, unit.getId(), WORK_LOCATION_TAG, workLocation.getId());
    }

    public WorkMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, WORK_LOCATION_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit unit;
        ServerGame game = freeColServer.getGame();
        String unitId = this.getStringAttribute(UNIT_TAG);
        String workLocationId = this.getStringAttribute(WORK_LOCATION_TAG);
        try {
            unit = serverPlayer.getOurFreeColGameObject(unitId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (!unit.hasTile()) {
            return serverPlayer.clientError("Unit is not on the map: " + unitId);
        }
        Colony colony = unit.getTile().getColony();
        if (colony == null) {
            return serverPlayer.clientError("Unit is not at a colony: " + unitId);
        }
        WorkLocation workLocation = game.getFreeColGameObject(workLocationId, WorkLocation.class);
        if (workLocation == null) {
            return serverPlayer.clientError("Not a work location: " + workLocationId);
        }
        if (workLocation.getColony() != colony) {
            return serverPlayer.clientError("Work location is not in colony" + colony.getId() + " where the unit is: " + workLocationId);
        }
        if (!workLocation.canAdd(unit)) {
            return serverPlayer.clientError("Can not add " + unit + " to " + workLocation + ": " + workLocation.getNoAddReason(unit));
        }
        return this.igc(freeColServer).work(serverPlayer, unit, workLocation);
    }
}

