/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.mapviewer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

class TerrainCursor
implements ActionListener {
    public static final int OFF = 0;
    public static final int ON = 1;
    private static final int blinkDelay = 500;
    private boolean active = true;
    private final Timer blinkTimer;
    private final EventListenerList listenerList = new EventListenerList();

    TerrainCursor() {
        this.blinkTimer = new Timer(500, this);
    }

    boolean isActive() {
        return this.active;
    }

    void startBlinking() {
        if (!this.blinkTimer.isRunning()) {
            this.blinkTimer.start();
        }
    }

    void stopBlinking() {
        if (this.blinkTimer.isRunning()) {
            this.blinkTimer.stop();
            this.active = true;
        }
    }

    void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (!this.blinkTimer.isRunning()) {
            return;
        }
        this.active = !this.active;
        int eventId = this.active ? 1 : 0;
        ActionEvent blinkEvent = new ActionEvent(this, eventId, "blink");
        for (ActionListener al : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            al.actionPerformed(blinkEvent);
        }
    }
}

