%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.1
%% Purpose: Encoding and decoding of the types in AttributeCertificateVersion1-2009.

-module('AttributeCertificateVersion1-2009').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("AttributeCertificateVersion1-2009.hrl").
-asn1_info([{vsn,'5.4.1'},
            {module,'AttributeCertificateVersion1-2009'},
            {options,[{i,"/buildroot/otp/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/buildroot/otp/lib/public_key/asn1"},
 {outdir,"/buildroot/otp/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/buildroot/otp/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_AttributeCertificateV1/2,
enc_AttributeCertificateInfoV1/2,
enc_AttCertVersionV1/2
]).

-export([
dec_AttributeCertificateV1/2,
dec_AttributeCertificateInfoV1/2,
dec_AttCertVersionV1/2
]).

-export([
getenc_AttrList/1,
getenc_AttributeCertExtensionsV1/1,
getenc_internal_object_set_argument_7/1,
getenc_internal_object_set_argument_6/1,
getenc_internal_object_set_argument_5/1,
getenc_internal_object_set_argument_4/1
]).

-export([
getdec_AttrList/1,
getdec_AttributeCertExtensionsV1/1,
getdec_internal_object_set_argument_7/1,
getdec_internal_object_set_argument_6/1,
getdec_internal_object_set_argument_5/1,
getdec_internal_object_set_argument_4/1
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('AttributeCertificateV1', Data) -> enc_AttributeCertificateV1(Data);
encode_disp('AttributeCertificateInfoV1', Data) -> enc_AttributeCertificateInfoV1(Data);
encode_disp('AttCertVersionV1', Data) -> enc_AttCertVersionV1(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('AttributeCertificateV1', Data) -> dec_AttributeCertificateV1(Data);
decode_disp('AttributeCertificateInfoV1', Data) -> dec_AttributeCertificateInfoV1(Data);
decode_disp('AttCertVersionV1', Data) -> dec_AttCertVersionV1(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  AttributeCertificateV1
%%================================
enc_AttributeCertificateV1(Val) ->
    enc_AttributeCertificateV1(Val, [<<48>>]).

enc_AttributeCertificateV1(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute toBeSigned(1)   External AttributeCertificateVersion1-2009:AttributeCertificateInfoV1
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_AttributeCertificateInfoV1'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute algorithmIdentifier(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AttributeCertificateV1_algorithmIdentifier'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  AttributeCertificateV1_algorithmIdentifier
%%================================
enc_AttributeCertificateV1_algorithmIdentifier(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'PKIX1Explicit-2009':'getenc_SignatureAlgorithms'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AttributeCertificateV1(Tlv) ->
   dec_AttributeCertificateV1(Tlv, [16]).

dec_AttributeCertificateV1(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute toBeSigned(1)   External AttributeCertificateVersion1-2009:AttributeCertificateInfoV1
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_AttributeCertificateInfoV1'(V1, [16]),

%%-------------------------------------------------
%% attribute algorithmIdentifier(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AttributeCertificateV1_algorithmIdentifier'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'AttributeCertificateV1',Term1,Term2,Term3},
Res1.
'dec_AttributeCertificateV1_algorithmIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'PKIX1Explicit-2009':'getdec_SignatureAlgorithms'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributeCertificateV1_algorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  AttributeCertificateInfoV1
%%================================
enc_AttributeCertificateInfoV1(Val) ->
    enc_AttributeCertificateInfoV1(Val, [<<48>>]).

enc_AttributeCertificateInfoV1(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8,Cindex9} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_1(Cindex1) of
true -> {[],0};
false ->
encode_integer(Cindex1, [{v1,0}], [<<2>>])
       end,

%%-------------------------------------------------
%% attribute subject(2) with type CHOICE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AttributeCertificateInfoV1_subject'(Cindex2, []),

%%-------------------------------------------------
%% attribute issuer(3)   External PKIX1Implicit-2009:GeneralNames
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'PKIX1Implicit-2009':'enc_GeneralNames'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(4) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_AttributeCertificateInfoV1_signature'(Cindex4, [<<48>>]),

%%-------------------------------------------------
%% attribute serialNumber(5) with type INTEGER
%%-------------------------------------------------
   {EncBytes5,EncLen5} = encode_integer(Cindex5, [<<2>>]),

%%-------------------------------------------------
%% attribute attCertValidityPeriod(6)   External PKIXAttributeCertificate-2009:AttCertValidityPeriod
%%-------------------------------------------------
   {EncBytes6,EncLen6} = 'PKIXAttributeCertificate-2009':'enc_AttCertValidityPeriod'(Cindex6, [<<48>>]),

%%-------------------------------------------------
%% attribute attributes(7) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes7,EncLen7} = 'enc_AttributeCertificateInfoV1_attributes'(Cindex7, [<<48>>]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex8, [<<3>>])
       end,

%%-------------------------------------------------
%% attribute extensions(9) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AttributeCertificateInfoV1_extensions'(Cindex9, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  AttributeCertificateInfoV1_subject
%%================================
enc_AttributeCertificateInfoV1_subject(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      baseCertificateID ->
         'PKIXAttributeCertificate-2009':'enc_IssuerSerial'(element(2,Val), [<<48>>,<<160>>]);
      subjectName ->
         'PKIX1Implicit-2009':'enc_GeneralNames'(element(2,Val), [<<48>>,<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  AttributeCertificateInfoV1_signature
%%================================
enc_AttributeCertificateInfoV1_signature(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'AttributeCertificateVersion1-2009':'getenc_internal_object_set_argument_4'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  AttributeCertificateInfoV1_attributes
%%================================
enc_AttributeCertificateInfoV1_attributes(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_AttributeCertificateInfoV1_attributes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AttributeCertificateInfoV1_attributes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttributeCertificateInfoV1_attributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AttributeCertificateInfoV1_attributes_AttributeSet'(H, [<<48>>]),
   'enc_AttributeCertificateInfoV1_attributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  AttributeCertificateInfoV1_attributes_AttributeSet
%%================================
enc_AttributeCertificateInfoV1_attributes_AttributeSet(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'AttributeCertificateVersion1-2009':'getenc_internal_object_set_argument_5'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AttributeCertificateInfoV1_attributes_AttributeSet_values'(Cindex2, [<<49>>], Objtype),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  AttributeCertificateInfoV1_attributes_AttributeSet_values
%%================================
enc_AttributeCertificateInfoV1_attributes_AttributeSet_values(Val, TagIn, ObjFun) ->
      {EncBytes,EncLen} = 'enc_AttributeCertificateInfoV1_attributes_AttributeSet_values_components'(Val, ObjFun,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AttributeCertificateInfoV1_attributes_AttributeSet_values_components'([], _, AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_AttributeCertificateInfoV1_attributes_AttributeSet_values_components'([H|T], ObjFun,AccBytes, AccLen) ->
   {TmpBytes,_} = ObjFun('Type', H, []),
   {EncBytes,EncLen} = encode_open_type(TmpBytes, [])
,
   'enc_AttributeCertificateInfoV1_attributes_AttributeSet_values_components'(T, ObjFun,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  AttributeCertificateInfoV1_extensions
%%================================
enc_AttributeCertificateInfoV1_extensions(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_AttributeCertificateInfoV1_extensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AttributeCertificateInfoV1_extensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttributeCertificateInfoV1_extensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AttributeCertificateInfoV1_extensions_Extension'(H, [<<48>>]),
   'enc_AttributeCertificateInfoV1_extensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  AttributeCertificateInfoV1_extensions_Extension
%%================================
enc_AttributeCertificateInfoV1_extensions_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_2(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AttributeCertificateInfoV1(Tlv) ->
   dec_AttributeCertificateInfoV1(Tlv, [16]).

dec_AttributeCertificateInfoV1(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{2,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, []),
number2name(Val1, [{v1,0}])
end
, TempTlv2};
    _ ->
        {0,Tlv1}
end,

%%-------------------------------------------------
%% attribute subject(2) with type CHOICE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AttributeCertificateInfoV1_subject'(V2, []),

%%-------------------------------------------------
%% attribute issuer(3)   External PKIX1Implicit-2009:GeneralNames
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'PKIX1Implicit-2009':'dec_GeneralNames'(V3, [16]),

%%-------------------------------------------------
%% attribute signature(4) with type SEQUENCE
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_AttributeCertificateInfoV1_signature'(V4, [16]),

%%-------------------------------------------------
%% attribute serialNumber(5) with type INTEGER
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = decode_integer(V5, [2]),

%%-------------------------------------------------
%% attribute attCertValidityPeriod(6)   External PKIXAttributeCertificate-2009:AttCertValidityPeriod
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = 'PKIXAttributeCertificate-2009':'dec_AttCertValidityPeriod'(V6, [16]),

%%-------------------------------------------------
%% attribute attributes(7) with type SEQUENCE OF
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = 'dec_AttributeCertificateInfoV1_attributes'(V7, [16]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{3,V8}|TempTlv9] ->
    {decode_native_bit_string(V8, []), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute extensions(9) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{16,V9}|TempTlv10] ->
    {'dec_AttributeCertificateInfoV1_extensions'(V9, []), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

case Tlv10 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv10}}}) % extra fields not allowed
end,
Res1 = {'AttributeCertificateInfoV1',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9},
Res1.
'dec_AttributeCertificateInfoV1_subject'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'baseCertificateID'
    {131072, V1} -> 
        {baseCertificateID, 'PKIXAttributeCertificate-2009':'dec_IssuerSerial'(V1, [16])};


%% 'subjectName'
    {131073, V1} -> 
        {subjectName, 'PKIX1Implicit-2009':'dec_GeneralNames'(V1, [16])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_AttributeCertificateInfoV1_signature'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'AttributeCertificateVersion1-2009':'getdec_internal_object_set_argument_4'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributeCertificateInfoV1_signature',Term1,Term2},
Res1.
'dec_AttributeCertificateInfoV1_attributes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_AttributeCertificateInfoV1_attributes_AttributeSet'(V1, [16]) || V1 <- Tlv1].


'dec_AttributeCertificateInfoV1_attributes_AttributeSet'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),
ObjFun = 'AttributeCertificateVersion1-2009':'getdec_internal_object_set_argument_5'(Term1),

%%-------------------------------------------------
%% attribute values(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AttributeCertificateInfoV1_attributes_AttributeSet_values'(V2, [17], ObjFun),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'AttributeSet',Term1,Term2},
Res1.
'dec_AttributeCertificateInfoV1_attributes_AttributeSet_values'(Tlv, TagIn, ObjFun) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[
      begin
         Tmptlv1 = decode_open_type(V1, []),
         case (catch ObjFun('Type', Tmptlv1, [])) of
            {'EXIT',Reason1} ->
               exit({'Type not compatible with table constraint', Reason1});
            Tmpterm1 ->
               Tmpterm1
         end
      end
 || V1 <- Tlv1].


'dec_AttributeCertificateInfoV1_extensions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_AttributeCertificateInfoV1_extensions_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_AttributeCertificateInfoV1_extensions_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  AttCertVersionV1
%%================================
enc_AttCertVersionV1(Val) ->
    enc_AttCertVersionV1(Val, [<<2>>]).

enc_AttCertVersionV1(Val, TagIn) ->
encode_integer(Val, [{v1,0}], TagIn).


dec_AttCertVersionV1(Tlv) ->
   dec_AttCertVersionV1(Tlv, [2]).

dec_AttCertVersionV1(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
number2name(Val1, [{v1,0}])
end
.




%%================================
%%  AttrList
%%================================
getenc_AttrList(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_AttrList(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  AttributeCertExtensionsV1
%%================================
getenc_AttributeCertExtensionsV1(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_AttributeCertExtensionsV1(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_7
%%================================
getenc_internal_object_set_argument_7(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_7(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_6
%%================================
getenc_internal_object_set_argument_6(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_6(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_5
%%================================
getenc_internal_object_set_argument_5(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_5(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_4
%%================================
getenc_internal_object_set_argument_4(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_4(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

is_default_1(asn1_DEFAULT) ->
true;
is_default_1(Value) ->
try check_int(Value, 0, [{v1,0}]) of
_ -> true
catch throw:false -> false
end.


is_default_2(asn1_DEFAULT) ->
true;
is_default_2(Def) when Def =:= false ->
true;
is_default_2(_) ->
false.


ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

check_int(Value, Value, _) when is_integer(Value) ->
    true;
check_int(Value, DefValue, NNL) when is_atom(Value) ->
    case lists:keyfind(Value, 1, NNL) of
        {_, DefValue} ->
            true;
        _ ->
            throw(false)
    end;
check_int(_, _, _) ->
    throw(false).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_boolean(Tlv, TagIn) ->
    Val = match_tags(Tlv, TagIn),
    case Val of
        <<0:8>> ->
            false;
        <<_:8>> ->
            true;
        _ ->
            exit({error, {asn1, {decode_boolean, Val}}})
    end.

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_native_bit_string(Buffer, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            <<>>;
        <<Unused,Bits/binary>> ->
            Size = bit_size(Bits) - Unused,
            <<Val:Size/bitstring,_:Unused/bitstring>> = Bits,
            Val
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

dynamicsort_SETOF(ListOfEncVal) ->
    BinL =
        lists:map(fun(L) when is_list(L) ->
                         list_to_binary(L);
                     (B) ->
                         B
                  end,
                  ListOfEncVal),
    lists:sort(BinL).

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_boolean(true, TagIn) ->
    encode_tags(TagIn, [255], 1);
encode_boolean(false, TagIn) ->
    encode_tags(TagIn, [0], 1);
encode_boolean(X, _) ->
    exit({error, {asn1, {encode_boolean, X}}}).

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, NamedNumberList, Tag) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedNumberList) of
        {_, NewVal} ->
            encode_tags(Tag, encode_integer(NewVal));
        _ ->
            exit({error, {asn1, {encode_integer_namednumber, Val}}})
    end;
encode_integer(Val, _NamedNumberList, Tag) ->
    encode_tags(Tag, encode_integer(Val)).

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

encode_unnamed_bit_string(Bits, TagIn) ->
    Unused = (8 - bit_size(Bits) band 7) band 7,
    Bin = <<Unused,Bits/bitstring,0:Unused>>,
    encode_tags(TagIn, Bin, byte_size(Bin)).

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).

number2name(Int, NamedNumberList) ->
    case lists:keyfind(Int, 2, NamedNumberList) of
        {NamedVal, _} ->
            NamedVal;
        _ ->
            Int
    end.
