/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.vmconversion;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;

public class AsciiProgressBar
implements Runnable {
    private long total;
    private long completed;
    private long startTime;
    private final int MAX_ASCIIBAR_LENGTH = 80;
    private final int MAX_PROGRESS_BAR_OVERALL = 32;
    private final int MAX_PROGRESS_BAR_EQUALS = 20;
    private final int TIME_FORMAT_MAX_LENGTH = 20;
    private final int BAR_REFRESH_INTERVAL_MILLISECONDS = 100;
    private BarCallerType barCallerType;
    private PrintStream out;

    public AsciiProgressBar(long total_, long startTime_, BarCallerType barCallerType_, PrintStream out_) {
        this.total = total_;
        this.out = out_;
        this.completed = 0L;
        this.startTime = startTime_;
        this.barCallerType = barCallerType_;
    }

    public void updateCompleted(long amount) {
        this.completed = amount;
    }

    private String getDurationBreakdown(long millis) {
        if (millis < 0L) {
            return "";
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        String timeHumanReadable = "";
        if (days > 0L) {
            timeHumanReadable = timeHumanReadable + String.format("%02d", days) + " days ";
        }
        if (hours > 0L) {
            timeHumanReadable = timeHumanReadable + String.format("%02d", hours) + "h ";
        }
        if (minutes > 0L) {
            timeHumanReadable = timeHumanReadable + String.format("%02d", minutes) + "m ";
        }
        if (seconds > 0L) {
            timeHumanReadable = timeHumanReadable + String.format("%02d", seconds) + "s ";
        }
        return timeHumanReadable;
    }

    private String fancyProgressString(long completed, long total) {
        int i;
        if (total <= 0L) {
            return "";
        }
        StringBuilder bar = new StringBuilder(80);
        int progressPercentage = (int)(completed * 100L / total);
        bar.append(String.format("%03d", progressPercentage) + "% [");
        int numberOfEquals = (int)(completed * 20L / total);
        for (i = 0; i < numberOfEquals; ++i) {
            bar.append("=");
        }
        bar.append(">");
        for (i = 0; i < 20 - numberOfEquals; ++i) {
            bar.append(".");
        }
        bar.append("] ");
        return bar.toString();
    }

    private String getEstimatedSpeed(long timeDiff) {
        String estimatedSpeed = "Not Available";
        if (this.completed > 0L && timeDiff > 0L && this.barCallerType == BarCallerType.IMPORTER) {
            estimatedSpeed = String.format("%.3f MBps", (double)this.completed / (double)(timeDiff * 1000L));
        }
        return estimatedSpeed;
    }

    private String getEstimatedTime(long timeDiff) {
        String estimatedTime = String.format("%-20s", "Not Available");
        if (this.completed > 0L) {
            long estimatedTimeInMilliS = (long)Math.ceil((double)(timeDiff * (this.total - this.completed)) / (double)this.completed);
            String estimatedTimeHumanReadable = this.getDurationBreakdown(estimatedTimeInMilliS);
            estimatedTime = String.format("%-20s", estimatedTimeHumanReadable);
        }
        return estimatedTime;
    }

    private void printProgressStatusBar(String estimatedTime, String estimatedSpeed, char x) {
        String uploadStatusMsg = "";
        switch (this.barCallerType) {
            case IMPORTER: {
                uploadStatusMsg = " " + x + " " + this.fancyProgressString(this.completed, this.total) + estimatedTime + estimatedSpeed;
                break;
            }
            case DISKDELETER: {
                uploadStatusMsg = " " + x + " " + this.fancyProgressString(this.completed, this.total) + estimatedTime;
            }
        }
        this.out.print("\r" + String.format("%-80s", uploadStatusMsg));
    }

    private boolean printSummaryStatusBarIfCompleted(long timeDiff) {
        boolean isComplete = false;
        if (this.completed >= this.total) {
            String summaryMessage = "";
            String totalProcessTime = this.getDurationBreakdown(timeDiff);
            switch (this.barCallerType) {
                case IMPORTER: {
                    summaryMessage = "********************* All " + this.completed + " Bytes uploaded in " + totalProcessTime + " *********************";
                    break;
                }
                case DISKDELETER: {
                    summaryMessage = "********************* All " + this.completed + " parts deleted in " + totalProcessTime + " *********************";
                }
            }
            this.out.print("\n" + String.format("%-80s", summaryMessage));
            isComplete = true;
        }
        return isComplete;
    }

    private void waitBeforeRefreshing() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        int count = 0;
        char[] progressDisplayChars = new char[]{'|', '/', '-', '\\'};
        while (!Thread.currentThread().isInterrupted()) {
            char x = progressDisplayChars[count % 4];
            long currTime = System.currentTimeMillis();
            long timeDiff = currTime - this.startTime;
            String estimatedTime = this.getEstimatedTime(timeDiff);
            String estimatedSpeed = this.getEstimatedSpeed(timeDiff);
            this.printProgressStatusBar(estimatedTime, estimatedSpeed, x);
            if (this.printSummaryStatusBarIfCompleted(timeDiff)) break;
            this.waitBeforeRefreshing();
            ++count;
        }
    }

    public void preamble() {
        for (int i = 0; i < 100; ++i) {
            this.out.print("-");
        }
        String header = "";
        switch (this.barCallerType) {
            case IMPORTER: {
                header = String.format("%-32s", "   Upload progress") + String.format("%-20s", "Estimated time") + "Estimated speed";
                break;
            }
            case DISKDELETER: {
                header = String.format("%-32s", "   Delete progress") + "Estimated time";
            }
        }
        this.out.print("\n" + header + "\n");
    }

    public void postamble() {
        switch (this.barCallerType) {
            case IMPORTER: {
                this.out.println("\nDone uploading.");
                break;
            }
            case DISKDELETER: {
                this.out.println("\nDone deleting.");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BarCallerType {
        IMPORTER,
        DISKDELETER;

    }
}

